/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.mutations;

import forestry.api.core.EnumHumidity;
import forestry.api.core.IClimateProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutationCondition;
import forestry.core.utils.StringUtil;
import net.minecraft.world.World;

public class MutationConditionHumidity
implements IMutationCondition {
    private final EnumHumidity minHumidity;
    private final EnumHumidity maxHumidity;

    public MutationConditionHumidity(EnumHumidity minHumidity, EnumHumidity maxHumidity) {
        this.minHumidity = minHumidity;
        this.maxHumidity = maxHumidity;
    }

    @Override
    public float getChance(World world, int x, int y, int z, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1, IClimateProvider climate) {
        EnumHumidity biomeHumidity = climate.getHumidity();
        if (biomeHumidity.ordinal() < this.minHumidity.ordinal() || biomeHumidity.ordinal() > this.maxHumidity.ordinal()) {
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public String getDescription() {
        String minHumidityString = AlleleManager.climateHelper.toDisplay(this.minHumidity);
        if (this.minHumidity != this.maxHumidity) {
            String maxHumidityString = AlleleManager.climateHelper.toDisplay(this.maxHumidity);
            return StringUtil.localize("mutation.condition.humidity.range").replace("%LOW", minHumidityString).replace("%HIGH", maxHumidityString);
        }
        return StringUtil.localizeAndFormat("mutation.condition.humidity.single", minHumidityString);
    }
}

