/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkStorageEvent;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartDeprecated;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.client.texture.CableBusTextures;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.ItemMultiPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.container.ContainerBusFluidStorage;
import extracells.gui.GuiBusFluidStorage;
import extracells.integration.Integration;
import extracells.integration.ae2fc.FluidCraft;
import extracells.inventory.HandlerPartStorageFluid;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.network.packet.other.PacketFluidSlot;
import extracells.network.packet.part.PacketBusFluidStorage;
import extracells.part.PartECBase;
import extracells.registries.PartEnum;
import extracells.render.TextureManager;
import extracells.util.PermissionUtil;
import extracells.util.inventory.ECPrivateInventory;
import extracells.util.inventory.IInventoryUpdateReceiver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class PartFluidStorage
extends PartECBase
implements ICellContainer,
IInventoryUpdateReceiver,
IFluidSlotPartOrBlock,
IPriorityHost,
IPartDeprecated {
    private final HashMap<IAEFluidStack, Long> fluidList = new HashMap();
    private int priority = 0;
    protected HandlerPartStorageFluid handler = new HandlerPartStorageFluid(this);
    private final Fluid[] filterFluids = new Fluid[54];
    private AccessRestriction access = AccessRestriction.READ_WRITE;
    private final ECPrivateInventory upgradeInventory = new ECPrivateInventory("", 1, 1, this){

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return itemStack != null && AEApi.instance().definitions().materials().cardInverter().isSameAs(itemStack);
        }
    };
    private static int[] FILTER_MAP = null;

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack stack : this.upgradeInventory.slots) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    public void blinkCell(int slot) {
    }

    @Override
    public int cableConnectionRenderTo() {
        return 3;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 15.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 15.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        ArrayList<IMEInventoryHandler> list = new ArrayList<IMEInventoryHandler>();
        if (channel == StorageChannel.FLUIDS) {
            list.add(this.handler);
        }
        this.updateNeighborFluids();
        return list;
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiBusFluidStorage(this, player);
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int getLightLevel() {
        return this.isPowered() ? 9 : 0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerBusFluidStorage(this, player);
    }

    public ECPrivateInventory getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        return PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this) && super.onActivate(player, pos);
    }

    @Override
    public void onInventoryChanged() {
        this.handler.setInverted(AEApi.instance().definitions().materials().cardInverter().isSameAs(this.upgradeInventory.func_70301_a(0)));
        this.saveData();
    }

    @Override
    public void onNeighborChanged() {
        this.handler.onNeighborChange();
        IGridNode node = this.getGridNode();
        if (node != null) {
            IGrid grid = node.getGrid();
            if (grid != null && this.wasChanged()) {
                grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
                node.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(this.getGridBlock().getFluidMonitor(), StorageChannel.FLUIDS));
                node.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            this.getHost().markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public void powerChange(MENetworkPowerStatusChange event) {
        boolean isNowActive;
        IGridNode node = this.getGridNode();
        if (node != null && (isNowActive = node.isActive()) != this.isActive()) {
            this.setActive(isNowActive);
            this.onNeighborChanged();
            this.getHost().markForUpdate();
        }
        node.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(this.getGridBlock().getFluidMonitor(), StorageChannel.FLUIDS));
        node.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.priority = data.func_74762_e("priority");
        for (int i = 0; i < 54; ++i) {
            this.filterFluids[i] = FluidRegistry.getFluid((String)data.func_74779_i("FilterFluid#" + i));
        }
        if (data.func_74764_b("access")) {
            try {
                this.access = AccessRestriction.valueOf((String)data.func_74779_i("access"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.upgradeInventory.readFromNBT(data.func_150295_c("upgradeInventory", 10));
        this.onInventoryChanged();
        this.onNeighborChanged();
        this.handler.setPrioritizedFluids(this.filterFluids);
        this.handler.setAccessRestriction(this.access);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        IIcon sideTexture = CableBusTextures.PartStorageSides.getIcon();
        IIcon backTexture = CableBusTextures.PartStorageBack.getIcon();
        IIcon frontTexture = TextureManager.STORAGE_FRONT.getTexture();
        IIcon noTexture = ItemMultiPart.instance.func_77617_a(220);
        rh.setTexture(sideTexture, sideTexture, noTexture, frontTexture, sideTexture, sideTexture);
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setTexture(sideTexture, sideTexture, backTexture, noTexture, sideTexture, sideTexture);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 15.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(2.0f, 2.0f, 15.0f, 14.0f, 14.0f, 16.0f);
        rh.setInvColor(AEColor.Cyan.blackVariant);
        Tessellator.field_78398_a.func_78380_c(0xF000F0);
        rh.renderInventoryFace(TextureManager.STORAGE_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        IPartHost host = this.getHost();
        IIcon sideTexture = CableBusTextures.PartStorageSides.getIcon();
        IIcon backTexture = CableBusTextures.PartStorageBack.getIcon();
        IIcon frontTexture = TextureManager.STORAGE_FRONT.getTexture();
        IIcon noTexture = ItemMultiPart.instance.func_77617_a(220);
        rh.setTexture(sideTexture, sideTexture, noTexture, frontTexture, sideTexture, sideTexture);
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        Tessellator.field_78398_a.func_78378_d(host.getColor().blackVariant);
        if (this.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xE000E0);
        }
        rh.renderFace(x, y, z, TextureManager.STORAGE_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setTexture(sideTexture, sideTexture, backTexture, noTexture, sideTexture, sideTexture);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 15.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        this.renderPowerStatus(x, y, z, rh, renderer);
    }

    public void saveChanges(IMEInventory cellInventory) {
        this.saveData();
    }

    public void sendInformation(EntityPlayer player) {
        new PacketFluidSlot(Arrays.asList(this.filterFluids)).sendPacketToPlayer(player);
        new PacketBusFluidStorage(player, this.access, true).sendPacketToPlayer(player);
    }

    @Override
    public void setFluid(int _index, Fluid _fluid, EntityPlayer _player) {
        this.filterFluids[_index] = _fluid;
        this.handler.setPrioritizedFluids(this.filterFluids);
        this.sendInformation(_player);
        this.saveData();
    }

    public void updateAccess(AccessRestriction access) {
        this.access = access;
        this.handler.setAccessRestriction(access);
        this.onNeighborChanged();
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged channel) {
        boolean isNowActive;
        IGridNode node = this.getGridNode();
        if (node != null && (isNowActive = node.isActive()) != this.isActive()) {
            this.setActive(isNowActive);
            this.onNeighborChanged();
            this.getHost().markForUpdate();
        }
        node.getGrid().postEvent((MENetworkEvent)new MENetworkStorageEvent(this.getGridBlock().getFluidMonitor(), StorageChannel.FLUIDS));
        node.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("priority", this.priority);
        for (int i = 0; i < this.filterFluids.length; ++i) {
            Fluid fluid = this.filterFluids[i];
            if (fluid != null) {
                data.func_74778_a("FilterFluid#" + i, fluid.getName());
                continue;
            }
            data.func_74778_a("FilterFluid#" + i, "");
        }
        data.func_74782_a("upgradeInventory", (NBTBase)this.upgradeInventory.writeToNBT());
        data.func_74778_a("access", this.access.name());
    }

    private void updateNeighborFluids() {
        this.fluidList.clear();
        if (this.access == AccessRestriction.READ || this.access == AccessRestriction.READ_WRITE) {
            for (IAEFluidStack stack : this.handler.getAvailableItems((IItemList<IAEFluidStack>)AEApi.instance().storage().createFluidList())) {
                this.fluidList.put(stack, stack.getStackSize());
            }
        }
    }

    private boolean wasChanged() {
        HashMap<IAEFluidStack, Long> fluids = new HashMap<IAEFluidStack, Long>();
        for (IAEFluidStack stack : this.handler.getAvailableItems((IItemList<IAEFluidStack>)AEApi.instance().storage().createFluidList())) {
            fluids.put(stack, stack.getStackSize());
        }
        return !fluids.equals(this.fluidList);
    }

    public NBTTagCompound transformPart(NBTTagCompound def) {
        if (Integration.Mods.FLUIDCRAFT.isEnabled()) {
            FluidCraft.replace(def, PartEnum.FLUIDSTORAGE);
        }
        return def;
    }

    public NBTTagCompound transformNBT(NBTTagCompound extra) {
        if (Integration.Mods.FLUIDCRAFT.isEnabled()) {
            NBTTagCompound fluidFilterNew = new NBTTagCompound();
            for (int slot = 0; slot < this.filterFluids.length; ++slot) {
                String oldFilterName = "FilterFluid#" + slot;
                fluidFilterNew.func_74782_a("#" + FILTER_MAP[slot], (NBTBase)FluidCraft.createFluidDisplay(extra.func_74779_i(oldFilterName)));
                extra.func_82580_o(oldFilterName);
            }
            extra.func_74782_a("config", (NBTBase)fluidFilterNew);
            extra.func_74782_a("part", (NBTBase)extra.func_74775_l("node").func_74775_l("node0"));
            extra.func_82580_o("node");
            extra.func_74778_a("ACCESS", extra.func_74779_i("access"));
            extra.func_82580_o("access");
            NBTTagList upgrades = extra.func_150295_c("upgradeInventory", 10);
            NBTTagCompound upgradeNew = new NBTTagCompound();
            upgradeNew.func_74782_a("#0", (NBTBase)upgrades.func_150305_b(0));
            upgradeNew.func_74782_a("#1", (NBTBase)new NBTTagCompound());
            upgradeNew.func_74782_a("#2", (NBTBase)new NBTTagCompound());
            upgradeNew.func_74782_a("#3", (NBTBase)new NBTTagCompound());
            upgradeNew.func_74782_a("#4", (NBTBase)new NBTTagCompound());
            extra.func_74782_a("upgrades", (NBTBase)upgradeNew);
            extra.func_82580_o("upgradeInventory");
        }
        return extra;
    }

    static {
        if (Integration.Mods.FLUIDCRAFT.isEnabled()) {
            FILTER_MAP = new int[]{0, 9, 18, 27, 36, 45, 1, 10, 19, 28, 37, 46, 2, 11, 20, 29, 38, 47, 3, 12, 21, 30, 39, 48, 4, 13, 22, 31, 40, 49, 5, 14, 23, 32, 41, 50, 6, 15, 24, 33, 42, 51, 7, 16, 25, 34, 43, 52, 8, 17, 26, 35, 44, 53};
        }
    }
}

