/*
 * Decompiled with CFR 0.152.
 */
package extracells.inventory;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import extracells.api.ECApi;
import extracells.api.IFluidStorageCell;
import extracells.api.IHandlerFluidStorage;
import extracells.container.ContainerFluidStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class HandlerItemStorageFluid
implements IMEInventoryHandler<IAEFluidStack>,
IHandlerFluidStorage {
    private NBTTagCompound stackTag;
    protected ArrayList<FluidStack> fluidStacks = new ArrayList();
    private ArrayList<Fluid> prioritizedFluids = new ArrayList();
    private int totalTypes;
    private int totalBytes;
    private List<ContainerFluidStorage> containers = new ArrayList<ContainerFluidStorage>();
    private ISaveProvider saveProvider;

    public HandlerItemStorageFluid(ItemStack _storageStack, ISaveProvider _saveProvider) {
        if (!_storageStack.func_77942_o()) {
            _storageStack.func_77982_d(new NBTTagCompound());
        }
        this.stackTag = _storageStack.func_77978_p();
        this.totalTypes = ((IFluidStorageCell)_storageStack.func_77973_b()).getMaxTypes(_storageStack);
        this.totalBytes = ((IFluidStorageCell)_storageStack.func_77973_b()).getMaxBytes(_storageStack) * 250;
        for (int i = 0; i < this.totalTypes; ++i) {
            this.fluidStacks.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)this.stackTag.func_74775_l("Fluid#" + i)));
        }
        this.saveProvider = _saveProvider;
    }

    public HandlerItemStorageFluid(ItemStack _storageStack, ISaveProvider _saveProvider, ArrayList<Fluid> _filter) {
        this(_storageStack, _saveProvider);
        if (_filter != null) {
            this.prioritizedFluids = _filter;
        }
    }

    private boolean allowedByFormat(Fluid fluid) {
        return !this.isFormatted() || this.prioritizedFluids.contains(fluid);
    }

    public boolean canAccept(IAEFluidStack input) {
        if (input == null) {
            return false;
        }
        if (!ECApi.instance().canStoreFluid(input.getFluid())) {
            return false;
        }
        for (FluidStack fluidStack : this.fluidStacks) {
            if (fluidStack != null && fluidStack.getFluid() != input.getFluid()) continue;
            return this.allowedByFormat(input.getFluid());
        }
        return false;
    }

    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource src) {
        if (request == null || !this.allowedByFormat(request.getFluid())) {
            return null;
        }
        for (int i = 0; i < this.fluidStacks.size(); ++i) {
            IAEFluidStack removedStack;
            FluidStack currentStack = this.fluidStacks.get(i);
            if (currentStack == null || currentStack.getFluidID() != request.getFluid().getID()) continue;
            long endAmount = (long)currentStack.amount - request.getStackSize();
            if (endAmount >= 0L) {
                removedStack = request.copy();
                FluidStack toWrite = new FluidStack(currentStack.getFluid(), (int)endAmount);
                if (mode == Actionable.MODULATE) {
                    this.writeFluidToSlot(i, toWrite);
                }
            } else {
                removedStack = AEApi.instance().storage().createFluidStack(currentStack);
                if (mode == Actionable.MODULATE) {
                    this.writeFluidToSlot(i, null);
                }
            }
            if (removedStack != null && removedStack.getStackSize() > 0L) {
                this.requestSave();
            }
            return removedStack;
        }
        return null;
    }

    public int freeBytes() {
        int i = 0;
        for (FluidStack stack : this.fluidStacks) {
            if (stack == null) continue;
            i += stack.amount;
        }
        return this.totalBytes - i;
    }

    public AccessRestriction getAccess() {
        return AccessRestriction.READ_WRITE;
    }

    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        for (FluidStack fluidStack : this.fluidStacks) {
            if (fluidStack == null) continue;
            out.add((IAEStack)AEApi.instance().storage().createFluidStack(fluidStack));
        }
        return out;
    }

    public StorageChannel getChannel() {
        return StorageChannel.FLUIDS;
    }

    public int getPriority() {
        return 0;
    }

    public int getSlot() {
        return 0;
    }

    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource src) {
        if (input == null || !this.allowedByFormat(input.getFluid())) {
            return input;
        }
        int targetSlot = -1;
        int emptySlot = -1;
        for (int i = 0; i < this.fluidStacks.size(); ++i) {
            FluidStack stack = this.fluidStacks.get(i);
            if (stack != null && stack.getFluid().getID() == input.getFluid().getID()) {
                targetSlot = i;
                break;
            }
            if (stack != null || emptySlot >= 0) continue;
            emptySlot = i;
        }
        if (targetSlot < 0) {
            targetSlot = emptySlot;
        }
        if (targetSlot < 0) {
            return input;
        }
        FluidStack originalTargetContents = this.fluidStacks.get(targetSlot);
        long originalTargetAmount = originalTargetContents != null ? (long)originalTargetContents.amount : 0L;
        long requestedAmount = input.getStackSize();
        long freeSpace = this.freeBytes();
        long drainedAmount = Long.min(requestedAmount, freeSpace);
        if (mode == Actionable.MODULATE) {
            Fluid fluidInserted = originalTargetContents != null ? originalTargetContents.getFluid() : input.getFluid();
            this.writeFluidToSlot(targetSlot, new FluidStack(fluidInserted, (int)(originalTargetAmount + drainedAmount)));
            this.requestSave();
        }
        if (drainedAmount == requestedAmount) {
            return null;
        }
        IAEFluidStack notAdded = input.copy();
        notAdded.setStackSize(requestedAmount - drainedAmount);
        return notAdded;
    }

    @Override
    public boolean isFormatted() {
        if (this.prioritizedFluids.isEmpty()) {
            return false;
        }
        for (Fluid currentFluid : this.prioritizedFluids) {
            if (currentFluid == null) continue;
            return true;
        }
        return false;
    }

    public boolean isPrioritized(IAEFluidStack input) {
        return input != null && this.prioritizedFluids.contains(input.getFluid());
    }

    private void requestSave() {
        if (this.saveProvider != null) {
            this.saveProvider.saveChanges((IMEInventory)this);
        }
    }

    @Override
    public int totalBytes() {
        return this.totalBytes;
    }

    @Override
    public int totalTypes() {
        return this.totalTypes;
    }

    @Override
    public int usedBytes() {
        return this.totalBytes - this.freeBytes();
    }

    @Override
    public int usedTypes() {
        int i = 0;
        for (FluidStack stack : this.fluidStacks) {
            if (stack == null) continue;
            ++i;
        }
        return i;
    }

    public boolean validForPass(int i) {
        return true;
    }

    protected void writeFluidToSlot(int i, FluidStack fluidStack) {
        NBTTagCompound fluidTag = new NBTTagCompound();
        if (fluidStack != null && fluidStack.getFluidID() > 0 && fluidStack.amount > 0) {
            fluidStack.writeToNBT(fluidTag);
            this.stackTag.func_74782_a("Fluid#" + i, (NBTBase)fluidTag);
        } else {
            this.stackTag.func_82580_o("Fluid#" + i);
        }
        this.fluidStacks.set(i, fluidStack);
    }
}

