/*
 * Decompiled with CFR 0.152.
 */
package extracells.integration.ae2fc;

import appeng.util.item.AEItemStack;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLModIdMappingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import extracells.registries.PartEnum;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public final class FluidCraft {
    private static final Map<PartEnum, Short> REPLACER = new HashMap<PartEnum, Short>(16);

    @Optional.Method(modid="ae2fc")
    public static void onRemapEvent(FMLModIdMappingEvent event) {
        REPLACER.put(PartEnum.FLUIDEXPORT, (short)Item.func_150891_b((Item)GameRegistry.findItem((String)"ae2fc", (String)"part_fluid_export")));
        REPLACER.put(PartEnum.FLUIDIMPORT, (short)Item.func_150891_b((Item)GameRegistry.findItem((String)"ae2fc", (String)"part_fluid_import")));
        REPLACER.put(PartEnum.FLUIDSTORAGE, (short)Item.func_150891_b((Item)GameRegistry.findItem((String)"ae2fc", (String)"part_fluid_storage_bus")));
        REPLACER.put(PartEnum.FLUIDLEVELEMITTER, (short)Item.func_150891_b((Item)GameRegistry.findItem((String)"ae2fc", (String)"part_fluid_level_emitter")));
        REPLACER.put(PartEnum.FLUIDMONITOR, (short)Item.func_150891_b((Item)GameRegistry.findItem((String)"ae2fc", (String)"part_fluid_storage_monitor")));
        REPLACER.put(PartEnum.FLUIDCONVERSIONMONITOR, (short)Item.func_150891_b((Item)GameRegistry.findItem((String)"ae2fc", (String)"part_fluid_conversion_monitor")));
        REPLACER.put(PartEnum.INTERFACE, (short)Item.func_150891_b((Item)GameRegistry.findItem((String)"ae2fc", (String)"part_fluid_interface")));
    }

    public static void replace(NBTTagCompound def, PartEnum part) {
        def.func_74777_a("id", REPLACER.getOrDefault((Object)part, (short)0).shortValue());
        def.func_74777_a("Damage", (short)0);
    }

    @Optional.Method(modid="ae2fc")
    public static NBTTagCompound createFluidDisplay(String fluidName) {
        NBTTagCompound fluidDisplay = new NBTTagCompound();
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        if (fluid != null) {
            ItemStack fluidPacket = new ItemStack(GameRegistry.findItem((String)"ae2fc", (String)"fluid_packet"), 1, 0);
            NBTTagCompound fluidPacketTag = new NBTTagCompound();
            FluidStack fluidStack = new FluidStack(fluid, 1000);
            NBTTagCompound fluidStackNbt = new NBTTagCompound();
            fluidStack.writeToNBT(fluidStackNbt);
            fluidPacketTag.func_74782_a("FluidStack", (NBTBase)fluidStackNbt);
            fluidPacketTag.func_74757_a("DisplayOnly", true);
            fluidPacket.func_77982_d(fluidPacketTag);
            AEItemStack aeStack = AEItemStack.create((ItemStack)fluidPacket);
            aeStack.writeToNBT(fluidDisplay);
        }
        return fluidDisplay;
    }

    public static NBTTagCompound createFluidNBT(String fluidName, long amount) {
        NBTTagCompound fluid = new NBTTagCompound();
        fluid.func_74778_a("FluidName", fluidName);
        fluid.func_74757_a("Craft", false);
        fluid.func_74772_a("Req", 0L);
        fluid.func_74772_a("Cnt", amount);
        return fluid;
    }
}

