/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui.widget.fluid;

import appeng.api.storage.data.IAEFluidStack;
import extracells.gui.widget.fluid.AbstractFluidWidget;
import extracells.gui.widget.fluid.IFluidSelectorGui;
import extracells.util.FluidUtil;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class WidgetFluidSelector
extends AbstractFluidWidget {
    private long amount = 0L;
    private int color;
    private int borderThickness;

    public WidgetFluidSelector(IFluidSelectorGui guiFluidTerminal, IAEFluidStack stack) {
        super(guiFluidTerminal, 18, 18, stack.getFluidStack().getFluid());
        this.amount = stack.getStackSize();
        this.color = -16711681;
        this.borderThickness = 1;
    }

    private void drawHollowRectWithCorners(int posX, int posY, int height, int width, int color, int thickness) {
        WidgetFluidSelector.func_73734_a((int)posX, (int)posY, (int)(posX + height), (int)(posY + thickness), (int)color);
        WidgetFluidSelector.func_73734_a((int)posX, (int)(posY + width - thickness), (int)(posX + height), (int)(posY + width), (int)color);
        WidgetFluidSelector.func_73734_a((int)posX, (int)posY, (int)(posX + thickness), (int)(posY + width), (int)color);
        WidgetFluidSelector.func_73734_a((int)(posX + height - thickness), (int)posY, (int)(posX + height), (int)(posY + width), (int)color);
        WidgetFluidSelector.func_73734_a((int)posX, (int)posY, (int)(posX + thickness + 1), (int)(posY + thickness + 1), (int)color);
        WidgetFluidSelector.func_73734_a((int)(posX + height), (int)(posY + width), (int)(posX + height - thickness - 1), (int)(posY + width - thickness - 1), (int)color);
        WidgetFluidSelector.func_73734_a((int)(posX + height), (int)posY, (int)(posX + height - thickness - 1), (int)(posY + thickness + 1), (int)color);
        WidgetFluidSelector.func_73734_a((int)posX, (int)(posY + width), (int)(posX + thickness + 1), (int)(posY + width - thickness - 1), (int)color);
    }

    @Override
    public boolean drawTooltip(int posX, int posY, int mouseX, int mouseY) {
        if (this.fluid == null || this.amount <= 0L || !this.isPointInRegion(posX, posY, this.height, this.width, mouseX, mouseY)) {
            return false;
        }
        String amountToText = FluidUtil.formatFluidAmount(this.amount, true);
        ArrayList<String> description = new ArrayList<String>();
        description.add(this.fluid.getLocalizedName(new FluidStack(this.fluid, 0)));
        description.add(amountToText);
        this.drawHoveringText(description, mouseX - this.guiFluidTerminal.guiLeft(), mouseY - this.guiFluidTerminal.guiTop() + 18, Minecraft.func_71410_x().field_71466_p);
        return true;
    }

    @Override
    public void drawWidget(int posX, int posY) {
        Fluid currentFluid;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        IAEFluidStack terminalFluid = ((IFluidSelectorGui)this.guiFluidTerminal).getCurrentFluid();
        Fluid fluid = currentFluid = terminalFluid != null ? terminalFluid.getFluid() : null;
        if (this.fluid != null && this.fluid.getIcon() != null) {
            GL11.glColor3f((float)((float)(this.fluid.getColor() >> 16 & 0xFF) / 255.0f), (float)((float)(this.fluid.getColor() >> 8 & 0xFF) / 255.0f), (float)((float)(this.fluid.getColor() & 0xFF) / 255.0f));
            this.func_94065_a(posX + 1, posY + 1, this.fluid.getIcon(), this.height - 2, this.width - 2);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        float scaleFactor = 0.5f;
        float inverseScaleFactor = 2.0f;
        float offset = -1.0f;
        String stackSize = FluidUtil.formatFluidAmount(this.amount);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glPushMatrix();
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        int X = (int)(((float)posX + -1.0f + 16.0f - (float)fontRenderer.func_78256_a(stackSize) * 0.5f) * 2.0f);
        int Y = (int)(((float)posY + -1.0f + 16.0f - 3.5f) * 2.0f);
        fontRenderer.func_78261_a(stackSize, X, Y, 0xFFFFFF);
        GL11.glPopMatrix();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2929);
        if (this.fluid == currentFluid) {
            this.drawHollowRectWithCorners(posX, posY, this.height, this.width, this.color, this.borderThickness);
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public long getAmount() {
        return this.amount;
    }

    @Override
    public void mouseClicked(int posX, int posY, int mouseX, int mouseY) {
        if (this.fluid != null && this.isPointInRegion(posX, posY, this.height, this.width, mouseX, mouseY)) {
            ((IFluidSelectorGui)this.guiFluidTerminal).getContainer().setSelectedFluid(this.fluid);
        }
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }
}

