/*
 * Decompiled with CFR 0.152.
 */
package extracells.item;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.implementations.items.IStorageCell;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.ICellRegistry;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.Platform;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.Extracells;
import extracells.item.ItemECBase;
import extracells.registries.ItemEnum;
import extracells.util.inventory.ECCellInventory;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.Interface(iface="cofh.api.energy.IEnergyContainerItem", modid="CoFHAPI|energy")
public class ItemStoragePhysical
extends ItemECBase
implements IStorageCell,
IAEItemPowerStorage,
IEnergyContainerItem {
    public static final String[] suffixes = new String[]{"256k", "1024k", "4096k", "16384k", "container"};
    public static final int[] bytes_cell = new int[]{262144, 0x100000, 0x400000, 0x1000000, 65536};
    public static final double[] idle_drain_cell = new double[]{2.5, 3.0, 3.5, 4.0, 2.0};
    public static final int[] types_cell = new int[]{63, 63, 63, 63, 1};
    private IIcon[] icons;
    private final int MAX_POWER = 32000;

    public ItemStoragePhysical() {
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(itemStack, player, list, par4);
        list.add(EnumChatFormatting.RED + "Contents will be kept when coverting it in crafting table.");
        list.add(EnumChatFormatting.RED + "You don't need to ME-IO to transfer contents.");
        ICellRegistry cellRegistry = AEApi.instance().registries().cell();
        IMEInventoryHandler invHandler = cellRegistry.getCellInventory(itemStack, null, StorageChannel.ITEMS);
        ICellInventoryHandler inventoryHandler = (ICellInventoryHandler)invHandler;
        ICellInventory cellInv = inventoryHandler.getCellInv();
        long usedBytes = cellInv.getUsedBytes();
        list.add(String.format(StatCollector.func_74838_a((String)"extracells.tooltip.storage.physical.bytes"), usedBytes, cellInv.getTotalBytes()));
        list.add(String.format(StatCollector.func_74838_a((String)"extracells.tooltip.storage.physical.types"), cellInv.getStoredItemTypes(), cellInv.getTotalItemTypes()));
        if (usedBytes > 0L) {
            list.add(String.format(StatCollector.func_74838_a((String)"extracells.tooltip.storage.physical.content"), cellInv.getStoredItemCount()));
        }
    }

    public int getBytesPerType(ItemStack cellItem) {
        return Extracells.dynamicTypes() ? bytes_cell[MathHelper.func_76125_a((int)cellItem.func_77960_j(), (int)0, (int)(suffixes.length - 1))] / 128 : 8;
    }

    @Deprecated
    public int BytePerType(ItemStack cellItem) {
        return this.getBytesPerType(cellItem);
    }

    private NBTTagCompound ensureTagCompound(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    public double extractAEPower(ItemStack itemStack, double amt) {
        if (itemStack == null || itemStack.func_77960_j() != 4) {
            return 0.0;
        }
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        double currentPower = tagCompound.func_74769_h("power");
        double toExtract = Math.min(amt, currentPower);
        tagCompound.func_74780_a("power", currentPower - toExtract);
        return toExtract;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container == null || container.func_77960_j() != 4) {
            return 0;
        }
        if (simulate) {
            return this.getEnergyStored(container) >= maxExtract ? maxExtract : this.getEnergyStored(container);
        }
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.extractAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxExtract)));
    }

    public double getAECurrentPower(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77960_j() != 4) {
            return 0.0;
        }
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        return tagCompound.func_74769_h("power");
    }

    public double getAEMaxPower(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77960_j() != 4) {
            return 0.0;
        }
        return this.MAX_POWER;
    }

    public int getBytes(ItemStack cellItem) {
        return bytes_cell[MathHelper.func_76125_a((int)cellItem.func_77960_j(), (int)0, (int)(suffixes.length - 1))];
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new ECCellInventory(is, "config", 63, 1);
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77960_j() != 4) {
            return super.getDurabilityForDisplay(itemStack);
        }
        return 1.0 - this.getAECurrentPower(itemStack) / (double)this.MAX_POWER;
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ItemStack arg0) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(arg0));
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        return FuzzyMode.values()[is.func_77978_p().func_74762_e("fuzzyMode")];
    }

    public IIcon func_77617_a(int dmg) {
        return this.icons[MathHelper.func_76125_a((int)dmg, (int)0, (int)(suffixes.length - 1))];
    }

    @Deprecated
    public double getIdleDrain() {
        return 2.5;
    }

    public double getIdleDrain(@Nullable ItemStack cellItem) {
        return cellItem != null ? idle_drain_cell[MathHelper.func_76125_a((int)cellItem.func_77960_j(), (int)0, (int)(idle_drain_cell.length - 1))] : 2.5;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        if (stack == null) {
            return super.func_77653_i(stack);
        }
        if (stack.func_77960_j() == 4) {
            try {
                IItemList list = AEApi.instance().registries().cell().getCellInventory(stack, null, StorageChannel.ITEMS).getAvailableItems(AEApi.instance().storage().createItemList());
                if (list.isEmpty()) {
                    return super.func_77653_i(stack) + " - " + StatCollector.func_74838_a((String)"extracells.tooltip.empty1");
                }
                IAEItemStack s = (IAEItemStack)list.getFirstItem();
                return super.func_77653_i(stack) + " - " + s.getItemStack().func_82833_r();
            }
            catch (Throwable throwable) {
                return super.func_77653_i(stack) + " - " + StatCollector.func_74838_a((String)"extracells.tooltip.empty1");
            }
        }
        return super.func_77653_i(stack);
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ItemStack arg0) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(arg0));
    }

    public AccessRestriction getPowerFlow(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return itemStack.func_77960_j() == 4 ? AccessRestriction.READ_WRITE : AccessRestriction.NO_ACCESS;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List itemList) {
        for (int i = 0; i < suffixes.length; ++i) {
            itemList.add(new ItemStack(item, 1, i));
            if (i != 4) continue;
            ItemStack s = new ItemStack(item, 1, i);
            s.func_77982_d(new NBTTagCompound());
            s.func_77978_p().func_74780_a("power", (double)this.MAX_POWER);
            itemList.add(s);
        }
    }

    public int getTotalTypes(ItemStack cellItem) {
        return types_cell[MathHelper.func_76125_a((int)cellItem.func_77960_j(), (int)0, (int)(suffixes.length - 1))];
    }

    public String func_77667_c(ItemStack itemStack) {
        return "extracells.item.storage.physical." + suffixes[itemStack.func_77960_j()];
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new ECCellInventory(is, "upgrades", 2, 1);
    }

    public double injectAEPower(ItemStack itemStack, double amt) {
        if (itemStack == null || itemStack.func_77960_j() != 4) {
            return 0.0;
        }
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        double currentPower = tagCompound.func_74769_h("power");
        double toInject = Math.min(amt, (double)this.MAX_POWER - currentPower);
        tagCompound.func_74780_a("power", currentPower + toInject);
        return toInject;
    }

    public boolean isBlackListed(ItemStack cellItem, IAEItemStack requestedAddition) {
        return false;
    }

    public boolean isEditable(ItemStack is) {
        return true;
    }

    public boolean isStorageCell(ItemStack i) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        if (itemStack == null) {
            return itemStack;
        }
        if (itemStack.func_77960_j() == 4 && entityPlayer.func_70093_af()) {
            if (!world.field_72995_K) {
                switch (itemStack.func_77978_p().func_74762_e("mode")) {
                    case 0: {
                        itemStack.func_77978_p().func_74768_a("mode", 1);
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("extracells.tooltip.storage.container.1", new Object[0]));
                        break;
                    }
                    case 1: {
                        itemStack.func_77978_p().func_74768_a("mode", 2);
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("extracells.tooltip.storage.container.2", new Object[0]));
                        break;
                    }
                    case 2: {
                        itemStack.func_77978_p().func_74768_a("mode", 0);
                        entityPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("extracells.tooltip.storage.container.0", new Object[0]));
                    }
                }
            }
            return itemStack;
        }
        if (!entityPlayer.func_70093_af()) {
            return itemStack;
        }
        IMEInventoryHandler invHandler = AEApi.instance().registries().cell().getCellInventory(itemStack, null, StorageChannel.ITEMS);
        ICellInventoryHandler inventoryHandler = (ICellInventoryHandler)invHandler;
        ICellInventory cellInv = inventoryHandler.getCellInv();
        if (cellInv.getUsedBytes() == 0L && entityPlayer.field_71071_by.func_70441_a(ItemEnum.STORAGECASING.getDamagedStack(0))) {
            return ItemEnum.STORAGECOMPONENT.getDamagedStack(itemStack.func_77960_j());
        }
        return itemStack;
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        if (itemstack == null || player == null) {
            return false;
        }
        if (itemstack.func_77960_j() == 4 && !player.func_70093_af()) {
            double power = this.getAECurrentPower(itemstack);
            ForgeDirection face = ForgeDirection.getOrientation((int)side);
            IItemList list = AEApi.instance().registries().cell().getCellInventory(itemstack, null, StorageChannel.ITEMS).getAvailableItems(AEApi.instance().storage().createItemList());
            if (list.isEmpty()) {
                return false;
            }
            IAEItemStack storageStack = (IAEItemStack)list.getFirstItem();
            if (world.func_147439_a(x + face.offsetX, y + face.offsetY, z + face.offsetZ) == Blocks.field_150350_a && storageStack.getStackSize() != 0L && power >= 20.0) {
                if (!world.field_72995_K) {
                    IAEItemStack request = storageStack.copy();
                    request.setStackSize(1L);
                    ItemStack block = request.getItemStack();
                    if (block.func_77973_b() instanceof ItemBlock) {
                        ItemBlock itemblock = (ItemBlock)request.getItem();
                        if (world.func_147439_a(x, y, z) != Blocks.field_150357_h && world.func_147439_a(x, y, z).func_149712_f(world, x, y, z) >= 0.0f) {
                            block0 : switch (itemstack.func_77978_p().func_74762_e("mode")) {
                                case 0: {
                                    request.setStackSize(1L);
                                    itemblock.onItemUseFirst(request.getItemStack(), player, world, x, y, z, side, xOffset, yOffset, zOffset);
                                    itemblock.func_77648_a(request.getItemStack(), player, world, x, y, z, side, xOffset, yOffset, zOffset);
                                    AEApi.instance().registries().cell().getCellInventory(itemstack, null, StorageChannel.ITEMS).extractItems((IAEStack)request, Actionable.MODULATE, (BaseActionSource)new PlayerSource(player, null));
                                    this.extractAEPower(player.func_71045_bC(), 20.0);
                                    break;
                                }
                                case 1: {
                                    request.setStackSize(1L);
                                    world.func_147480_a(x, y, z, true);
                                    this.placeBlock(request.getItemStack(), world, player, x, y, z, side, xOffset, yOffset, zOffset);
                                    AEApi.instance().registries().cell().getCellInventory(itemstack, null, StorageChannel.ITEMS).extractItems((IAEStack)request, Actionable.MODULATE, (BaseActionSource)new PlayerSource(player, null));
                                    break;
                                }
                                case 2: {
                                    request.setStackSize(9L);
                                    if (storageStack.getStackSize() <= 9L || !(power >= 180.0)) break;
                                    switch (ForgeDirection.getOrientation((int)side)) {
                                        case DOWN: {
                                            for (int posX = x - 1; posX < x + 2; ++posX) {
                                                for (int posZ = z - 1; posZ < z + 2; ++posZ) {
                                                    if (world.func_147439_a(posX, y, posZ) == Blocks.field_150357_h || !(world.func_147439_a(posX, y, posZ).func_149712_f(world, posX, y, posZ) >= 0.0f)) continue;
                                                    world.func_147480_a(posX, y, posZ, true);
                                                    this.placeBlock(request.getItemStack(), world, player, x, y, z, side, xOffset, yOffset, zOffset);
                                                }
                                            }
                                            AEApi.instance().registries().cell().getCellInventory(itemstack, null, StorageChannel.ITEMS).extractItems((IAEStack)request, Actionable.MODULATE, (BaseActionSource)new PlayerSource(player, null));
                                            break block0;
                                        }
                                        case EAST: {
                                            for (int posZ = z - 1; posZ < z + 2; ++posZ) {
                                                for (int posY = y - 1; posY < y + 2; ++posY) {
                                                    if (world.func_147439_a(x, posY, posZ) == Blocks.field_150357_h || !(world.func_147439_a(x, posY, posZ).func_149712_f(world, x, posY, posZ) >= 0.0f)) continue;
                                                    world.func_147480_a(x, posY, posZ, true);
                                                    this.placeBlock(request.getItemStack(), world, player, x, posY, posZ, side, xOffset, yOffset, zOffset);
                                                }
                                            }
                                            AEApi.instance().registries().cell().getCellInventory(itemstack, null, StorageChannel.ITEMS).extractItems((IAEStack)request, Actionable.MODULATE, (BaseActionSource)new PlayerSource(player, null));
                                            break block0;
                                        }
                                        case NORTH: {
                                            for (int posX = x - 1; posX < x + 2; ++posX) {
                                                for (int posY = y - 1; posY < y + 2; ++posY) {
                                                    if (world.func_147439_a(posX, posY, z) == Blocks.field_150357_h || !(world.func_147439_a(posX, posY, z).func_149712_f(world, posX, posY, z) >= 0.0f)) continue;
                                                    world.func_147480_a(posX, posY, z, true);
                                                    this.placeBlock(request.getItemStack(), world, player, posX, posY, z, side, xOffset, yOffset, zOffset);
                                                }
                                            }
                                            AEApi.instance().registries().cell().getCellInventory(itemstack, null, StorageChannel.ITEMS).extractItems((IAEStack)request, Actionable.MODULATE, (BaseActionSource)new PlayerSource(player, null));
                                            break block0;
                                        }
                                        case SOUTH: {
                                            for (int posX = x - 1; posX < x + 2; ++posX) {
                                                for (int posY = y - 1; posY < y + 2; ++posY) {
                                                    if (world.func_147439_a(posX, posY, z) == Blocks.field_150357_h || !(world.func_147439_a(posX, posY, z).func_149712_f(world, posX, posY, z) >= 0.0f)) continue;
                                                    world.func_147480_a(posX, posY, z, true);
                                                    this.placeBlock(request.getItemStack(), world, player, posX, posY, z, side, xOffset, yOffset, zOffset);
                                                }
                                            }
                                            AEApi.instance().registries().cell().getCellInventory(itemstack, null, StorageChannel.ITEMS).extractItems((IAEStack)request, Actionable.MODULATE, (BaseActionSource)new PlayerSource(player, null));
                                            break block0;
                                        }
                                        case UNKNOWN: {
                                            break block0;
                                        }
                                        case UP: {
                                            for (int posX = x - 1; posX < x + 2; ++posX) {
                                                for (int posZ = z - 1; posZ < z + 2; ++posZ) {
                                                    if (world.func_147439_a(posX, y, posZ) == Blocks.field_150357_h || !(world.func_147439_a(posX, y, posZ).func_149712_f(world, posX, y, posZ) >= 0.0f)) continue;
                                                    world.func_147480_a(posX, y, posZ, true);
                                                    this.placeBlock(request.getItemStack(), world, player, posX, y, posZ, side, xOffset, yOffset, zOffset);
                                                }
                                            }
                                            AEApi.instance().registries().cell().getCellInventory(itemstack, null, StorageChannel.ITEMS).extractItems((IAEStack)request, Actionable.MODULATE, (BaseActionSource)new PlayerSource(player, null));
                                            break block0;
                                        }
                                        case WEST: {
                                            for (int posZ = z - 1; posZ < z + 2; ++posZ) {
                                                for (int posY = y - 1; posY < y + 2; ++posY) {
                                                    if (world.func_147439_a(x, posY, posZ) == Blocks.field_150357_h || !(world.func_147439_a(x, posY, posZ).func_149712_f(world, x, posY, posZ) >= 0.0f)) continue;
                                                    world.func_147480_a(x, posY, posZ, true);
                                                    this.placeBlock(request.getItemStack(), world, player, x, posY, posZ, side, xOffset, yOffset, zOffset);
                                                }
                                            }
                                            AEApi.instance().registries().cell().getCellInventory(itemstack, null, StorageChannel.ITEMS).extractItems((IAEStack)request, Actionable.MODULATE, (BaseActionSource)new PlayerSource(player, null));
                                            break block0;
                                        }
                                    }
                                }
                            }
                            return true;
                        }
                        return false;
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("extracells.tooltip.onlyblocks", new Object[0]));
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public void placeBlock(ItemStack itemstack, World world, EntityPlayer player, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        this.extractAEPower(player.func_71045_bC(), 20.0);
        ItemBlock itemblock = (ItemBlock)itemstack.func_77973_b();
        switch (ForgeDirection.getOrientation((int)side)) {
            case DOWN: {
                itemblock.onItemUseFirst(itemstack, player, world, x, y++, z, side, xOffset, yOffset, zOffset);
                itemblock.func_77648_a(itemstack, player, world, x, y++, z, side, xOffset, yOffset, zOffset);
                break;
            }
            case EAST: {
                itemblock.onItemUseFirst(itemstack, player, world, x--, y, z, side, xOffset, yOffset, zOffset);
                itemblock.func_77648_a(itemstack, player, world, x--, y, z, side, xOffset, yOffset, zOffset);
                break;
            }
            case NORTH: {
                itemblock.onItemUseFirst(itemstack, player, world, x, y, z++, side, xOffset, yOffset, zOffset);
                itemblock.func_77648_a(itemstack, player, world, x, y, z++, side, xOffset, yOffset, zOffset);
                break;
            }
            case SOUTH: {
                itemblock.onItemUseFirst(itemstack, player, world, x, y, z--, side, xOffset, yOffset, zOffset);
                itemblock.func_77648_a(itemstack, player, world, x, y, z--, side, xOffset, yOffset, zOffset);
                break;
            }
            case UNKNOWN: {
                break;
            }
            case UP: {
                itemblock.onItemUseFirst(itemstack, player, world, x, y--, z, side, xOffset, yOffset, zOffset);
                itemblock.func_77648_a(itemstack, player, world, x, y--, z, side, xOffset, yOffset, zOffset);
                break;
            }
            case WEST: {
                itemblock.onItemUseFirst(itemstack, player, world, x++, y, z, side, xOffset, yOffset, zOffset);
                itemblock.func_77648_a(itemstack, player, world, x++, y, z, side, xOffset, yOffset, zOffset);
                break;
            }
        }
    }

    @Optional.Method(modid="CoFHAPI|energy")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container == null || container.func_77960_j() != 4) {
            return 0;
        }
        if (simulate) {
            double current = PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(container));
            double max = PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(container));
            if (max - current >= (double)maxReceive) {
                return maxReceive;
            }
            return (int)(max - current);
        }
        int notStored = (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.injectAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxReceive)));
        return maxReceive - notStored;
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[suffixes.length];
        for (int i = 0; i < suffixes.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("extracells:storage.physical." + suffixes[i]);
        }
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        is.func_77978_p().func_74768_a("fuzzyMode", fzMode.ordinal());
    }

    public String getOreFilter(ItemStack itemStack) {
        return Platform.openNbtData((ItemStack)itemStack).func_74779_i("OreFilter");
    }

    public void setOreFilter(ItemStack itemStack, String s) {
        Platform.openNbtData((ItemStack)itemStack).func_74778_a("OreFilter", s);
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77960_j() == 4;
    }

    public boolean storableInStorageCell() {
        return false;
    }
}

