/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.RedstoneMode;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.container.ContainerBusFluidIO;
import extracells.gui.GuiBusFluidIO;
import extracells.item.ItemPartECBase;
import extracells.network.packet.other.IFluidSlotPartOrBlock;
import extracells.network.packet.other.PacketFluidSlot;
import extracells.network.packet.part.PacketBusFluidIO;
import extracells.part.PartECBase;
import extracells.util.inventory.ECPrivateInventory;
import extracells.util.inventory.IInventoryUpdateReceiver;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public abstract class PartFluidIO
extends PartECBase
implements IGridTickable,
IInventoryUpdateReceiver,
IFluidSlotPartOrBlock {
    public Fluid[] filterFluids = new Fluid[9];
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    protected byte filterSize;
    protected byte speedState;
    protected boolean redstoneControlled;
    private boolean lastRedstone;
    private ECPrivateInventory upgradeInventory = new ECPrivateInventory("", 4, 1, this){

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            if (itemStack == null) {
                return false;
            }
            if (AEApi.instance().definitions().materials().cardCapacity().isSameAs(itemStack)) {
                return true;
            }
            if (AEApi.instance().definitions().materials().cardSpeed().isSameAs(itemStack)) {
                return true;
            }
            return AEApi.instance().definitions().materials().cardRedstone().isSameAs(itemStack);
        }
    };

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (ItemStack stack : drops) {
            if (stack.func_77973_b().getClass() != ItemPartECBase.class) continue;
            stack.field_77990_d = null;
        }
        for (ItemStack stack : this.upgradeInventory.slots) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    private boolean canDoWork() {
        boolean redstonePowered = this.isRedstonePowered();
        if (!this.redstoneControlled) {
            return true;
        }
        switch (this.getRedstoneMode()) {
            case IGNORE: {
                return true;
            }
            case LOW_SIGNAL: {
                return !redstonePowered;
            }
            case HIGH_SIGNAL: {
                return redstonePowered;
            }
            case SIGNAL_PULSE: {
                return false;
            }
        }
        return false;
    }

    public byte getSpeedState() {
        return this.speedState;
    }

    public abstract boolean doWork(int var1, int var2);

    @Override
    public abstract void getBoxes(IPartCollisionHelper var1);

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiBusFluidIO(this, player);
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerBusFluidIO(this, player);
    }

    public final TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 20, false, false);
    }

    public ECPrivateInventory getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public List<String> getWailaBodey(NBTTagCompound tag, List<String> oldList) {
        if (tag.func_74764_b("speed")) {
            oldList.add(tag.func_74762_e("speed") + "mB/t");
        } else {
            oldList.add("125mB/t");
        }
        return oldList;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        tag.func_74768_a("speed", 125 + this.speedState * 125);
        return tag;
    }

    public void loopRedstoneMode(EntityPlayer player) {
        this.redstoneMode = this.redstoneMode.ordinal() + 1 < RedstoneMode.values().length ? RedstoneMode.values()[this.redstoneMode.ordinal() + 1] : RedstoneMode.values()[0];
        new PacketBusFluidIO(this.redstoneMode).sendPacketToPlayer(player);
        this.saveData();
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        boolean activate = super.onActivate(player, pos);
        this.onInventoryChanged();
        return activate;
    }

    @Override
    public void onInventoryChanged() {
        this.filterSize = 0;
        this.redstoneControlled = false;
        this.speedState = 0;
        for (int i = 0; i < this.upgradeInventory.func_70302_i_(); ++i) {
            ItemStack currentStack = this.upgradeInventory.func_70301_a(i);
            if (currentStack == null) continue;
            if (AEApi.instance().definitions().materials().cardCapacity().isSameAs(currentStack)) {
                this.filterSize = (byte)(this.filterSize + 1);
            }
            if (AEApi.instance().definitions().materials().cardRedstone().isSameAs(currentStack)) {
                this.redstoneControlled = true;
            }
            if (!AEApi.instance().definitions().materials().cardSpeed().isSameAs(currentStack)) continue;
            this.speedState = (byte)(this.speedState + 1);
        }
        try {
            if (this.getHost().getLocation().getWorld().field_72995_K) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        new PacketBusFluidIO(this.filterSize).sendPacketToAllPlayers();
        new PacketBusFluidIO(this.redstoneControlled).sendPacketToAllPlayers();
        this.saveData();
    }

    @Override
    public void onNeighborChanged() {
        boolean redstonePowered;
        super.onNeighborChanged();
        this.lastRedstone = redstonePowered = this.isRedstonePowered();
    }

    @Override
    public final void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.redstoneMode = RedstoneMode.values()[data.func_74762_e("redstoneMode")];
        for (int i = 0; i < 9; ++i) {
            this.filterFluids[i] = FluidRegistry.getFluid((String)data.func_74779_i("FilterFluid#" + i));
        }
        this.upgradeInventory.readFromNBT(data.func_150295_c("upgradeInventory", 10));
        this.onInventoryChanged();
    }

    @Override
    public final boolean readFromStream(ByteBuf data) throws IOException {
        return super.readFromStream(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public final void renderDynamic(double x, double y, double z, IPartRenderHelper rh, RenderBlocks renderer) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract void renderInventory(IPartRenderHelper var1, RenderBlocks var2);

    @Override
    @SideOnly(value=Side.CLIENT)
    public abstract void renderStatic(int var1, int var2, int var3, IPartRenderHelper var4, RenderBlocks var5);

    public void sendInformation(EntityPlayer player) {
        new PacketFluidSlot(Arrays.asList(this.filterFluids)).sendPacketToPlayer(player);
        new PacketBusFluidIO(this.redstoneMode).sendPacketToPlayer(player);
        new PacketBusFluidIO(this.filterSize).sendPacketToPlayer(player);
    }

    @Override
    public final void setFluid(int index, Fluid fluid, EntityPlayer player) {
        this.filterFluids[index] = fluid;
        new PacketFluidSlot(Arrays.asList(this.filterFluids)).sendPacketToPlayer(player);
        this.saveData();
    }

    @Override
    public void setPartHostInfo(ForgeDirection _side, IPartHost _host, TileEntity _tile) {
        super.setPartHostInfo(_side, _host, _tile);
        this.onInventoryChanged();
    }

    public final TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.canDoWork()) {
            return this.doWork(125 + this.speedState * 125, TicksSinceLastCall) ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
        }
        return TickRateModulation.SLOWER;
    }

    @Override
    public final void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("redstoneMode", this.redstoneMode.ordinal());
        for (int i = 0; i < this.filterFluids.length; ++i) {
            Fluid fluid = this.filterFluids[i];
            if (fluid != null) {
                data.func_74778_a("FilterFluid#" + i, fluid.getName());
                continue;
            }
            data.func_74778_a("FilterFluid#" + i, "");
        }
        data.func_74782_a("upgradeInventory", (NBTBase)this.upgradeInventory.writeToNBT());
    }

    @Override
    public final void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
    }
}

