/*
 * Decompiled with CFR 0.152.
 */
package extracells.gui;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import extracells.container.ContainerBusFluidStorage;
import extracells.gui.ECGuiContainer;
import extracells.gui.widget.WidgetStorageDirection;
import extracells.gui.widget.fluid.WidgetFluidSlot;
import extracells.integration.Integration;
import extracells.network.packet.other.IFluidSlotGui;
import extracells.network.packet.part.PacketBusFluidStorage;
import extracells.part.PartFluidStorage;
import extracells.part.PartGasStorage;
import extracells.util.FluidUtil;
import extracells.util.GuiUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GuiBusFluidStorage
extends ECGuiContainer
implements WidgetFluidSlot.IConfigurable,
IFluidSlotGui {
    private static final ResourceLocation guiTexture = new ResourceLocation("extracells", "textures/gui/storagebusfluid.png");
    private EntityPlayer player;
    private byte filterSize;
    private boolean hasNetworkTool;
    private final PartFluidStorage part;

    public GuiBusFluidStorage(PartFluidStorage _part, EntityPlayer _player) {
        super(new ContainerBusFluidStorage(_part, _player));
        this.part = _part;
        ((ContainerBusFluidStorage)this.field_147002_h).setGui(this);
        this.player = _player;
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.fluidSlotList.add(new WidgetFluidSlot(this.player, this.part, i * 6 + j, 18 * i + 7, 18 * j + 17));
            }
        }
        new PacketBusFluidStorage(this.player, this.part).sendPacketToServer();
        this.hasNetworkTool = this.field_147002_h.func_75138_a().size() > 40;
        this.field_146999_f = this.hasNetworkTool ? 246 : 211;
        this.field_147000_g = 222;
    }

    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        if (button instanceof WidgetStorageDirection) {
            switch (((WidgetStorageDirection)button).getAccessRestriction()) {
                case NO_ACCESS: {
                    new PacketBusFluidStorage(this.player, AccessRestriction.READ, false).sendPacketToServer();
                    break;
                }
                case READ: {
                    new PacketBusFluidStorage(this.player, AccessRestriction.READ_WRITE, false).sendPacketToServer();
                    break;
                }
                case READ_WRITE: {
                    new PacketBusFluidStorage(this.player, AccessRestriction.WRITE, false).sendPacketToServer();
                    break;
                }
                case WRITE: {
                    new PacketBusFluidStorage(this.player, AccessRestriction.NO_ACCESS, false).sendPacketToServer();
                    break;
                }
            }
        }
    }

    public void changeConfig(byte _filterSize) {
        this.filterSize = _filterSize;
    }

    protected void func_146976_a(float alpha, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(guiTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, 176, 222);
        this.func_73729_b(this.field_147003_i + 179, this.field_147009_r, 179, 0, 32, 86);
        if (this.hasNetworkTool) {
            this.func_73729_b(this.field_147003_i + 179, this.field_147009_r + 93, 178, 93, 68, 68);
        }
        for (Object s : this.field_147002_h.field_75151_b) {
            this.renderBackground((Slot)s);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        boolean overlayRendered = false;
        for (int i = 0; i < 54; i = (int)((byte)(i + 1))) {
            ((WidgetFluidSlot)((Object)this.fluidSlotList.get(i))).drawWidget();
            if (overlayRendered || !((WidgetFluidSlot)((Object)this.fluidSlotList.get(i))).canRender()) continue;
            overlayRendered = GuiUtil.renderOverlay(this.field_73735_i, this.field_147003_i, this.field_147009_r, (WidgetFluidSlot)((Object)this.fluidSlotList.get(i)), mouseX, mouseY);
        }
        for (Object button : this.field_146292_n) {
            if (!(button instanceof WidgetStorageDirection)) continue;
            ((WidgetStorageDirection)((Object)button)).drawTooltip(mouseX, mouseY, (this.field_146294_l - this.field_146999_f) / 2, (this.field_146295_m - this.field_147000_g) / 2);
        }
        this.showTooltipList(mouseX, mouseY);
    }

    @Override
    public byte getConfigState() {
        return this.filterSize;
    }

    protected Slot func_146975_c(int p_146975_1_, int p_146975_2_) {
        for (int k = 0; k < this.field_147002_h.field_75151_b.size(); ++k) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(k);
            if (!this.isMouseOverSlot(slot, p_146975_1_, p_146975_2_)) continue;
            return slot;
        }
        return null;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new WidgetStorageDirection(0, this.field_147003_i - 18, this.field_147009_r, 16, 16, AccessRestriction.READ_WRITE));
    }

    private boolean isMouseOverSlot(Slot p_146981_1_, int p_146981_2_, int p_146981_3_) {
        return this.func_146978_c(p_146981_1_.field_75223_e, p_146981_1_.field_75221_f, 16, 16, p_146981_2_, p_146981_3_);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseBtn) {
        Slot slot = this.func_146975_c(mouseX, mouseY);
        if (slot != null && slot.func_75211_c() != null && AEApi.instance().definitions().items().networkTool().isSameAs(slot.func_75211_c())) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseBtn);
        for (WidgetFluidSlot fluidSlot : this.fluidSlotList) {
            if (!GuiUtil.isPointInRegion(this.field_147003_i, this.field_147009_r, fluidSlot.getPosX(), fluidSlot.getPosY(), 18, 18, mouseX, mouseY)) continue;
            if (this.part instanceof PartGasStorage && Integration.Mods.MEKANISMGAS.isEnabled()) {
                fluidSlot.mouseClickedGas(this.player.field_71071_by.func_70445_o());
                break;
            }
            fluidSlot.mouseClicked(this.player.field_71071_by.func_70445_o());
            break;
        }
    }

    private void renderBackground(Slot slot) {
        if (slot.func_75211_c() == null && (slot.field_75222_d == 0 || slot.field_75222_d > 36)) {
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("appliedenergistics2", "textures/guis/states.png"));
            this.func_73729_b(this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f, 240, 208, 16, 16);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
        }
    }

    public void shiftClick(ItemStack itemStack) {
        FluidStack containerFluid = FluidUtil.getFluidFromContainer(itemStack);
        Fluid fluid = containerFluid == null ? null : containerFluid.getFluid();
        for (WidgetFluidSlot fluidSlot : this.fluidSlotList) {
            if (fluidSlot.getFluid() != null && (fluid == null || fluidSlot.getFluid() != fluid)) continue;
            if (this.part instanceof PartGasStorage && Integration.Mods.MEKANISMGAS.isEnabled()) {
                fluidSlot.mouseClickedGas(itemStack);
            } else {
                fluidSlot.mouseClicked(itemStack);
            }
            return;
        }
    }

    public void updateAccessRestriction(AccessRestriction mode) {
        if (this.field_146292_n.size() > 0) {
            ((WidgetStorageDirection)((Object)this.field_146292_n.get(0))).setAccessRestriction(mode);
        }
    }

    @Override
    public void updateFluids(List<Fluid> fluidList) {
        for (int i = 0; i < this.fluidSlotList.size() && i < fluidList.size(); ++i) {
            ((WidgetFluidSlot)((Object)this.fluidSlotList.get(i))).setFluid(fluidList.get(i));
        }
    }
}

