/*
 * Decompiled with CFR 0.152.
 */
package extracells.item;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.FuzzyMode;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.api.ECApi;
import extracells.api.IHandlerFluidStorage;
import extracells.api.IPortableGasStorageCell;
import extracells.item.ItemECBase;
import extracells.item.ItemStoragePortableFluidCell$;
import extracells.item.PowerItem;
import extracells.item.PowerItem$class;
import extracells.util.inventory.ECFluidFilterInventory;
import extracells.util.inventory.ECPrivateInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ItemStoragePortableGasCell$
extends ItemECBase
implements IPortableGasStorageCell,
PowerItem {
    public static final ItemStoragePortableGasCell$ MODULE$;
    private final double MAX_POWER;
    private IIcon icon;

    static {
        new ItemStoragePortableGasCell$();
    }

    @Override
    @Optional.Method(modid="CoFHAPI|energy")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return PowerItem$class.extractEnergy(this, container, maxExtract, simulate);
    }

    @Override
    @Optional.Method(modid="CoFHAPI|energy")
    public int getEnergyStored(ItemStack arg0) {
        return PowerItem$class.getEnergyStored(this, arg0);
    }

    @Override
    @Optional.Method(modid="CoFHAPI|energy")
    public int getMaxEnergyStored(ItemStack arg0) {
        return PowerItem$class.getMaxEnergyStored(this, arg0);
    }

    @Override
    @Optional.Method(modid="CoFHAPI|energy")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return PowerItem$class.receiveEnergy(this, container, maxReceive, simulate);
    }

    @Override
    public double injectAEPower(ItemStack itemStack, double amt) {
        return PowerItem$class.injectAEPower(this, itemStack, amt);
    }

    @Override
    public double extractAEPower(ItemStack itemStack, double amt) {
        return PowerItem$class.extractAEPower(this, itemStack, amt);
    }

    @Override
    public double getAECurrentPower(ItemStack itemStack) {
        return PowerItem$class.getAECurrentPower(this, itemStack);
    }

    @Override
    public double getAEMaxPower(ItemStack itemStack) {
        return PowerItem$class.getAEMaxPower(this, itemStack);
    }

    @Override
    public double MAX_POWER() {
        return this.MAX_POWER;
    }

    public IIcon icon() {
        return this.icon;
    }

    public void icon_$eq(IIcon x$1) {
        this.icon = x$1;
    }

    public ItemStoragePortableGasCell$ THIS() {
        return this;
    }

    @SuppressWarnings(value={"rawtypes", "unchecked"})
    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List<?> list, boolean par4) {
        List<?> list2 = list;
        IMEInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(itemStack, null, StorageChannel.FLUIDS);
        if (handler instanceof IHandlerFluidStorage) {
            IHandlerFluidStorage cellHandler = (IHandlerFluidStorage)handler;
            boolean partitioned = cellHandler.isFormatted();
            long usedBytes = cellHandler.usedBytes();
            double aeCurrentPower = this.getAECurrentPower(itemStack);
            list2.add(String.format(StatCollector.func_74838_a((String)"extracells.tooltip.storage.gas.bytes"), BoxesRunTime.boxToLong((long)(usedBytes / 250L)), BoxesRunTime.boxToInteger((int)(cellHandler.totalBytes() / 250))));
            list2.add(String.format(StatCollector.func_74838_a((String)"extracells.tooltip.storage.gas.types"), BoxesRunTime.boxToInteger((int)cellHandler.usedTypes()), BoxesRunTime.boxToInteger((int)cellHandler.totalTypes())));
            Object object = usedBytes != 0L ? BoxesRunTime.boxToBoolean((boolean)list2.add(String.format(StatCollector.func_74838_a((String)"extracells.tooltip.storage.gas.content"), BoxesRunTime.boxToLong((long)usedBytes)))) : BoxedUnit.UNIT;
            Object object2 = partitioned ? BoxesRunTime.boxToBoolean((boolean)list2.add(new StringBuilder().append((Object)StatCollector.func_74838_a((String)"gui.appliedenergistics2.Partitioned")).append((Object)" - ").append((Object)StatCollector.func_74838_a((String)"gui.appliedenergistics2.Precise")).toString())) : BoxedUnit.UNIT;
            list2.add(new StringBuilder().append((Object)StatCollector.func_74838_a((String)"gui.appliedenergistics2.StoredEnergy")).append((Object)": ").append((Object)BoxesRunTime.boxToDouble((double)aeCurrentPower)).append((Object)" AE - ").append((Object)BoxesRunTime.boxToDouble((double)(Math.floor(aeCurrentPower / ItemStoragePortableFluidCell$.MODULE$.MAX_POWER() * 10000.0) / 100.0))).append((Object)"%").toString());
            return;
        }
    }

    public IInventory getConfigInventory(ItemStack is) {
        return new ECFluidFilterInventory("configFluidCell", 63, is);
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        return 1.0 - this.getAECurrentPower(itemStack) / ItemStoragePortableFluidCell$.MODULE$.MAX_POWER();
    }

    @Override
    public ArrayList<Fluid> getFilter(ItemStack stack) {
        ECFluidFilterInventory inventory = new ECFluidFilterInventory("", 63, stack);
        ItemStack[] stacks = inventory.slots;
        ArrayList<Fluid> filter = new ArrayList<Fluid>();
        if (stacks.length == 0) {
            return null;
        }
        Predef$.MODULE$.refArrayOps((Object[])stacks).foreach((Function1)new Serializable(filter){
            private final ArrayList filter$1;

            public final Object apply(ItemStack s) {
                Fluid f;
                return s == null ? BoxedUnit.UNIT : ((f = FluidRegistry.getFluid((int)s.func_77960_j())) == null ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)this.filter$1.add(f)));
            }
            {
                this.filter$1 = filter$1;
            }
        });
        return filter;
    }

    public FuzzyMode getFuzzyMode(ItemStack is) {
        if (is == null) {
            return null;
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        if (is.func_77978_p().func_74764_b("fuzzyMode")) {
            return FuzzyMode.valueOf((String)is.func_77978_p().func_74779_i("fuzzyMode"));
        }
        is.func_77978_p().func_74778_a("fuzzyMode", FuzzyMode.IGNORE_ALL.name());
        return FuzzyMode.IGNORE_ALL;
    }

    public IIcon func_77617_a(int dmg) {
        return this.icon();
    }

    @Override
    public int getMaxBytes(ItemStack is) {
        return 512;
    }

    @Override
    public int getMaxTypes(ItemStack unused) {
        return 3;
    }

    public AccessRestriction getPowerFlow(ItemStack itemStack) {
        return AccessRestriction.READ_WRITE;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List<?> itemList) {
        List<?> itemList2 = itemList;
        itemList2.add(new ItemStack(item));
        ItemStack itemStack = new ItemStack(item);
        this.injectAEPower(itemStack, ItemStoragePortableFluidCell$.MODULE$.MAX_POWER());
        itemList2.add(itemStack);
    }

    public String func_77667_c(ItemStack itemStack) {
        return "extracells.item.storage.gas.portable";
    }

    public IInventory getUpgradesInventory(ItemStack is) {
        return new ECPrivateInventory("configInventory", 0, 64);
    }

    @Override
    public boolean hasPower(EntityPlayer player, double amount, ItemStack is) {
        return this.getAECurrentPower(is) >= amount;
    }

    public boolean isEditable(ItemStack is) {
        if (is == null) {
            return false;
        }
        Item item = is.func_77973_b();
        ItemStoragePortableGasCell$ itemStoragePortableGasCell$ = this;
        return !(item != null ? !item.equals(itemStoragePortableGasCell$) : itemStoragePortableGasCell$ != null);
    }

    @SuppressWarnings(value={"rawtypes", "unchecked"})
    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        return ECApi.instance().openPortableGasCellGui(player, itemStack, world);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.icon_$eq(iconRegister.func_94245_a("extracells:storage.gas.portable"));
    }

    public void setFuzzyMode(ItemStack is, FuzzyMode fzMode) {
        if (is == null) {
            return;
        }
        if (!is.func_77942_o()) {
            is.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = is.func_77978_p();
        tag.func_74778_a("fuzzyMode", fzMode.name());
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        this.extractAEPower(is, amount);
        return true;
    }

    private ItemStoragePortableGasCell$() {
        MODULE$ = this;
        PowerItem$class.$init$(this);
        this.MAX_POWER = 20000.0;
        this.icon = null;
        this.func_77625_d(1);
        this.func_77656_e(0);
    }
}

