/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.enhancedlootbags.core.serializer;

import eu.usrv.enhancedlootbags.core.LootGroupsHandler;
import eu.usrv.enhancedlootbags.core.serializer.LootGroups;
import net.minecraft.item.EnumRarity;

public class LootGroupsFactory {
    public LootGroups.LootGroup createLootGroup(int pGroupID, String pGroupName, EnumRarity pRarity, int pMinItems, int pMaxItems, boolean pTrashCombine) {
        LootGroups.LootGroup lgrp = new LootGroups.LootGroup();
        lgrp.mGroupID = pGroupID;
        lgrp.mRarity = pRarity.ordinal();
        lgrp.mGroupName = pGroupName;
        lgrp.mMinItems = pMinItems;
        lgrp.mMaxItems = pMaxItems;
        lgrp.mCombineWithTrash = pTrashCombine;
        return lgrp;
    }

    public LootGroups copy(LootGroups pSource, boolean pIncludeDrops) {
        try {
            LootGroups tRet = new LootGroups();
            for (LootGroups.LootGroup lg : pSource.getLootTable()) {
                tRet.getLootTable().add(this.copyLootGroup(lg, pIncludeDrops));
            }
            return tRet;
        }
        catch (Exception e) {
            return null;
        }
    }

    public LootGroups.LootGroup copyLootGroup(LootGroups.LootGroup pSourceGroup) {
        return this.copyLootGroup(pSourceGroup, true);
    }

    public LootGroups.LootGroup copyLootGroup(LootGroups.LootGroup pSourceGroup, boolean pIncludeDrops) {
        LootGroups.LootGroup lgrp = new LootGroups.LootGroup();
        lgrp.mGroupID = pSourceGroup.mGroupID;
        lgrp.mRarity = pSourceGroup.mRarity;
        lgrp.mGroupName = pSourceGroup.mGroupName;
        lgrp.mMinItems = pSourceGroup.mMinItems;
        lgrp.mMaxItems = pSourceGroup.mMaxItems;
        lgrp.mCombineWithTrash = pSourceGroup.mCombineWithTrash;
        if (pIncludeDrops) {
            for (LootGroups.LootGroup.Drop dr : pSourceGroup.getDrops()) {
                lgrp.getDrops().add(this.copyDrop(dr));
            }
        }
        return lgrp;
    }

    public LootGroups.LootGroup.Drop copyDrop(LootGroups.LootGroup.Drop pSourceDrop) {
        return this.copyDrop(pSourceDrop, 0);
    }

    public LootGroups.LootGroup.Drop copyDrop(LootGroups.LootGroup.Drop pSourceDrop, int pFortuneLevel) {
        LootGroups.LootGroup.Drop tdr = new LootGroups.LootGroup.Drop();
        tdr.mAmount = pSourceDrop.mAmount;
        tdr.mChance = LootGroupsHandler.recalcWeightByFortune(pSourceDrop.mChance, pFortuneLevel);
        tdr.mDropID = pSourceDrop.mDropID;
        tdr.mIsRandomAmount = pSourceDrop.mIsRandomAmount;
        tdr.mItemName = pSourceDrop.mItemName;
        tdr.mLimitedDropCount = pSourceDrop.mLimitedDropCount;
        tdr.mTag = pSourceDrop.mTag;
        tdr.mItemGroup = pSourceDrop.mItemGroup;
        return tdr;
    }

    public LootGroups.LootGroup.Drop createDrop(String pItemName, String pIdentifier, int pAmount, boolean pDropRnd, int pChance, int pLimitedDropCount) {
        return this.createDrop(pItemName, pIdentifier, "", pAmount, pDropRnd, pChance, pLimitedDropCount, "");
    }

    public LootGroups.LootGroup.Drop createDrop(String pItemName, String pIdentifier, String pNBTTag, int pAmount, boolean pDropRnd, int pChance, int pLimitedDropCount, String pItemGroupName) {
        LootGroups.LootGroup.Drop drop = new LootGroups.LootGroup.Drop();
        drop.mAmount = pAmount;
        drop.mChance = pChance;
        drop.mDropID = pIdentifier;
        drop.mIsRandomAmount = pDropRnd;
        drop.mItemName = pItemName;
        drop.mLimitedDropCount = pLimitedDropCount;
        drop.mTag = pNBTTag;
        drop.mItemGroup = pItemGroupName;
        return drop;
    }
}

