/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.item.darksteel.DarkSteelController;
import crazypants.enderio.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;

public class PacketUpgradeState
implements IMessage,
IMessageHandler<PacketUpgradeState, IMessage> {
    private boolean isActive;
    private Type type;
    private int entityID;

    public PacketUpgradeState() {
    }

    public PacketUpgradeState(Type type, boolean isActive) {
        this(type, isActive, 0);
    }

    public PacketUpgradeState(Type type, boolean isActive, int entityID) {
        this.type = type;
        this.isActive = isActive;
        this.entityID = entityID;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.type.ordinal());
        buf.writeBoolean(this.isActive);
        buf.writeInt(this.entityID);
    }

    public void fromBytes(ByteBuf buf) {
        this.type = Type.values()[buf.readShort()];
        this.isActive = buf.readBoolean();
        this.entityID = buf.readInt();
    }

    public IMessage onMessage(PacketUpgradeState message, MessageContext ctx) {
        EntityPlayer player = (EntityPlayer)(ctx.side.isClient() ? EnderIO.proxy.getClientWorld().func_73045_a(message.entityID) : ctx.getServerHandler().field_147369_b);
        if (player != null) {
            DarkSteelController.instance.setActive(player, message.type, message.isActive);
            if (ctx.side.isServer()) {
                message.entityID = player.func_145782_y();
                PacketHandler.INSTANCE.sendToDimension((IMessage)message, player.field_70170_p.field_73011_w.field_76574_g);
            }
        }
        return null;
    }

    public static enum Type {
        GLIDE,
        SPEED,
        STEP_ASSIST,
        JUMP;

    }
}

