/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.redstone;

import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.DyeColor;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.conduit.redstone.RedstoneConduitNetwork;
import crazypants.enderio.conduit.redstone.Signal;
import crazypants.enderio.conduit.render.ConduitRenderer;
import crazypants.enderio.conduit.render.DefaultConduitRenderer;
import dan200.computercraft.api.ComputerCraftAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetOutputNode;

public class RedstoneConduit
extends AbstractConduit
implements IRedstoneConduit {
    static final Map<String, IIcon> ICONS = new HashMap<String, IIcon>();
    protected RedstoneConduitNetwork network;
    protected final List<Set<Signal>> externalSignals = new ArrayList<Set<Signal>>();
    protected boolean neighbourDirty = true;

    @Override
    public ConduitRenderer getRenderer() {
        return DefaultConduitRenderer.instance.get();
    }

    @SideOnly(value=Side.CLIENT)
    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(IIconRegister register) {
                ICONS.put("enderio:redstoneConduitCoreOff", register.func_94245_a("enderio:redstoneConduitCoreOff"));
                ICONS.put("enderio:redstoneConduitCoreOn", register.func_94245_a("enderio:redstoneConduitCoreOn"));
                ICONS.put("enderio:redstoneConduit", register.func_94245_a("enderio:redstoneConduit"));
                ICONS.put("enderio:redstoneConduitTransmission", register.func_94245_a("enderio:redstoneConduitTransmission"));
            }

            public int getTextureType() {
                return 0;
            }
        });
    }

    public RedstoneConduit() {
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            this.externalSignals.add(new HashSet());
        }
    }

    @Override
    public ItemStack createItem() {
        return new ItemStack((Item)EnderIO.itemRedstoneConduit, 1, 0);
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IRedstoneConduit.class;
    }

    public AbstractConduitNetwork<IRedstoneConduit, IRedstoneConduit> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        this.network = (RedstoneConduitNetwork)network;
        return true;
    }

    @Override
    public boolean canConnectToExternal(ForgeDirection direction, boolean ignoreDisabled) {
        return false;
    }

    @Override
    public void updateNetwork() {
        World world = this.getBundle().getEntity().func_145831_w();
        if (world != null) {
            this.updateNetwork(world);
        }
    }

    @Override
    public void onChunkUnload(World worldObj) {
        RedstoneConduitNetwork network = (RedstoneConduitNetwork)this.getNetwork();
        if (network != null) {
            HashSet oldSignals = Sets.newHashSet(network.getSignals());
            ArrayList conduits = Lists.newArrayList(network.getConduits());
            super.onChunkUnload(worldObj);
            network.afterChunkUnload(conduits, oldSignals);
        }
    }

    protected boolean acceptSignalsForDir(ForgeDirection dir) {
        BlockCoord loc = this.getLocation().getLocation(dir);
        return ConduitUtil.getConduit(this.getBundle().getEntity().func_145831_w(), loc.x, loc.y, loc.z, IRedstoneConduit.class) == null;
    }

    @Override
    public Set<Signal> getNetworkInputs() {
        return this.getNetworkInputs(null);
    }

    @Override
    public Set<Signal> getNetworkInputs(ForgeDirection side) {
        if (this.network != null) {
            this.network.setNetworkEnabled(false);
        }
        HashSet<Signal> res = new HashSet<Signal>();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            Signal signal;
            int color;
            BlockCoord loc;
            if (side != null && dir != side || !this.acceptSignalsForDir(dir)) continue;
            int input = this.getExternalPowerLevel(dir);
            if (input > 1) {
                loc = this.getLocation().getLocation(dir);
                Signal signal2 = new Signal(loc.x, loc.y, loc.z, dir, input - 1, this.getSignalColor(dir));
                res.add(signal2);
            }
            if (Loader.isModLoaded((String)"MineFactoryReloaded")) {
                res.addAll((Collection<Signal>)this.externalSignals.get(dir.ordinal()));
                int[] bundledInput = this.getExternalBundledPowerLevel(dir);
                if (bundledInput != null) {
                    BlockCoord loc2 = this.getLocation().getLocation(dir);
                    for (int subnet = 0; subnet < bundledInput.length; ++subnet) {
                        if (bundledInput[subnet] <= 1) continue;
                        color = RedstoneConduit.convertColorForRedNet(subnet);
                        signal = new Signal(loc2.x, loc2.y, loc2.z, dir, bundledInput[subnet] - 1, DyeColor.fromIndex((int)color));
                        res.add(signal);
                    }
                }
            }
            if (!Loader.isModLoaded((String)"ComputerCraft") || !this.canConnectToExternal(dir, false)) continue;
            loc = this.getLocation().getLocation(dir);
            int bundledInput = this.getComputerCraftBundledPowerLevel(dir);
            if (bundledInput < 0) continue;
            for (int i = 0; i < 16; ++i) {
                color = bundledInput >>> i & 1;
                signal = new Signal(loc.x, loc.y, loc.z, dir, color == 1 ? 16 : 0, DyeColor.fromIndex((int)Math.max(0, 15 - i)));
                res.add(signal);
            }
        }
        if (this.network != null) {
            this.network.setNetworkEnabled(true);
        }
        return res;
    }

    @Override
    public DyeColor getSignalColor(ForgeDirection dir) {
        return DyeColor.RED;
    }

    @Override
    public Set<Signal> getNetworkOutputs(ForgeDirection side) {
        if (this.network == null) {
            return Collections.emptySet();
        }
        return this.network.getSignals();
    }

    @Override
    public boolean onNeighborBlockChange(Block blockId) {
        World world = this.getBundle().getEntity().func_145831_w();
        if (world.field_72995_K) {
            return false;
        }
        boolean res = super.onNeighborBlockChange(blockId);
        if (this.network == null || this.network.updatingNetwork) {
            return false;
        }
        this.neighbourDirty |= blockId != EnderIO.blockConduitBundle;
        return res;
    }

    @Override
    public void updateEntity(World world) {
        super.updateEntity(world);
        if (!world.field_72995_K && this.neighbourDirty) {
            this.network.destroyNetwork();
            this.updateNetwork(world);
            this.neighbourDirty = false;
        }
    }

    protected int getExternalPowerLevel(ForgeDirection dir) {
        World world = this.getBundle().getEntity().func_145831_w();
        BlockCoord loc = this.getLocation();
        loc = loc.getLocation(dir);
        int strong = world.func_72879_k(loc.x, loc.y, loc.z, dir.ordinal());
        if (strong > 0) {
            return 16;
        }
        int res = world.func_72878_l(loc.x, loc.y, loc.z, dir.ordinal());
        if (res < 15 && world.func_147439_a(loc.x, loc.y, loc.z) == Blocks.field_150488_af) {
            int wireIn = world.func_72805_g(loc.x, loc.y, loc.z);
            res = Math.max(res, wireIn);
        }
        return res;
    }

    protected int[] getExternalBundledPowerLevel(ForgeDirection dir) {
        World world = this.getBundle().getEntity().func_145831_w();
        BlockCoord loc = this.getLocation();
        loc = loc.getLocation(dir);
        Block block = world.func_147439_a(loc.x, loc.y, loc.z);
        if (block instanceof IRedNetOutputNode) {
            return ((IRedNetOutputNode)block).getOutputValues(world, loc.x, loc.y, loc.z, dir.getOpposite());
        }
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    protected int getComputerCraftBundledPowerLevel(ForgeDirection dir) {
        BlockCoord loc = this.getLocation().getLocation(dir);
        return ComputerCraftAPI.getBundledRedstoneOutput((World)this.getBundle().getWorld(), (int)loc.x, (int)loc.y, (int)loc.z, (int)dir.getOpposite().ordinal());
    }

    @Override
    public int isProvidingStrongPower(ForgeDirection toDirection) {
        return 0;
    }

    @Override
    public int isProvidingWeakPower(ForgeDirection toDirection) {
        if (this.network == null || !this.network.isNetworkEnabled()) {
            return 0;
        }
        int result = 0;
        for (Signal signal : this.getNetworkOutputs(toDirection.getOpposite())) {
            result = Math.max(result, signal.strength);
        }
        return result;
    }

    @Override
    public IIcon getTextureForState(CollidableComponent component) {
        if (component.dir == ForgeDirection.UNKNOWN) {
            return this.isActive() ? ICONS.get("enderio:redstoneConduitCoreOn") : ICONS.get("enderio:redstoneConduitCoreOff");
        }
        return this.isActive() ? ICONS.get("enderio:redstoneConduitTransmission") : ICONS.get("enderio:redstoneConduit");
    }

    @Override
    public IIcon getTransmitionTextureForState(CollidableComponent component) {
        return null;
    }

    public String toString() {
        return "RedstoneConduit [network=" + this.network + " connections=" + this.conduitConnections + " active=" + this.active + "]";
    }

    @Override
    public int[] getOutputValues(World world, int x, int y, int z, ForgeDirection side) {
        Set<Signal> outs;
        int[] result = new int[16];
        Set<Signal> set = outs = this.network != null ? this.network.getSignals() : null;
        if (outs != null) {
            BlockCoord loc = this.getLocation().getLocation(side);
            for (Signal s : outs) {
                if (s.dir == side && s.x == loc.x && s.y == loc.y && s.z == loc.z) continue;
                int subnet = RedstoneConduit.convertColorForRedNet(s.color.ordinal());
                result[subnet] = s.strength;
            }
        }
        return result;
    }

    @Override
    public int getOutputValue(World world, int x, int y, int z, ForgeDirection side, int subnet) {
        Set<Signal> outs;
        Set<Signal> set = outs = this.network != null ? this.network.getSignals() : null;
        if (outs != null) {
            BlockCoord loc = this.getLocation().getLocation(side);
            int color = RedstoneConduit.convertColorForRedNet(subnet);
            for (Signal s : outs) {
                if (s.dir == side && s.x == loc.x && s.y == loc.y && s.z == loc.z || s.color.ordinal() != color) continue;
                return s.strength;
            }
        }
        return 0;
    }

    @Override
    public void onInputsChanged(World world, int x, int y, int z, ForgeDirection side, int[] inputValues) {
        Set<Signal> inputs = this.getNetworkInputs(side);
        this.externalSignals.get(side.ordinal()).clear();
        BlockCoord loc = this.getLocation().getLocation(side);
        for (int subnet = 0; subnet < inputValues.length; ++subnet) {
            int color = RedstoneConduit.convertColorForRedNet(subnet);
            int newInput = inputValues[subnet];
            int oldInput = 0;
            for (Signal input : inputs) {
                if (input.color.ordinal() != color) continue;
                oldInput = input.strength;
                break;
            }
            this.neighbourDirty |= oldInput != newInput;
            if (newInput <= 1) continue;
            this.externalSignals.get(side.ordinal()).add(new Signal(loc.x, loc.y, loc.z, side, newInput - 1, DyeColor.fromIndex((int)color)));
        }
    }

    @Override
    public boolean onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        return false;
    }

    private static int convertColorForRedNet(int colorOrSubnet) {
        return 15 - colorOrSubnet;
    }
}

