/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.gas.IGasConduit;
import crazypants.enderio.conduit.gas.PacketGasLevel;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.liquid.PacketFluidLevel;
import crazypants.enderio.machine.generator.combustion.PacketCombustionTank;
import crazypants.enderio.machine.generator.combustion.TileCombustionGenerator;
import crazypants.enderio.machine.generator.stirling.PacketBurnTime;
import crazypants.enderio.machine.generator.stirling.TileEntityStirlingGenerator;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityPortalFX;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class ClientUtil {
    public static void doFluidLevelUpdate(int x, int y, int z, PacketFluidLevel pkt) {
        TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_147438_o(x, y, z);
        if (pkt.tc == null || !(tile instanceof IConduitBundle)) {
            return;
        }
        IConduitBundle bundle = (IConduitBundle)tile;
        ILiquidConduit con = bundle.getConduit(ILiquidConduit.class);
        if (con == null) {
            return;
        }
        con.readFromNBT(pkt.tc, (short)1);
    }

    public static void doGasLevelUpdate(int x, int y, int z, PacketGasLevel pkt) {
        TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_147438_o(x, y, z);
        if (pkt.tc == null || !(tile instanceof IConduitBundle)) {
            return;
        }
        IConduitBundle bundle = (IConduitBundle)tile;
        IGasConduit con = bundle.getConduit(IGasConduit.class);
        if (con == null) {
            return;
        }
        con.readFromNBT(pkt.tc, (short)1);
    }

    public static void spawnFarmParticles(Random rand, List<BlockCoord> coords, int particlesCount) {
        int particleSetting = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (particleSetting >= 2) {
            return;
        }
        int particles = particleSetting == 0 ? particlesCount : particlesCount / 2;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        EffectRenderer effectRenderer = Minecraft.func_71410_x().field_71452_i;
        for (BlockCoord bc : coords) {
            for (int i = 0; i < particles; ++i) {
                double xOff = 0.5 + (rand.nextDouble() - 0.5) * 1.1;
                double yOff = 0.5 + (rand.nextDouble() - 0.5) * 0.2;
                double zOff = 0.5 + (rand.nextDouble() - 0.5) * 1.1;
                effectRenderer.func_78873_a((EntityFX)new EntityPortalFX((World)world, (double)bc.x + xOff, (double)bc.y + yOff, (double)bc.z + zOff, (rand.nextDouble() - 0.5) * 1.5, -rand.nextDouble(), (rand.nextDouble() - 0.5) * 1.5));
            }
        }
    }

    public static void setTankNBT(PacketCombustionTank message, int x, int y, int z) {
        NBTTagCompound tankRoot;
        TileCombustionGenerator tile = (TileCombustionGenerator)Minecraft.func_71410_x().field_71441_e.func_147438_o(x, y, z);
        if (tile == null) {
            return;
        }
        if (message.nbtRoot.func_74764_b("coolantTank")) {
            tankRoot = message.nbtRoot.func_74775_l("coolantTank");
            tile.getCoolantTank().readFromNBT(tankRoot);
        } else {
            tile.getCoolantTank().setFluid(null);
        }
        if (message.nbtRoot.func_74764_b("fuelTank")) {
            tankRoot = message.nbtRoot.func_74775_l("fuelTank");
            tile.getFuelTank().readFromNBT(tankRoot);
        } else {
            tile.getFuelTank().setFluid(null);
        }
    }

    public static void setStirlingBurnTime(PacketBurnTime message, int x, int y, int z) {
        TileEntityStirlingGenerator tile = (TileEntityStirlingGenerator)Minecraft.func_71410_x().field_71441_e.func_147438_o(x, y, z);
        if (tile == null) {
            return;
        }
        tile.burnTime = message.burnTime;
        tile.totalBurnTime = message.totalBurnTime;
    }
}

