/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.render;

import com.enderio.core.api.client.render.IRenderFace;
import com.enderio.core.client.render.ConnectedTextureRenderer;
import com.enderio.core.client.render.CubeRenderer;
import com.enderio.core.client.render.CustomCubeRenderer;
import com.enderio.core.client.render.RenderUtil;
import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.capbank.BlockCapBank;
import crazypants.enderio.machine.capbank.CapBankType;
import crazypants.enderio.machine.capbank.InfoDisplayType;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.machine.capbank.render.FillGauge;
import crazypants.enderio.machine.capbank.render.IInfoRenderer;
import crazypants.enderio.machine.capbank.render.IoDisplay;
import crazypants.enderio.power.PowerHandlerUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
@ThreadSafeISBRH(perThread=true)
public class CapBankRenderer
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    private ConnectedTextureRenderer connectedTexRenderer = new ConnectedTextureRenderer();
    private Map<InfoDisplayType, IInfoRenderer> infoRenderers;
    private FillGauge fillGaugeRenderer;

    public CapBankRenderer() {
        this.connectedTexRenderer.setMatchMeta(true);
        this.fillGaugeRenderer = new FillGauge();
        this.infoRenderers = new HashMap<InfoDisplayType, IInfoRenderer>();
        this.infoRenderers.put(InfoDisplayType.LEVEL_BAR, this.fillGaugeRenderer);
        this.infoRenderers.put(InfoDisplayType.IO, new IoDisplay());
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        CustomCubeRenderer ccr = CustomCubeRenderer.get();
        int meta = world.func_72805_g(x, y, z);
        CapBankType type = CapBankType.getTypeFromMeta(meta = MathHelper.func_76125_a((int)meta, (int)0, (int)(CapBankType.types().size() - 1)));
        if (!type.isMultiblock()) {
            this.connectedTexRenderer.setForceAllEdges(true);
        } else {
            this.connectedTexRenderer.setForceAllEdges(false);
        }
        this.connectedTexRenderer.setEdgeTexture(EnderIO.blockCapBank.getBorderIcon(0, meta));
        ccr.setOverrideTexture(renderer.field_147840_d);
        if (renderer.field_147840_d == null) {
            ccr.renderBlock(world, block, x, y, z, (IRenderFace)this.connectedTexRenderer);
        } else {
            ccr.renderBlock(world, block, x, y, z);
        }
        ccr.setOverrideTexture(null);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockCapBank.renderId;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        RenderUtil.bindBlockTexture();
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78382_b();
        CubeRenderer.get().render((Block)EnderIO.blockCapBank, item.func_77960_j());
        tes.func_78381_a();
        GL11.glEnable((int)32823);
        GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
        tes.func_78382_b();
        tes.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        tes.func_78372_c(0.0f, -0.1f, 0.0f);
        this.renderBorder(null, 0, 0, 0, item.func_77960_j());
        tes.func_78381_a();
        GL11.glDisable((int)32823);
        CapBankClientNetwork nw = new CapBankClientNetwork(-1);
        nw.setMaxEnergyStoredL(CapBankType.getTypeFromMeta(item.func_77960_j()).getMaxEnergyStored());
        nw.setEnergyStored(PowerHandlerUtil.getStoredEnergyForItem(item));
        FillGauge.GaugeInfo gi = FillGauge.GaugeInfo.DEFAULT;
        FillGauge.GaugeKey key = new FillGauge.GaugeKey(ForgeDirection.SOUTH, FillGauge.Type.SINGLE);
        this.fillGaugeRenderer.doRender(nw, RenderUtil.BRIGHTNESS_MAX, gi, key);
        tes.func_78372_c(0.0f, 0.1f, 0.0f);
    }

    private void renderBorder(IBlockAccess blockAccess, int x, int y, int z, int meta) {
        IIcon texture = EnderIO.blockCapBank.getBorderIcon(0, meta);
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            RenderUtil.renderConnectedTextureFace((IBlockAccess)blockAccess, (Block)EnderIO.blockCapBank, (int)x, (int)y, (int)z, (ForgeDirection)face, (IIcon)texture, (blockAccess == null ? 1 : 0) != 0, (boolean)false, (boolean)false);
        }
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float partialTick) {
        TileCapBank cb = (TileCapBank)te;
        if (!cb.hasDisplayTypes()) {
            return;
        }
        boolean glSetup = false;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            IInfoRenderer rend;
            InfoDisplayType type = cb.getDisplayType(dir);
            if (type == InfoDisplayType.NONE || (rend = this.infoRenderers.get((Object)type)) == null) continue;
            if (!glSetup) {
                glSetup = true;
                GL11.glPushAttrib((int)8192);
                GL11.glEnable((int)32823);
                GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            }
            rend.render(cb, dir, x, y, z, partialTick);
        }
        if (glSetup) {
            GL11.glPopMatrix();
            GL11.glPopAttrib();
        }
    }
}

