/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.zombie;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.generator.zombie.BubbleFX;
import crazypants.enderio.machine.generator.zombie.ContainerZombieGenerator;
import crazypants.enderio.machine.generator.zombie.GeneratorType;
import crazypants.enderio.machine.generator.zombie.GuiZombieGenerator;
import crazypants.enderio.machine.generator.zombie.TileZombieGenerator;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockZombieGenerator
extends AbstractMachineBlock<TileZombieGenerator> {
    public static BlockZombieGenerator create() {
        BlockZombieGenerator gen = new BlockZombieGenerator();
        gen.init();
        return gen;
    }

    protected BlockZombieGenerator() {
        this(ModObject.blockZombieGenerator, (Class<? extends TileZombieGenerator>)TileZombieGenerator.class);
    }

    protected BlockZombieGenerator(ModObject obj, Class<? extends TileZombieGenerator> clazz) {
        super(obj, clazz, Material.field_151574_g);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerZombieGenerator(player.field_71071_by, (TileZombieGenerator)world.func_147438_o(x, y, z));
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GuiZombieGenerator(player.field_71071_by, (TileZombieGenerator)world.func_147438_o(x, y, z));
    }

    @Override
    protected int getGuiId() {
        return 71;
    }

    public int func_149717_k() {
        return 0;
    }

    @Override
    public int func_149645_b() {
        return -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:stirlingGenFrontOn";
        }
        return "enderio:stirlingGenFrontOff";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntity te;
        if (rand.nextInt(3) == 0 && (te = world.func_147438_o(x, y, z)) instanceof TileZombieGenerator && ((TileZombieGenerator)te).isActive()) {
            for (int i = 0; i < 2; ++i) {
                float xOffset = 0.5f + (world.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.3f;
                float yOffset = 0.1f;
                float zOffset = 0.5f + (world.field_73012_v.nextFloat() * 2.0f - 1.0f) * 0.3f;
                BubbleFX fx = new BubbleFX(world, (float)x + xOffset, (float)y + yOffset, (float)z + zOffset, 0.0, 0.5, 0.0);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
            if (Config.machineSoundsEnabled) {
                float volume = Config.machineSoundVolume * 0.045f;
                world.func_72980_b((double)x + 0.5, (double)(y + 1), (double)z + 0.5, EnderIO.DOMAIN + ":generator.zombie.bubble", volume, world.field_73012_v.nextFloat() * 0.75f, false);
            }
        }
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te != null && te instanceof TileZombieGenerator) {
            tooltip.add(((TileZombieGenerator)te).getFluidStored(ForgeDirection.UNKNOWN) + " " + EnderIO.lang.localize("fluid.millibucket.abr"));
        }
    }

    public GeneratorType getGeneratorType() {
        return GeneratorType.ZOMBIE;
    }

    public static class BlockEnderGenerator
    extends BlockZombieGenerator {
        public BlockEnderGenerator() {
            super(ModObject.blockEnderGenerator, (Class<? extends TileZombieGenerator>)TileZombieGenerator.TileEnderGenerator.class);
        }

        public static BlockEnderGenerator create() {
            BlockEnderGenerator gen = new BlockEnderGenerator();
            gen.init();
            return gen;
        }

        @Override
        public GeneratorType getGeneratorType() {
            return GeneratorType.ENDER;
        }
    }

    public static class BlockFrankenZombieGenerator
    extends BlockZombieGenerator {
        public BlockFrankenZombieGenerator() {
            super(ModObject.blockFrankenzombieGenerator, (Class<? extends TileZombieGenerator>)TileZombieGenerator.TileFrankenZombieGenerator.class);
        }

        public static BlockFrankenZombieGenerator create() {
            BlockFrankenZombieGenerator gen = new BlockFrankenZombieGenerator();
            gen.init();
            return gen;
        }

        @Override
        public GeneratorType getGeneratorType() {
            return GeneratorType.FRANKENZOMBIE;
        }
    }
}

