/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import com.enderio.core.common.util.BlockCoord;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.CustomSeedFarmer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class CocoaFarmer
extends CustomSeedFarmer {
    public CocoaFarmer() {
        super(Blocks.field_150375_by, new ItemStack(Items.field_151100_aR, 1, 3));
        this.requiresFarmland = false;
        if (!Config.farmHarvestJungleWhenCocoa) {
            this.disableTreeFarm = true;
        }
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        return block == this.getPlantedBlock() && (meta & 0xC) >> 2 >= 2;
    }

    @Override
    protected boolean plant(TileFarmStation farm, World worldObj, BlockCoord bc) {
        worldObj.func_147465_d(bc.x, bc.y, bc.z, Blocks.field_150350_a, 0, 3);
        int dir = this.getPlantDirection(worldObj, bc);
        if (dir < 0) {
            return false;
        }
        worldObj.func_147465_d(bc.x, bc.y, bc.z, this.getPlantedBlock(), Direction.field_71579_d[dir], 3);
        farm.actionPerformed(false);
        return true;
    }

    @Override
    protected boolean canPlant(World worldObj, BlockCoord bc) {
        return this.getPlantDirection(worldObj, bc) > 0;
    }

    private int getPlantDirection(World worldObj, BlockCoord bc) {
        if (!worldObj.func_147437_c(bc.x, bc.y, bc.z)) {
            return -1;
        }
        for (int i = 2; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            int x = bc.x + dir.offsetX;
            int y = bc.y + dir.offsetY;
            int z = bc.z + dir.offsetZ;
            if (!this.validBlock(worldObj.func_147439_a(x, y, z), worldObj.func_72805_g(x, y, z))) continue;
            return i;
        }
        return -1;
    }

    private boolean validBlock(Block block, int metadata) {
        return block == Blocks.field_150364_r && BlockLog.func_150165_c((int)metadata) == 3;
    }
}

