/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.geom;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.geom.GeometryKey;
import crazypants.enderio.conduit.geom.Offset;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.util.ForgeDirection;

public class ConduitGeometryUtil {
    public static final ConduitGeometryUtil instance = new ConduitGeometryUtil();
    public static float STUB_WIDTH = 0.2f;
    public static float STUB_HEIGHT = 0.2f;
    public static float WIDTH;
    public static float HEIGHT;
    public static float HWIDTH;
    public static float HHEIGHT;
    public static Vector3d CORE_MIN;
    public static Vector3d CORE_MAX;
    public static BoundingBox CORE_BOUNDS;
    public static final float CONNECTOR_DEPTH = 0.05f;
    private static Map<ForgeDirection, BoundingBox[]> EXTERNAL_CONNECTOR_BOUNDS;
    private Map<GeometryKey, BoundingBox> boundsCache = new HashMap<GeometryKey, BoundingBox>();
    private EnumMap<ConduitConnectorType, BoundingBox> connectorBounds = new EnumMap(ConduitConnectorType.class);

    public static void setupBounds(float scale) {
        float size;
        WIDTH = size = 0.075f + 0.175f * scale;
        HEIGHT = size;
        HWIDTH = WIDTH / 2.0f;
        HHEIGHT = HEIGHT / 2.0f;
        CORE_MIN = new Vector3d((double)(0.5f - HWIDTH), 0.5 - (double)HHEIGHT, 0.5 - (double)HWIDTH);
        CORE_MAX = new Vector3d(ConduitGeometryUtil.CORE_MIN.x + (double)WIDTH, ConduitGeometryUtil.CORE_MIN.y + (double)HEIGHT, ConduitGeometryUtil.CORE_MIN.z + (double)WIDTH);
        CORE_BOUNDS = new BoundingBox(CORE_MIN, CORE_MAX);
        float connectorWidth = 0.25f + scale * 0.5f;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            EXTERNAL_CONNECTOR_BOUNDS.put(dir, ConduitGeometryUtil.createExternalConnector(dir, 0.05f, connectorWidth));
        }
    }

    private static BoundingBox[] createExternalConnector(ForgeDirection dir, float connectorDepth, float connectorWidth) {
        BoundingBox[] res = new BoundingBox[2];
        float cMin = 0.5f - connectorWidth / 2.0f;
        float cMax = 0.5f + connectorWidth / 2.0f;
        float dMin = 1.0f - connectorDepth / 2.0f;
        float dMax = 1.0f;
        res[0] = ConduitGeometryUtil.createConnectorComponent(dir, cMin, cMax, dMin, dMax);
        cMin = 0.5f - connectorWidth / 3.0f;
        cMax = 0.5f + connectorWidth / 3.0f;
        dMin = 1.0f - connectorDepth;
        dMax = 1.0f - connectorDepth / 2.0f;
        res[1] = ConduitGeometryUtil.createConnectorComponent(dir, cMin, cMax, dMin, dMax);
        return res;
    }

    private static BoundingBox createConnectorComponent(ForgeDirection dir, float cornerMin, float cornerMax, float depthMin, float depthMax) {
        float minX = (float)(1 - Math.abs(dir.offsetX)) * cornerMin + (float)dir.offsetX * depthMin;
        float minY = (float)(1 - Math.abs(dir.offsetY)) * cornerMin + (float)dir.offsetY * depthMin;
        float minZ = (float)(1 - Math.abs(dir.offsetZ)) * cornerMin + (float)dir.offsetZ * depthMin;
        float maxX = (float)(1 - Math.abs(dir.offsetX)) * cornerMax + (float)dir.offsetX * depthMax;
        float maxY = (float)(1 - Math.abs(dir.offsetY)) * cornerMax + (float)dir.offsetY * depthMax;
        float maxZ = (float)(1 - Math.abs(dir.offsetZ)) * cornerMax + (float)dir.offsetZ * depthMax;
        minX = ConduitGeometryUtil.fix(minX);
        minY = ConduitGeometryUtil.fix(minY);
        minZ = ConduitGeometryUtil.fix(minZ);
        maxX = ConduitGeometryUtil.fix(maxX);
        maxY = ConduitGeometryUtil.fix(maxY);
        maxZ = ConduitGeometryUtil.fix(maxZ);
        BoundingBox bb = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        bb = bb.fixMinMax();
        return bb;
    }

    private static float fix(float val) {
        return val < 0.0f ? 1.0f + val : val;
    }

    private ConduitGeometryUtil() {
    }

    public BoundingBox getExternalConnectorBoundingBox(ForgeDirection dir) {
        return this.getExternalConnectorBoundingBoxes(dir)[0];
    }

    public BoundingBox[] getExternalConnectorBoundingBoxes(ForgeDirection dir) {
        return EXTERNAL_CONNECTOR_BOUNDS.get(dir);
    }

    public BoundingBox getBoundingBox(Class<? extends IConduit> type, ForgeDirection dir, boolean isStub, Offset offset) {
        GeometryKey key = new GeometryKey(dir, isStub, offset, type);
        BoundingBox result = this.boundsCache.get(key);
        if (result == null) {
            result = this.createConduitBounds(type, key);
            this.boundsCache.put(key, result);
        }
        return result;
    }

    public Vector3d getTranslation(ForgeDirection dir, Offset offset) {
        Vector3d result = new Vector3d((double)offset.xOffset, (double)offset.yOffset, (double)offset.zOffset);
        result.scale((double)WIDTH);
        return result;
    }

    public BoundingBox createBoundsForConnectionController(ForgeDirection dir, Offset offset) {
        Vector3d nonUniformScale = ForgeDirectionOffsets.forDirCopy((ForgeDirection)dir);
        nonUniformScale.scale(0.5);
        nonUniformScale.x = 0.8 * (1.0 - Math.abs(nonUniformScale.x));
        nonUniformScale.y = 0.8 * (1.0 - Math.abs(nonUniformScale.y));
        nonUniformScale.z = 0.8 * (1.0 - Math.abs(nonUniformScale.z));
        BoundingBox bb = CORE_BOUNDS;
        bb = bb.scale(nonUniformScale.x, nonUniformScale.y, nonUniformScale.z);
        double offsetFromEnd = Math.min(bb.sizeX(), bb.sizeY());
        offsetFromEnd = Math.min(offsetFromEnd, (double)bb.sizeZ());
        offsetFromEnd = Math.max(offsetFromEnd, 0.075);
        double transMag = 0.5 - offsetFromEnd * 1.2;
        Vector3d trans = ForgeDirectionOffsets.forDirCopy((ForgeDirection)dir);
        trans.scale(transMag);
        bb = bb.translate(trans);
        bb = bb.translate(this.getTranslation(dir, offset));
        return bb;
    }

    private BoundingBox createConduitBounds(Class<? extends IConduit> type, GeometryKey key) {
        return this.createConduitBounds(type, key.dir, key.isStub, key.offset);
    }

    private BoundingBox createConduitBounds(Class<? extends IConduit> type, ForgeDirection dir, boolean isStub, Offset offset) {
        BoundingBox bb = CORE_BOUNDS;
        Vector3d min = bb.getMin();
        Vector3d max = bb.getMax();
        switch (dir) {
            case WEST: {
                min.x = isStub ? (double)Math.max(0.0f, bb.minX - STUB_WIDTH) : 0.0;
                max.x = bb.minX;
                break;
            }
            case EAST: {
                min.x = bb.maxX;
                max.x = isStub ? (double)Math.min(1.0f, bb.maxX + STUB_WIDTH) : 1.0;
                break;
            }
            case DOWN: {
                min.y = isStub ? (double)Math.max(0.0f, bb.minY - STUB_HEIGHT) : 0.0;
                max.y = bb.minY;
                break;
            }
            case UP: {
                max.y = isStub ? (double)Math.min(1.0f, bb.maxY + STUB_HEIGHT) : 1.0;
                min.y = bb.maxY;
                break;
            }
            case NORTH: {
                min.z = isStub ? (double)Math.max(0.0f, bb.minZ - STUB_WIDTH) : 0.0;
                max.z = bb.minZ;
                break;
            }
            case SOUTH: {
                max.z = isStub ? (double)Math.min(1.0f, bb.maxZ + STUB_WIDTH) : 1.0;
                min.z = bb.maxZ;
                break;
            }
        }
        Vector3d trans = this.getTranslation(dir, offset);
        min.add(trans);
        max.add(trans);
        bb = new BoundingBox(VecmathUtil.clamp((Vector3d)min, (double)0.0, (double)1.0), VecmathUtil.clamp((Vector3d)max, (double)0.0, (double)1.0));
        return bb;
    }

    static {
        EXTERNAL_CONNECTOR_BOUNDS = new HashMap<ForgeDirection, BoundingBox[]>();
        ConduitGeometryUtil.setupBounds(0.5f);
    }
}

