/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import com.enderio.core.api.client.gui.ITabPanel;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.client.render.RenderUtil;
import cpw.mods.fml.common.Optional;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.gas.IGasConduit;
import crazypants.enderio.conduit.gui.BaseSettingsPanel;
import crazypants.enderio.conduit.gui.ExternalConnectionContainer;
import crazypants.enderio.conduit.gui.LiquidSettings;
import crazypants.enderio.conduit.gui.TabFactory;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.me.IMEConduit;
import crazypants.enderio.conduit.oc.IOCConduit;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.gui.GuiContainerBaseEIO;
import crazypants.enderio.gui.IconEIO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GuiExternalConnection
extends GuiContainerBaseEIO {
    private static final int TAB_HEIGHT = 24;
    private static int nextButtonId = 1;
    private static final Map<Class<? extends IConduit>, Integer> TAB_ORDER = new HashMap<Class<? extends IConduit>, Integer>();
    final InventoryPlayer playerInv;
    final IConduitBundle bundle;
    private final ForgeDirection dir;
    private final List<IConduit> conduits = new ArrayList<IConduit>();
    private final List<ITabPanel> tabs = new ArrayList<ITabPanel>();
    private int activeTab = 0;
    private int tabYOffset = 4;
    private final ExternalConnectionContainer container = (ExternalConnectionContainer)this.field_147002_h;

    public static int nextButtonId() {
        return nextButtonId++;
    }

    public static int nextButtonIds(int count) {
        int id = nextButtonId;
        nextButtonId += count;
        return id;
    }

    public GuiExternalConnection(InventoryPlayer playerInv, IConduitBundle bundle, ForgeDirection dir) {
        super((Container)new ExternalConnectionContainer(playerInv, bundle, dir), "externalConduitConnection", "itemFilter");
        this.playerInv = playerInv;
        this.bundle = bundle;
        this.dir = dir;
        this.field_147000_g = 243;
        this.field_146999_f = 206;
        this.container.setInoutSlotsVisible(false, false);
        ArrayList<IConduit> cons = new ArrayList<IConduit>(bundle.getConduits());
        Collections.sort(cons, new Comparator<IConduit>(){

            @Override
            public int compare(IConduit o1, IConduit o2) {
                Integer int1 = (Integer)TAB_ORDER.get(o1.getBaseConduitType());
                if (int1 == null) {
                    return 1;
                }
                Integer int2 = (Integer)TAB_ORDER.get(o2.getBaseConduitType());
                if (int2 == null) {
                    return 1;
                }
                return Integer.compare(int1, int2);
            }
        });
        for (IConduit con : cons) {
            ITabPanel tab;
            if (!con.containsExternalConnection(dir) && !con.canConnectToExternal(dir, true) || (tab = TabFactory.instance.createPanelForConduit(this, con)) == null) continue;
            this.conduits.add(con);
            this.tabs.add(tab);
            tab.deactivate();
        }
    }

    public IConduitBundle getBundle() {
        return this.bundle;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        ((ExternalConnectionContainer)this.field_147002_h).createGhostSlots(this.getGhostSlots());
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (i != this.activeTab) continue;
            this.tabs.get(i).onGuiInit(this.field_147003_i + 10, this.field_147009_r, this.field_146999_f - 20, this.field_147000_g - 20);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private boolean handleOobClick(int x, int y, int button) {
        GhostSlot slot;
        boolean hasItem;
        boolean outOfBounds = x < this.field_147003_i || y < this.field_147009_r || x >= this.field_147003_i + this.field_146999_f || y >= this.field_147009_r + this.field_147000_g;
        boolean bl = hasItem = this.playerInv.func_70445_o() != null;
        if (outOfBounds && hasItem && !this.getGhostSlots().isEmpty() && (slot = this.getGhostSlot(x, y)) != null) {
            this.ghostSlotClicked(slot, x, y, button);
            return true;
        }
        return false;
    }

    protected void func_146286_b(int x, int y, int button) {
        if (this.handleOobClick(x, y, button)) {
            return;
        }
        super.func_146286_b(x, y, button);
    }

    protected void func_73864_a(int x, int y, int button) {
        if (this.handleOobClick(x, y, button)) {
            return;
        }
        int tabLeftX = this.field_146999_f;
        int tabRightX = tabLeftX + 22;
        int minY = this.tabYOffset;
        int maxY = minY + this.conduits.size() * 24;
        if ((x -= this.field_147003_i) > tabLeftX && x < tabRightX + 24 && (y -= this.field_147009_r) > minY && y < maxY) {
            this.tabs.get(this.activeTab).deactivate();
            this.getGhostSlots().clear();
            this.activeTab = (y - minY) / 24;
            this.func_73866_w_();
            return;
        }
        this.tabs.get(this.activeTab).mouseClicked(x, y, button);
        super.func_73864_a(x + this.field_147003_i, y + this.field_147009_r, button);
    }

    public void setSize(int x, int y) {
        this.field_146999_f = x;
        this.field_147000_g = y;
    }

    protected void func_146284_a(GuiButton guiButton) {
        super.func_146284_a(guiButton);
        this.tabs.get(this.activeTab).actionPerformed(guiButton);
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        IWidgetIcon icon;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        int tabX = sx + this.field_146999_f - 3;
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78382_b();
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (i == this.activeTab) continue;
            RenderUtil.bindTexture((ResourceLocation)IconEIO.TEXTURE);
            IconEIO.map.render((IWidgetIcon)IconEIO.INACTIVE_TAB, (double)tabX, (double)(sy + this.tabYOffset + i * 24));
            icon = this.tabs.get(i).getIcon();
            icon.getMap().render(icon, (double)(tabX - 1), (double)(sy + this.tabYOffset + i * 24 + 4));
        }
        tes.func_78381_a();
        int textureHeight = 195;
        if (this.tabs.isEmpty()) {
            this.bindGuiTexture();
        } else {
            ITabPanel tab = this.tabs.get(this.activeTab);
            RenderUtil.bindTexture((ResourceLocation)tab.getTexture());
            if (tab instanceof BaseSettingsPanel) {
                textureHeight = ((BaseSettingsPanel)tab).getTextureHeight();
            }
        }
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, textureHeight);
        RenderUtil.bindTexture((ResourceLocation)IconEIO.TEXTURE);
        tes.func_78382_b();
        IconEIO.map.render((IWidgetIcon)IconEIO.ACTIVE_TAB, (double)tabX, (double)(sy + this.tabYOffset + this.activeTab * 24));
        if (this.tabs.size() > 0) {
            icon = this.tabs.get(this.activeTab).getIcon();
            icon.getMap().render(icon, (double)(tabX - 1), (double)(sy + this.tabYOffset + this.activeTab * 24 + 4));
            tes.func_78381_a();
            this.tabs.get(this.activeTab).render(par1, par2, par3);
        } else {
            tes.func_78381_a();
        }
        super.func_146976_a(par1, par2, par3);
    }

    public ForgeDirection getDir() {
        return this.dir;
    }

    public ExternalConnectionContainer getContainer() {
        return this.container;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gc, int x, int y, int w, int h) {
        List slots;
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.tabs.size() > 0) {
            int tabX = sx + this.field_146999_f - 3;
            int tabY = sy + this.tabYOffset;
            if (x + w >= tabX && x < tabX + 14 && y + h >= tabY && y < tabY + this.tabs.size() * 24) {
                return true;
            }
        }
        if ((slots = this.getGhostSlots()) != null && !slots.isEmpty()) {
            for (GhostSlot slot : slots) {
                int slotX = sx + slot.x;
                int slotY = sy + slot.y;
                if (x + w < slotX || x >= slotX + 20 || y + h < slotY || y >= slotY + 20) continue;
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean handleDragNDrop(GuiContainer gc, int x, int y, ItemStack is, int button) {
        LiquidSettings settings;
        if (super.handleDragNDrop(gc, x, y, is, button)) {
            return true;
        }
        if (is != null && is.field_77994_a > 0 && !this.tabs.isEmpty() && this.tabs.get(this.activeTab) instanceof LiquidSettings && (settings = (LiquidSettings)this.tabs.get(this.activeTab)).setFilterFromItem(x -= this.field_147003_i, y -= this.field_147009_r, is)) {
            is.field_77994_a = 0;
            return true;
        }
        return false;
    }

    protected void drawFakeItemStack(int x, int y, ItemStack stack) {
        super.drawFakeItemStack(x, y, stack);
        field_146296_j.func_94148_a(this.field_146289_q, this.field_146297_k.field_71446_o, stack, x, y, "");
    }

    public void clearGhostSlots() {
        this.getGhostSlots().clear();
        ((ExternalConnectionContainer)this.field_147002_h).createGhostSlots(this.getGhostSlots());
    }

    static {
        TAB_ORDER.put(IItemConduit.class, 0);
        TAB_ORDER.put(ILiquidConduit.class, 1);
        TAB_ORDER.put(IRedstoneConduit.class, 2);
        TAB_ORDER.put(IPowerConduit.class, 3);
        TAB_ORDER.put(IMEConduit.class, 4);
        TAB_ORDER.put(IGasConduit.class, 5);
        TAB_ORDER.put(IOCConduit.class, 6);
    }
}

