/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import com.enderio.core.client.gui.widget.GhostBackgroundItemSlot;
import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.ContainerEnder;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.gui.FilterChangeListener;
import crazypants.enderio.conduit.gui.PacketSlotVisibility;
import crazypants.enderio.conduit.gui.item.InventoryUpgrades;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.SpeedUpgrade;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.network.PacketHandler;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ExternalConnectionContainer
extends ContainerEnder<InventoryUpgrades> {
    private final IItemConduit itemConduit;
    private final ForgeDirection direction;
    private int speedUpgradeSlotLimit = 15;
    private static final int outputFilterUpgradeSlot = 36;
    private static final int inputFilterUpgradeSlot = 37;
    private static final int speedUpgradeSlot = 38;
    private static final int functionUpgradeSlot = 39;
    private Slot slotSpeedUpgrades;
    private Slot slotFunctionUpgrades;
    private Slot slotInputFilterUpgrades;
    private Slot slotOutputFilterUpgrades;
    private final List<Point> slotLocations = new ArrayList<Point>();
    final List<FilterChangeListener> filterListeners = new ArrayList<FilterChangeListener>();
    final List<GhostBackgroundItemSlot> bgSlots = new ArrayList<GhostBackgroundItemSlot>();

    public ExternalConnectionContainer(InventoryPlayer playerInv, IConduitBundle bundle, ForgeDirection dir) {
        super(playerInv, (IInventory)new InventoryUpgrades(bundle.getConduit(IItemConduit.class), dir));
        this.direction = dir;
        this.itemConduit = bundle.getConduit(IItemConduit.class);
        this.slotLocations.addAll(this.playerSlotLocations.values());
        if (this.itemConduit != null) {
            int x = 23;
            int y = 71;
            this.slotOutputFilterUpgrades = this.func_75146_a(new FilterSlot(this.getInv(), 3, x, y));
            this.slotLocations.add(new Point(x, y));
            this.bgSlots.add(new GhostBackgroundItemSlot((Item)EnderIO.itemBasicFilterUpgrade, this.slotOutputFilterUpgrades));
            x = 113;
            y = 71;
            this.slotInputFilterUpgrades = this.func_75146_a(new FilterSlot(this.getInv(), 2, x, y));
            this.slotLocations.add(new Point(x, y));
            this.bgSlots.add(new GhostBackgroundItemSlot((Item)EnderIO.itemBasicFilterUpgrade, this.slotInputFilterUpgrades));
            x = 131;
            y = 71;
            this.slotSpeedUpgrades = this.func_75146_a(new Slot(this.getInv(), 0, x, y){

                public boolean func_75214_a(ItemStack par1ItemStack) {
                    return ((InventoryUpgrades)ExternalConnectionContainer.this.getInv()).func_94041_b(0, par1ItemStack);
                }

                public int func_75219_a() {
                    return ExternalConnectionContainer.this.speedUpgradeSlotLimit;
                }
            });
            this.slotLocations.add(new Point(x, y));
            this.bgSlots.add(new GhostBackgroundItemSlot((Item)EnderIO.itemExtractSpeedUpgrade, this.slotSpeedUpgrades));
            x = 149;
            y = 71;
            this.slotFunctionUpgrades = this.func_75146_a(new Slot(this.getInv(), 1, x, y){

                public boolean func_75214_a(ItemStack par1ItemStack) {
                    return ((InventoryUpgrades)ExternalConnectionContainer.this.getInv()).func_94041_b(1, par1ItemStack);
                }

                public int func_75219_a() {
                    return 1;
                }
            });
            this.slotLocations.add(new Point(x, y));
            this.bgSlots.add(new GhostBackgroundItemSlot((Item)EnderIO.itemFunctionUpgrade, this.slotFunctionUpgrades));
        }
        this.setInventorySlotsVisible(false);
    }

    public void createGhostSlots(List<GhostSlot> slots) {
        slots.addAll(this.bgSlots);
    }

    public Point getPlayerInventoryOffset() {
        return new Point(23, 161);
    }

    public void addFilterListener(FilterChangeListener list) {
        this.filterListeners.add(list);
    }

    protected void filterChanged() {
        for (FilterChangeListener list : this.filterListeners) {
            list.onFilterChanged();
        }
    }

    public boolean hasSpeedUpgrades() {
        return this.slotSpeedUpgrades != null && this.slotSpeedUpgrades.func_75216_d();
    }

    public boolean hasFunctionUpgrades() {
        return this.slotFunctionUpgrades != null && this.slotFunctionUpgrades.func_75216_d();
    }

    public boolean hasFilterUpgrades(boolean input) {
        Slot slot = input ? this.slotInputFilterUpgrades : this.slotOutputFilterUpgrades;
        return slot != null && slot.func_75216_d();
    }

    public ForgeDirection getDirection() {
        return this.direction;
    }

    public IItemFilter getFilter(boolean input) {
        if (this.itemConduit == null) {
            return null;
        }
        return input ? this.itemConduit.getInputFilter(this.direction) : this.itemConduit.getOutputFilter(this.direction);
    }

    public void setInoutSlotsVisible(boolean inputVisible, boolean outputVisible) {
        if (this.itemConduit == null) {
            return;
        }
        this.setSlotsVisible(inputVisible, 37, 38);
        this.setSlotsVisible(inputVisible, 38, 39);
        this.setSlotsVisible(outputVisible, 36, 37);
        this.setSlotsVisible(inputVisible || outputVisible, 39, 40);
        World world = this.itemConduit.getBundle().getWorld();
        if (world.field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSlotVisibility(inputVisible, outputVisible));
        }
    }

    public void setInventorySlotsVisible(boolean visible) {
        this.setSlotsVisible(visible, 0, 36);
    }

    private void setSlotsVisible(boolean visible, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            Slot s = (Slot)this.field_75151_b.get(i);
            if (visible) {
                s.field_75223_e = this.slotLocations.get((int)i).x;
                s.field_75221_f = this.slotLocations.get((int)i).y;
                continue;
            }
            s.field_75223_e = -3000;
            s.field_75221_f = -3000;
        }
    }

    public ItemStack func_75144_a(int par1, int par2, int par3, EntityPlayer par4EntityPlayer) {
        ItemStack st = par4EntityPlayer.field_71071_by.func_70445_o();
        this.setSpeedUpgradeSlotLimit(st);
        try {
            return super.func_75144_a(par1, par2, par3, par4EntityPlayer);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setSpeedUpgradeSlotLimit(ItemStack st) {
        if (st != null && st.func_77973_b() == EnderIO.itemExtractSpeedUpgrade) {
            SpeedUpgrade speedUpgrade = EnderIO.itemExtractSpeedUpgrade.getSpeedUpgrade(st);
            this.speedUpgradeSlotLimit = speedUpgrade.maxStackSize;
        }
    }

    private boolean mergeItemStackSpecial(ItemStack origStack, Slot targetSlot) {
        if (!targetSlot.func_75214_a(origStack)) {
            return false;
        }
        this.setSpeedUpgradeSlotLimit(origStack);
        ItemStack curStack = targetSlot.func_75211_c();
        int maxStackSize = Math.min(origStack.func_77976_d(), targetSlot.func_75219_a());
        if (curStack == null) {
            curStack = origStack.func_77946_l();
            curStack.field_77994_a = Math.min(origStack.field_77994_a, maxStackSize);
            origStack.field_77994_a -= curStack.field_77994_a;
            targetSlot.func_75215_d(curStack);
            targetSlot.func_75218_e();
            return true;
        }
        if (ItemUtil.areStackMergable((ItemStack)curStack, (ItemStack)origStack)) {
            int mergedSize = curStack.field_77994_a + origStack.field_77994_a;
            if (mergedSize <= maxStackSize) {
                origStack.field_77994_a = 0;
                curStack.field_77994_a = mergedSize;
                targetSlot.func_75218_e();
                return true;
            }
            if (curStack.field_77994_a < maxStackSize) {
                origStack.field_77994_a -= maxStackSize - curStack.field_77994_a;
                curStack.field_77994_a = maxStackSize;
                targetSlot.func_75218_e();
                return true;
            }
        }
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack copystack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack origStack = slot.func_75211_c();
            copystack = origStack.func_77946_l();
            boolean merged = false;
            if (slotIndex < 36) {
                for (int targetSlotIdx = 36; targetSlotIdx <= 39; ++targetSlotIdx) {
                    Slot targetSlot = (Slot)this.field_75151_b.get(targetSlotIdx);
                    if (targetSlot.field_75223_e < 0 || !this.mergeItemStackSpecial(origStack, targetSlot)) continue;
                    merged = true;
                    break;
                }
            } else {
                merged = this.func_75135_a(origStack, 0, 36, false);
            }
            if (!merged) {
                return null;
            }
            slot.func_75220_a(origStack, copystack);
            if (origStack.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
            if (origStack.field_77994_a == copystack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(entityPlayer, origStack);
        }
        return copystack;
    }

    public List<String> getFunctionUpgradeToolTipText() {
        return Collections.emptyList();
    }

    private class FilterSlot
    extends Slot {
        public FilterSlot(IInventory par1iInventory, int par2, int par3, int par4) {
            super(par1iInventory, par2, par3, par4);
        }

        public int func_75219_a() {
            return 1;
        }

        public void func_75218_e() {
            ExternalConnectionContainer.this.filterChanged();
        }

        public boolean func_75214_a(ItemStack par1ItemStack) {
            return this.field_75224_c.func_94041_b(this.getSlotIndex(), par1ItemStack);
        }
    }
}

