/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.recipe;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeInput {
    private final int slot;
    private final ItemStack input;
    private final boolean useMeta;
    private final FluidStack fluid;
    private final float multiplier;

    public RecipeInput(ItemStack input) {
        this(input, true);
    }

    public RecipeInput(ItemStack input, boolean useMeta) {
        this(input, useMeta, null, 1.0f, -1);
    }

    public RecipeInput(FluidStack fluid) {
        this(null, false, fluid, 1.0f, -1);
    }

    public RecipeInput(FluidStack fluidStack, float mulitplier) {
        this(null, true, fluidStack, mulitplier, -1);
    }

    public RecipeInput(ItemStack item, boolean useMeta, float multiplier, int slot) {
        this(item, useMeta, null, multiplier, slot);
    }

    protected RecipeInput(ItemStack input, boolean useMeta, FluidStack fluid, float mulitplier, int slot) {
        this.input = input == null ? null : input.func_77946_l();
        this.useMeta = useMeta;
        this.fluid = fluid == null ? null : fluid.copy();
        this.multiplier = mulitplier;
        this.slot = slot;
    }

    public RecipeInput(RecipeInput copyFrom) {
        this.input = copyFrom.input == null ? null : copyFrom.input.func_77946_l();
        this.fluid = copyFrom.fluid == null ? null : copyFrom.fluid.copy();
        this.useMeta = copyFrom.useMeta;
        this.multiplier = copyFrom.multiplier;
        this.slot = copyFrom.slot;
    }

    public RecipeInput copy() {
        return new RecipeInput(this);
    }

    public boolean isFluid() {
        return this.fluid != null;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public FluidStack getFluidInput() {
        return this.fluid;
    }

    public float getMulitplier() {
        return this.multiplier;
    }

    public int getSlotNumber() {
        return this.slot;
    }

    public boolean isInput(ItemStack test) {
        if (test == null || this.input == null) {
            return false;
        }
        if (this.useMeta) {
            return test.func_77973_b() == this.input.func_77973_b() && test.func_77960_j() == this.input.func_77960_j();
        }
        return test.func_77973_b() == this.input.func_77973_b();
    }

    public boolean isInput(FluidStack test) {
        if (test == null || this.fluid == null) {
            return false;
        }
        return test.isFluidEqual(this.fluid);
    }

    public ItemStack[] getEquivelentInputs() {
        return null;
    }

    public String toString() {
        return "RecipeInput [input=" + this.input + ", useMeta=" + this.useMeta + "]";
    }
}

