/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui.item;

import com.enderio.core.api.client.gui.IGuiScreen;
import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.gui.button.ColorButton;
import com.enderio.core.client.gui.button.MultiIconButton;
import com.enderio.core.client.gui.button.ToggleButton;
import com.enderio.core.client.render.ColorUtil;
import com.enderio.core.client.render.EnderWidget;
import com.enderio.core.common.util.DyeColor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.gui.BaseSettingsPanel;
import crazypants.enderio.conduit.gui.FilterChangeListener;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.gui.item.InventoryUpgrades;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.enderio.conduit.packet.PacketExtractMode;
import crazypants.enderio.conduit.packet.PacketItemConduitFilter;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.RedstoneModeButton;
import crazypants.enderio.machine.IRedstoneModeControlable;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.network.PacketHandler;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class ItemSettings
extends BaseSettingsPanel {
    private static final int ID_REDSTONE_BUTTON = 12614;
    private static final int ID_COLOR_BUTTON = 179816;
    private static final int ID_LOOP = 22;
    private static final int ID_ROUND_ROBIN = 24;
    private static final int ID_PRIORITY_UP = 25;
    private static final int ID_PRIORITY_DOWN = 26;
    private static final int ID_INSERT_CHANNEL = 23;
    private static final int ID_EXTRACT_CHANNEL = 27;
    @Nonnull
    private IItemConduit itemConduit;
    private final ToggleButton loopB;
    private final ToggleButton roundRobinB;
    private final MultiIconButton priUpB;
    private final MultiIconButton priDownB;
    private final RedstoneModeButton rsB;
    @Nonnull
    private final ColorButton colorB;
    private ColorButton insertChannelB;
    private ColorButton extractChannelB;
    private int priLeft = 46;
    private int priWidth = 32;
    private IItemFilterGui insertFilterGui;
    private IItemFilterGui extractFilterGui;

    public ItemSettings(final @Nonnull GuiExternalConnection gui, @Nonnull IConduit con) {
        super(IconEIO.WRENCH_OVERLAY_ITEM, EnderIO.lang.localize("itemItemConduit.name"), gui, con, "filter_upgrade_settings");
        this.itemConduit = (IItemConduit)con;
        this.textureHeight += 48;
        int x = this.leftColumn;
        int y = this.customTop;
        this.insertChannelB = new ColorButton((IGuiScreen)gui, 23, x, y);
        this.insertChannelB.setColorIndex(0);
        this.insertChannelB.setToolTipHeading(EnderIO.lang.localize("gui.conduit.item.channel"));
        x = this.rightColumn;
        this.extractChannelB = new ColorButton((IGuiScreen)gui, 27, x, y);
        this.extractChannelB.setColorIndex(0);
        this.extractChannelB.setToolTipHeading(EnderIO.lang.localize("gui.conduit.item.channel"));
        this.roundRobinB = new ToggleButton((IGuiScreen)gui, 24, x += 4 + this.extractChannelB.getWidth(), y, (IWidgetIcon)IconEIO.ROUND_ROBIN_OFF, (IWidgetIcon)IconEIO.ROUND_ROBIN);
        this.roundRobinB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.roundRobinEnabled")});
        this.roundRobinB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.roundRobinDisabled")});
        this.roundRobinB.setPaintSelectedBorder(false);
        this.loopB = new ToggleButton((IGuiScreen)gui, 22, x += 4 + this.roundRobinB.getWidth(), y, (IWidgetIcon)IconEIO.LOOP_OFF, (IWidgetIcon)IconEIO.LOOP);
        this.loopB.setSelectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.selfFeedEnabled")});
        this.loopB.setUnselectedToolTip(new String[]{EnderIO.lang.localize("gui.conduit.item.selfFeedDisabled")});
        this.loopB.setPaintSelectedBorder(false);
        x = this.rightColumn;
        int x0 = x + 20;
        this.colorB = new ColorButton((IGuiScreen)gui, 179816, x0, y += this.insertChannelB.getHeight() + 6);
        this.colorB.setColorIndex(this.itemConduit.getExtractionSignalColor(gui.getDir()).ordinal());
        this.colorB.setToolTipHeading(EnderIO.lang.localize("gui.conduit.item.channel"));
        this.rsB = new RedstoneModeButton((IGuiScreen)gui, 12614, x, y, new IRedstoneModeControlable(){

            @Override
            public void setRedstoneControlMode(RedstoneControlMode mode) {
                RedstoneControlMode curMode = this.getRedstoneControlMode();
                ItemSettings.this.itemConduit.setExtractionRedstoneMode(mode, gui.getDir());
                if (curMode != mode) {
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(ItemSettings.this.itemConduit, gui.getDir()));
                }
            }

            @Override
            public RedstoneControlMode getRedstoneControlMode() {
                return ItemSettings.this.itemConduit.getExtractionRedstoneMode(gui.getDir());
            }
        });
        x = this.priLeft + this.priWidth + 9;
        this.priUpB = MultiIconButton.createAddButton((IGuiScreen)gui, (int)25, (int)x, (int)y);
        this.priDownB = MultiIconButton.createMinusButton((IGuiScreen)gui, (int)26, (int)x, (int)(y + 8));
        FilterChangeListener fcl = new FilterChangeListener(){

            @Override
            public void onFilterChanged() {
                if (ItemSettings.this.insertFilterGui != null) {
                    ItemSettings.this.insertFilterGui.deactivate();
                    ItemSettings.this.insertFilterGui = null;
                }
                if (ItemSettings.this.extractFilterGui != null) {
                    ItemSettings.this.extractFilterGui.deactivate();
                    ItemSettings.this.extractFilterGui = null;
                }
                gui.clearGhostSlots();
                IItemFilter filt = gui.getContainer().getFilter(false);
                if (filt != null) {
                    ItemSettings.this.insertFilterGui = filt.getGui(gui, ((InventoryUpgrades)gui.getContainer().getInv()).itemConduit, false);
                }
                if ((filt = gui.getContainer().getFilter(true)) != null) {
                    ItemSettings.this.extractFilterGui = filt.getGui(gui, ((InventoryUpgrades)gui.getContainer().getInv()).itemConduit, true);
                }
                if (ItemSettings.this.insertFilterGui != null) {
                    ItemSettings.this.insertFilterGui.updateButtons();
                }
                if (ItemSettings.this.extractFilterGui != null) {
                    ItemSettings.this.extractFilterGui.updateButtons();
                }
            }
        };
        fcl.onFilterChanged();
        gui.getContainer().addFilterListener(fcl);
    }

    @Override
    protected void initCustomOptions() {
        this.gui.getContainer().setInoutSlotsVisible(true, true);
        this.gui.getContainer().createGhostSlots(this.gui.getGhostSlots());
        this.gui.getContainer().setInventorySlotsVisible(true);
        this.updateGuiVisibility();
    }

    private void updateGuiVisibility() {
        this.updateButtons();
    }

    private void updateButtons() {
        this.rsB.onGuiInit();
        this.rsB.setMode(this.itemConduit.getExtractionRedstoneMode(this.gui.getDir()));
        this.loopB.onGuiInit();
        this.loopB.setSelected(this.itemConduit.isSelfFeedEnabled(this.gui.getDir()));
        this.roundRobinB.onGuiInit();
        this.roundRobinB.setSelected(this.itemConduit.isRoundRobinEnabled(this.gui.getDir()));
        this.priUpB.onGuiInit();
        this.priDownB.onGuiInit();
        this.insertChannelB.onGuiInit();
        this.insertChannelB.setColorIndex(this.itemConduit.getOutputColor(this.gui.getDir()).ordinal());
        this.extractChannelB.onGuiInit();
        this.extractChannelB.setColorIndex(this.itemConduit.getInputColor(this.gui.getDir()).ordinal());
        if (this.insertFilterGui != null) {
            this.insertFilterGui.updateButtons();
        }
        if (this.extractFilterGui != null) {
            this.extractFilterGui.updateButtons();
        }
    }

    @Override
    public void actionPerformed(@Nonnull GuiButton guiButton) {
        super.actionPerformed(guiButton);
        if (guiButton.field_146127_k == 179816) {
            this.itemConduit.setExtractionSignalColor(this.gui.getDir(), DyeColor.fromIndex((int)this.colorB.getColorIndex()));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.itemConduit, this.gui.getDir()));
            return;
        }
        if (guiButton.field_146127_k == 22) {
            this.itemConduit.setSelfFeedEnabled(this.gui.getDir(), !this.itemConduit.isSelfFeedEnabled(this.gui.getDir()));
        } else if (guiButton.field_146127_k == 24) {
            this.itemConduit.setRoundRobinEnabled(this.gui.getDir(), !this.itemConduit.isRoundRobinEnabled(this.gui.getDir()));
        } else if (guiButton.field_146127_k == 25) {
            this.itemConduit.setOutputPriority(this.gui.getDir(), this.itemConduit.getOutputPriority(this.gui.getDir()) + 1);
        } else if (guiButton.field_146127_k == 26) {
            this.itemConduit.setOutputPriority(this.gui.getDir(), this.itemConduit.getOutputPriority(this.gui.getDir()) - 1);
        } else if (guiButton.field_146127_k == 23) {
            DyeColor col = DyeColor.fromIndex((int)this.insertChannelB.getColorIndex());
            this.itemConduit.setOutputColor(this.gui.getDir(), col);
        } else if (guiButton.field_146127_k == 27) {
            DyeColor col = DyeColor.fromIndex((int)this.extractChannelB.getColorIndex());
            this.itemConduit.setInputColor(this.gui.getDir(), col);
        }
        if (this.insertFilterGui != null) {
            this.insertFilterGui.actionPerformed(guiButton);
        }
        if (this.extractFilterGui != null) {
            this.extractFilterGui.actionPerformed(guiButton);
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemConduitFilter(this.itemConduit, this.gui.getDir()));
    }

    @Override
    protected void connectionModeChanged(@Nonnull ConnectionMode mode) {
        super.connectionModeChanged(mode);
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExtractMode(this.itemConduit, this.gui.getDir()));
        this.updateGuiVisibility();
    }

    @Override
    protected void renderCustomOptions(int top1, float par1, int par2, int par3) {
        FontRenderer fr = this.gui.getFontRenderer();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        IconEIO.map.render((IWidgetIcon)EnderWidget.BUTTON_DOWN, (double)(this.left + this.priLeft), (double)(top1 - 5), (double)this.priWidth, 16.0, 0.0, true);
        String str = this.itemConduit.getOutputPriority(this.gui.getDir()) + "";
        int sw = fr.func_78256_a(str);
        String priority = EnderIO.lang.localize("gui.conduit.item.priority");
        fr.func_78276_b(priority, this.left + 12, top1 + 25, ColorUtil.getRGB((Color)Color.black));
        fr.func_78276_b(str, this.left + this.priLeft + this.priWidth - sw - this.gap, top1 + 25, ColorUtil.getRGB((Color)Color.black));
        if (this.insertFilterGui != null) {
            this.insertFilterGui.renderCustomOptions(top1, par1, par2, par3);
        }
        if (this.extractFilterGui != null) {
            this.extractFilterGui.renderCustomOptions(top1, par1, par2, par3);
        }
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
        super.mouseClicked(x, y, par3);
        if (this.insertFilterGui != null) {
            this.insertFilterGui.mouseClicked(x, y, par3);
        }
        if (this.extractFilterGui != null) {
            this.extractFilterGui.mouseClicked(x, y, par3);
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        this.gui.getContainer().setInoutSlotsVisible(false, false);
        this.rsB.detach();
        this.colorB.detach();
        this.roundRobinB.detach();
        this.loopB.detach();
        this.priUpB.detach();
        this.priDownB.detach();
        this.insertChannelB.detach();
        this.extractChannelB.detach();
        this.gui.getContainer().setInventorySlotsVisible(false);
        if (this.insertFilterGui != null) {
            this.insertFilterGui.deactivate();
        }
        if (this.extractFilterGui != null) {
            this.extractFilterGui.deactivate();
        }
    }

    @Override
    protected boolean hasFilters() {
        return true;
    }

    @Override
    protected boolean hasUpgrades() {
        return true;
    }
}

