/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.api.teleport;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.teleport.TravelController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;

public enum TravelSource {
    BLOCK{

        @Override
        public int getMaxDistanceTravelled() {
            return Config.travelAnchorMaxDistance;
        }
    }
    ,
    STAFF{

        @Override
        public int getMaxDistanceTravelled() {
            return Config.travelStaffMaxDistance;
        }

        @Override
        public float getPowerCostPerBlockTraveledRF() {
            return Config.travelStaffPowerPerBlockRF;
        }
    }
    ,
    STAFF_BLINK{

        @Override
        public int getMaxDistanceTravelled() {
            return Config.travelStaffMaxBlinkDistance;
        }

        @Override
        public float getPowerCostPerBlockTraveledRF() {
            return Config.travelStaffPowerPerBlockRF;
        }
    }
    ,
    TELEPAD(EnderIO.DOMAIN + ":telepad.teleport");

    public final String sound;

    public static int getMaxDistance() {
        return STAFF.getMaxDistanceTravelledSq();
    }

    @SideOnly(value=Side.CLIENT)
    public static int getMaxDistanceSq() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return 0;
        }
        return TravelController.instance.isTravelItemActive((EntityPlayer)player) ? STAFF.getMaxDistanceTravelledSq() : BLOCK.getMaxDistanceTravelledSq();
    }

    private TravelSource() {
        this("mob.endermen.portal");
    }

    private TravelSource(String sound) {
        this.sound = sound;
    }

    public boolean getConserveMomentum() {
        return this == STAFF_BLINK;
    }

    public int getMaxDistanceTravelled() {
        return 0;
    }

    public int getMaxDistanceTravelledSq() {
        return this.getMaxDistanceTravelled() * this.getMaxDistanceTravelled();
    }

    public float getPowerCostPerBlockTraveledRF() {
        return 0.0f;
    }
}

