/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.common.util.BlockCoord;
import com.enderio.core.common.util.Util;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.conduit.ConduitDisplayMode;
import crazypants.enderio.conduit.ConduitNetworkTickHandler;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.IConduitItem;
import crazypants.enderio.conduit.MicroblocksUtil;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.TileConduitBundle;
import crazypants.enderio.conduit.facade.ItemConduitFacade;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitConnectorType;
import crazypants.enderio.conduit.gui.ExternalConnectionContainer;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.GuiExternalConnectionSelector;
import crazypants.enderio.conduit.gui.PacketFluidChannel;
import crazypants.enderio.conduit.gui.PacketFluidFilter;
import crazypants.enderio.conduit.gui.PacketOpenConduitUI;
import crazypants.enderio.conduit.gui.PacketSlotVisibility;
import crazypants.enderio.conduit.gui.item.PacketExistingItemFilterSnapshot;
import crazypants.enderio.conduit.gui.item.PacketModItemFilter;
import crazypants.enderio.conduit.liquid.PacketFluidLevel;
import crazypants.enderio.conduit.packet.PacketConnectionMode;
import crazypants.enderio.conduit.packet.PacketExtractMode;
import crazypants.enderio.conduit.packet.PacketItemConduitFilter;
import crazypants.enderio.conduit.packet.PacketOCConduitSignalColor;
import crazypants.enderio.conduit.packet.PacketRedstoneConduitOutputStrength;
import crazypants.enderio.conduit.packet.PacketRedstoneConduitSignalColor;
import crazypants.enderio.conduit.packet.PacketRoundRobinMode;
import crazypants.enderio.conduit.redstone.IInsulatedRedstoneConduit;
import crazypants.enderio.conduit.redstone.IRedstoneConduit;
import crazypants.enderio.item.IRotatableFacade;
import crazypants.enderio.item.ItemConduitProbe;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.tool.ToolUtil;
import crazypants.util.IFacade;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import mods.immibis.core.api.multipart.IMultipartRenderingBlockMarker;
import mods.immibis.core.api.multipart.IMultipartSystem;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import powercrystals.minefactoryreloaded.api.rednet.IRedNetOmniNode;
import powercrystals.minefactoryreloaded.api.rednet.connectivity.RedNetConnectionType;

@Optional.InterfaceList(value={@Optional.Interface(iface="powercrystals.minefactoryreloaded.api.rednet.IRedNetOmniNode", modid="MineFactoryReloaded"), @Optional.Interface(iface="mods.immibis.core.api.multipart.IMultipartRenderingBlockMarker", modid="ImmibisMicroblocks")})
public class BlockConduitBundle
extends BlockEio
implements IGuiHandler,
IFacade,
IRotatableFacade,
IRedNetOmniNode,
IMultipartRenderingBlockMarker {
    private static final String KEY_CONNECTOR_ICON = "enderIO:conduitConnector";
    private static final String KEY_CONNECTOR_ICON_EXTERNAL = "enderIO:conduitConnectorExternal";
    public static int rendererId = -1;
    private IIcon connectorIcon;
    private IIcon connectorIconExternal;
    private IIcon lastRemovedComponetIcon = null;
    private final Random rand = new Random();

    public static BlockConduitBundle create() {
        MinecraftForge.EVENT_BUS.register((Object)ConduitNetworkTickHandler.instance);
        FMLCommonHandler.instance().bus().register((Object)ConduitNetworkTickHandler.instance);
        PacketHandler.INSTANCE.registerMessage(PacketFluidLevel.class, PacketFluidLevel.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketExtractMode.class, PacketExtractMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketConnectionMode.class, PacketConnectionMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketItemConduitFilter.class, PacketItemConduitFilter.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketExistingItemFilterSnapshot.class, PacketExistingItemFilterSnapshot.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketModItemFilter.class, PacketModItemFilter.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketFluidFilter.class, PacketFluidFilter.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketFluidChannel.class, PacketFluidChannel.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketRedstoneConduitSignalColor.class, PacketRedstoneConduitSignalColor.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketRedstoneConduitOutputStrength.class, PacketRedstoneConduitOutputStrength.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketOpenConduitUI.class, PacketOpenConduitUI.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketSlotVisibility.class, PacketSlotVisibility.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketOCConduitSignalColor.class, PacketOCConduitSignalColor.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketRoundRobinMode.class, PacketRoundRobinMode.class, PacketHandler.nextID(), Side.SERVER);
        BlockConduitBundle result = new BlockConduitBundle();
        result.init();
        MinecraftForge.EVENT_BUS.register((Object)result);
        return result;
    }

    protected BlockConduitBundle() {
        super(ModObject.blockConduitBundle.unlocalisedName, TileConduitBundle.class);
        this.func_149676_a(0.334f, 0.334f, 0.334f, 0.667f, 0.667f, 0.667f);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149647_a(null);
        this.field_149762_H = new Block.SoundType("silence", 0.0f, 0.0f){

            public String func_150495_a() {
                return "EnderIO:" + this.field_150501_a + ".dig";
            }

            public String func_150498_e() {
                return "EnderIO:" + this.field_150501_a + ".step";
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World world, MovingObjectPosition target, EffectRenderer effectRenderer) {
        if (MicroblocksUtil.supportMicroblocks() && this.IM__addHitEffects(world, target, effectRenderer)) {
            return true;
        }
        IIcon tex = null;
        TileConduitBundle cb = (TileConduitBundle)world.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (ConduitUtil.isSolidFacadeRendered(cb, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            if (cb.getFacadeId() != null) {
                tex = cb.getFacadeId().func_149691_a(target.field_72310_e, cb.getFacadeMetadata());
            }
        } else if (target.hitInfo instanceof CollidableComponent) {
            CollidableComponent cc = (CollidableComponent)target.hitInfo;
            IConduit con = cb.getConduit(cc.conduitType);
            if (con != null) {
                tex = con.getTextureForState(cc);
            }
        }
        if (tex == null) {
            tex = this.field_149761_L;
        }
        this.lastRemovedComponetIcon = tex;
        this.addBlockHitEffects(world, effectRenderer, target.field_72311_b, target.field_72312_c, target.field_72309_d, target.field_72310_e, tex);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        if (MicroblocksUtil.supportMicroblocks() && this.IM__addDestroyEffects(world, x, y, z, meta, effectRenderer)) {
            return true;
        }
        IIcon tex = this.lastRemovedComponetIcon;
        int b0 = 4;
        for (int j1 = 0; j1 < b0; ++j1) {
            for (int k1 = 0; k1 < b0; ++k1) {
                for (int l1 = 0; l1 < b0; ++l1) {
                    double d0 = (double)x + ((double)j1 + 0.5) / (double)b0;
                    double d1 = (double)y + ((double)k1 + 0.5) / (double)b0;
                    double d2 = (double)z + ((double)l1 + 0.5) / (double)b0;
                    int i2 = this.rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(world, d0, d1, d2, d0 - (double)x - 0.5, d1 - (double)y - 0.5, d2 - (double)z - 0.5, (Block)this, i2, 0).func_70596_a(x, y, z);
                    fx.func_110125_a(tex);
                    effectRenderer.func_78873_a((EntityFX)fx);
                }
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addBlockHitEffects(World world, EffectRenderer effectRenderer, int x, int y, int z, int side, IIcon tex) {
        float f = 0.1f;
        double d0 = (double)x + this.rand.nextDouble() * (this.func_149753_y() - this.func_149704_x() - (double)(f * 2.0f)) + (double)f + this.func_149704_x();
        double d1 = (double)y + this.rand.nextDouble() * (this.func_149669_A() - this.func_149665_z() - (double)(f * 2.0f)) + (double)f + this.func_149665_z();
        double d2 = (double)z + this.rand.nextDouble() * (this.func_149693_C() - this.func_149706_B() - (double)(f * 2.0f)) + (double)f + this.func_149706_B();
        if (side == 0) {
            d1 = (double)y + this.func_149665_z() - (double)f;
        } else if (side == 1) {
            d1 = (double)y + this.func_149669_A() + (double)f;
        } else if (side == 2) {
            d2 = (double)z + this.func_149706_B() - (double)f;
        } else if (side == 3) {
            d2 = (double)z + this.func_149693_C() + (double)f;
        } else if (side == 4) {
            d0 = (double)x + this.func_149704_x() - (double)f;
        } else if (side == 5) {
            d0 = (double)x + this.func_149753_y() + (double)f;
        }
        EntityDiggingFX digFX = new EntityDiggingFX(world, d0, d1, d2, 0.0, 0.0, 0.0, (Block)this, side, 0);
        digFX.func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f);
        digFX.func_110125_a(tex);
        effectRenderer.func_78873_a((EntityFX)digFX);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySound(PlaySoundSourceEvent event) {
        String path = event.sound.func_147650_b().func_110623_a();
        if ("silence.step".equals(path)) {
            ISound snd = event.sound;
            World world = EnderIO.proxy.getClientWorld();
            BlockCoord bc = new BlockCoord((double)snd.func_147649_g(), (double)snd.func_147654_h(), (double)snd.func_147651_i());
            TileEntity te = bc.getTileEntity((IBlockAccess)world);
            if (te != null && te instanceof TileConduitBundle && ((TileConduitBundle)te).hasFacade()) {
                Block facade = this.getFacade((IBlockAccess)world, bc.x, bc.y, bc.z, -1);
                ConduitUtil.playHitSound(facade.field_149762_H, world, bc.x, bc.y, bc.z);
            } else {
                ConduitUtil.playHitSound(Block.field_149777_j, world, bc.x, bc.y, bc.z);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        String path = event.name;
        World world = event.entity.field_70170_p;
        if ("EnderIO:silence.step".equals(path) && world.field_72995_K) {
            BlockCoord bc = new BlockCoord(event.entity.field_70165_t, event.entity.field_70163_u - 2.0, event.entity.field_70161_v);
            TileEntity te = bc.getTileEntity((IBlockAccess)world);
            if (te != null && te instanceof TileConduitBundle && ((TileConduitBundle)te).hasFacade()) {
                Block facade = this.getFacade((IBlockAccess)world, bc.x, bc.y, bc.z, -1);
                ConduitUtil.playStepSound(facade.field_149762_H, world, bc.x, bc.y, bc.z);
            } else {
                ConduitUtil.playStepSound(Block.field_149777_j, world, bc.x, bc.y, bc.z);
            }
        }
    }

    protected void init() {
        super.init();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            EnderIO.guiHandler.registerGuiHandler(9 + dir.ordinal(), this);
        }
        EnderIO.guiHandler.registerGuiHandler(16, this);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getPickBlock(target, world, x, y, z, null);
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ItemStack ret = null;
        if (MicroblocksUtil.supportMicroblocks()) {
            ret = this.getMicroblockPickBlock(target, world, x, y, z, player);
        }
        if (ret == null && target != null && target.hitInfo instanceof CollidableComponent) {
            CollidableComponent cc = (CollidableComponent)target.hitInfo;
            TileConduitBundle bundle = (TileConduitBundle)world.func_147438_o(x, y, z);
            IConduit conduit = bundle.getConduit(cc.conduitType);
            if (conduit != null) {
                ret = conduit.createItem();
            } else if (cc.conduitType == null && bundle.getFacadeId() != null) {
                ret = new ItemStack((Item)EnderIO.itemConduitFacade, 1, 0);
                PainterUtil.setSourceBlock(ret, bundle.getFacadeId(), bundle.getFacadeMetadata());
            }
        }
        return ret;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return 0;
        }
        IConduitBundle bun = (IConduitBundle)te;
        return bun.getFacadeId() != null ? bun.getFacadeMetadata() : 0;
    }

    public int func_149745_a(Random r) {
        return 0;
    }

    public IIcon getConnectorIcon(Object data) {
        return data == ConduitConnectorType.EXTERNAL ? this.connectorIconExternal : this.connectorIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister IIconRegister2) {
        this.connectorIcon = IIconRegister2.func_94245_a(KEY_CONNECTOR_ICON);
        this.connectorIconExternal = IIconRegister2.func_94245_a(KEY_CONNECTOR_ICON_EXTERNAL);
        this.field_149761_L = this.connectorIcon;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        if (MicroblocksUtil.supportMicroblocks() && this.IM__isSideSolid(world, x, y, z, side)) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return false;
        }
        IConduitBundle con = (IConduitBundle)te;
        return con.hasFacade();
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return rendererId;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int getLightOpacity(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return super.getLightOpacity(world, x, y, z);
        }
        IConduitBundle con = (IConduitBundle)te;
        return con.getLightOpacity();
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return super.getLightValue(world, x, y, z);
        }
        IConduitBundle con = (IConduitBundle)te;
        if (con.getFacadeId() != null && con.getFacadeId().func_149662_c()) {
            return 0;
        }
        Collection<IConduit> conduits = con.getConduits();
        int result = 0;
        for (IConduit conduit : conduits) {
            result += conduit.getLightValue();
        }
        return result;
    }

    public float func_149712_f(World world, int x, int y, int z) {
        IConduitBundle te = (IConduitBundle)world.func_147438_o(x, y, z);
        return te != null && te.getFacadeType() == ItemConduitFacade.FacadeType.HARDENED ? this.field_149782_v * 10.0f : this.field_149782_v;
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        float resist = this.func_149638_a(par1Entity);
        IConduitBundle te = (IConduitBundle)world.func_147438_o(x, y, z);
        return te != null && te.getFacadeType() == ItemConduitFacade.FacadeType.HARDENED ? resist * 10.0f : resist;
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.block == this) {
            IConduitBundle te;
            ItemStack held = event.entityPlayer.func_71045_bC();
            if (held == null || held.func_77973_b().getHarvestLevel(held, "pickaxe") == -1) {
                event.newSpeed += 2.0f;
            }
            if ((te = (IConduitBundle)event.entity.field_70170_p.func_147438_o(event.x, event.y, event.z)) != null && te.getFacadeType() == ItemConduitFacade.FacadeType.HARDENED) {
                event.newSpeed = !ConduitUtil.isSolidFacadeRendered(te, event.entityPlayer) ? (event.newSpeed *= 6.0f) : (event.newSpeed *= 2.0f);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInPass(int pass) {
        return pass == 0 || pass == 1;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int par5) {
        IRedstoneConduit con = BlockConduitBundle.getRedstoneConduit(world, x, y, z);
        if (con == null) {
            return 0;
        }
        return con.isProvidingStrongPower(ForgeDirection.getOrientation((int)par5));
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int par5) {
        IRedstoneConduit con = BlockConduitBundle.getRedstoneConduit(world, x, y, z);
        if (con == null) {
            return 0;
        }
        return con.isProvidingWeakPower(ForgeDirection.getOrientation((int)par5));
    }

    public boolean func_149744_f() {
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        IConduitBundle te = (IConduitBundle)world.func_147438_o(x, y, z);
        if (te == null) {
            return true;
        }
        boolean breakBlock = true;
        ArrayList<ItemStack> drop = new ArrayList<ItemStack>();
        if (ConduitUtil.isSolidFacadeRendered(te, player)) {
            breakBlock = false;
            ItemStack fac = new ItemStack((Item)EnderIO.itemConduitFacade, 1, te.getFacadeType().ordinal());
            PainterUtil.setSourceBlock(fac, te.getFacadeId(), te.getFacadeMetadata());
            drop.add(fac);
            ConduitUtil.playBreakSound(te.getFacadeId().field_149762_H, world, x, y, z);
            te.setFacadeId(null);
            te.setFacadeMetadata(0);
            te.setFacadeType(ItemConduitFacade.FacadeType.BASIC);
        }
        if (breakBlock) {
            List<RaytraceResult> results = this.doRayTraceAll(world, x, y, z, player);
            RaytraceResult.sort(Util.getEyePosition((EntityPlayer)player), results);
            for (RaytraceResult rt : results) {
                if (this.breakConduit(te, drop, rt, player)) break;
            }
        }
        boolean bl = breakBlock = te.getConduits().isEmpty() && !te.hasFacade();
        if (!breakBlock) {
            world.func_147471_g(x, y, z);
        }
        if (MicroblocksUtil.supportMicroblocks()) {
            this.IM__getDrops(drop, world, x, y, z, te.getEntity().func_145832_p(), 0);
        }
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
            for (ItemStack st : drop) {
                Util.dropItems((World)world, (ItemStack)st, (int)x, (int)y, (int)z, (boolean)false);
            }
        }
        if (breakBlock) {
            world.func_147468_f(x, y, z);
            return true;
        }
        return false;
    }

    private boolean breakConduit(IConduitBundle te, List<ItemStack> drop, RaytraceResult rt, EntityPlayer player) {
        if (rt == null || rt.component == null) {
            return false;
        }
        Class<? extends IConduit> type = rt.component.conduitType;
        if (!ConduitUtil.renderConduit(player, type)) {
            return false;
        }
        if (type == null) {
            ArrayList<IConduit> cons = new ArrayList<IConduit>(te.getConduits());
            boolean droppedUnconected = false;
            for (IConduit con : cons) {
                if (!con.getConduitConnections().isEmpty() || !con.getExternalConnections().isEmpty() || !ConduitUtil.renderConduit(player, con)) continue;
                te.removeConduit(con);
                drop.addAll(con.getDrops());
                droppedUnconected = true;
            }
            if (!droppedUnconected) {
                for (IConduit con : cons) {
                    if (!ConduitUtil.renderConduit(player, con)) continue;
                    te.removeConduit(con);
                    drop.addAll(con.getDrops());
                }
            }
        } else {
            IConduit con = te.getConduit(type);
            if (con != null) {
                te.removeConduit(con);
                drop.addAll(con.getDrops());
            }
        }
        BlockCoord bc = te.getLocation();
        ConduitUtil.playBreakSound(Block.field_149777_j, te.getWorld(), bc.x, bc.y, bc.z);
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof IConduitBundle)) {
            return;
        }
        IConduitBundle te = (IConduitBundle)tile;
        te.onBlockRemoved();
        world.func_147475_p(x, y, z);
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        ItemStack equipped = player.func_71045_bC();
        if (!player.func_70093_af() || equipped == null || equipped.func_77973_b() != EnderIO.itemYetaWench) {
            return;
        }
        ConduitUtil.openConduitGui(world, x, y, z, player);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float par7, float par8, float par9) {
        IConduitBundle bundle = (IConduitBundle)world.func_147438_o(x, y, z);
        if (bundle == null) {
            return false;
        }
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b() == EnderIO.itemConduitFacade) {
            return this.handleFacadeClick(world, x, y, z, player, side, bundle, stack);
        }
        if (ConduitUtil.isConduitEquipped(player)) {
            if (player.func_70093_af()) {
                return false;
            }
            if (this.handleConduitClick(world, x, y, z, player, bundle, stack)) {
                return true;
            }
        } else if (ConduitUtil.isProbeEquipped(player) ? this.handleConduitProbeClick(world, x, y, z, player, bundle, stack) : ToolUtil.isToolEquipped(player) && player.func_70093_af() && this.handleWrenchClick(world, x, y, z, player)) {
            return true;
        }
        RaytraceResult closest = this.doRayTrace(world, x, y, z, player);
        List<RaytraceResult> all = null;
        if (closest != null) {
            all = this.doRayTraceAll(world, x, y, z, player);
        }
        if (closest != null && closest.component != null && closest.component.data instanceof ConduitConnectorType) {
            Object conType = (ConduitConnectorType)((Object)closest.component.data);
            if (conType == ConduitConnectorType.INTERNAL) {
                boolean result = false;
                for (IConduit con : bundle.getConduits()) {
                    if (!ConduitUtil.renderConduit(player, con.getCollidableType()) || !con.onBlockActivated(player, this.getHitForConduitType(all, con.getCollidableType()), all)) continue;
                    bundle.getEntity().func_70296_d();
                    result = true;
                }
                if (result) {
                    return true;
                }
            } else {
                if (!world.field_72995_K) {
                    player.openGui((Object)EnderIO.instance, 9 + closest.component.dir.ordinal(), world, x, y, z);
                }
                return true;
            }
        }
        if (closest == null || closest.component == null || closest.component.conduitType == null && all == null) {
            return false;
        }
        if (all != null) {
            RaytraceResult.sort(Util.getEyePosition((EntityPlayer)player), all);
            for (RaytraceResult rr : all) {
                IConduit con;
                if (!ConduitUtil.renderConduit(player, rr.component.conduitType) || rr.component.data instanceof ConduitConnectorType || (con = bundle.getConduit(rr.component.conduitType)) == null || !con.onBlockActivated(player, rr, all)) continue;
                bundle.getEntity().func_70296_d();
                return true;
            }
        } else {
            IConduit closestConduit = bundle.getConduit(closest.component.conduitType);
            if (closestConduit != null && ConduitUtil.renderConduit(player, closestConduit) && closestConduit.onBlockActivated(player, closest, all)) {
                bundle.getEntity().func_70296_d();
                return true;
            }
        }
        return false;
    }

    private boolean handleWrenchClick(World world, int x, int y, int z, EntityPlayer player) {
        ITool tool = ToolUtil.getEquippedTool(player);
        if (tool != null && tool.canUse(player.func_71045_bC(), player, x, y, z)) {
            if (!world.field_72995_K) {
                this.removedByPlayer(world, player, x, y, z, true);
                tool.used(player.func_71045_bC(), player, x, y, z);
            }
            return true;
        }
        return false;
    }

    private boolean handleConduitProbeClick(World world, int x, int y, int z, EntityPlayer player, IConduitBundle bundle, ItemStack stack) {
        if (stack.func_77960_j() != 1) {
            return false;
        }
        RaytraceResult rr = this.doRayTrace(world, x, y, z, player);
        if (rr == null || rr.component == null) {
            return false;
        }
        return ItemConduitProbe.copyPasteSettings(player, stack, bundle, rr.component.dir);
    }

    private boolean handleConduitClick(World world, int x, int y, int z, EntityPlayer player, IConduitBundle bundle, ItemStack stack) {
        IConduitItem equipped = (IConduitItem)stack.func_77973_b();
        if (!bundle.hasType(equipped.getBaseConduitType())) {
            if (!world.field_72995_K) {
                bundle.addConduit(equipped.createConduit(stack, player));
                ConduitUtil.playBreakSound(field_149777_j, world, x, y, z);
                if (!player.field_71075_bZ.field_75098_d) {
                    --player.func_71045_bC().field_77994_a;
                }
            }
            return true;
        }
        return false;
    }

    public boolean handleFacadeClick(World world, int x, int y, int z, EntityPlayer player, int side, IConduitBundle bundle, ItemStack stack) {
        if (MicroblocksUtil.supportMicroblocks() && this.hasMicroblocks(bundle)) {
            return false;
        }
        if (player.func_70093_af()) {
            return false;
        }
        Block facadeID = PainterUtil.getSourceBlock(player.func_71045_bC());
        if (facadeID == null) {
            return false;
        }
        int facadeMeta = PainterUtil.getSourceBlockMetadata(player.func_71045_bC());
        facadeMeta = PainterUtil.adjustFacadeMetadata(facadeID, facadeMeta, side);
        int facadeType = player.func_71045_bC().func_77960_j();
        if (bundle.hasFacade()) {
            if (!ConduitUtil.isSolidFacadeRendered(bundle, player) || this.facadeEquals(bundle, facadeID, facadeMeta, facadeType)) {
                return false;
            }
            if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                ItemStack fac = new ItemStack((Item)EnderIO.itemConduitFacade, 1, bundle.getFacadeType().ordinal());
                PainterUtil.setSourceBlock(fac, bundle.getFacadeId(), bundle.getFacadeMetadata());
                Util.dropItems((World)world, (ItemStack)fac, (int)x, (int)y, (int)z, (boolean)false);
            }
        }
        bundle.setFacadeId(facadeID);
        bundle.setFacadeMetadata(facadeMeta);
        bundle.setFacadeType(ItemConduitFacade.FacadeType.values()[facadeType]);
        if (!world.field_72995_K) {
            ConduitUtil.playPlaceSound(facadeID.field_149762_H, world, x, y, z);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            --stack.field_77994_a;
        }
        world.func_147471_g(x, y, z);
        bundle.getEntity().func_70296_d();
        return true;
    }

    private boolean facadeEquals(IConduitBundle bundle, Block facadeID, int facadeMeta, int facadeType) {
        return bundle.getFacadeId().equals(facadeID) && bundle.getFacadeMetadata() == facadeMeta && bundle.getFacadeType().ordinal() == facadeType;
    }

    @Override
    public boolean tryRotateFacade(World world, int x, int y, int z, ForgeDirection axis) {
        IConduitBundle bundle = (IConduitBundle)world.func_147438_o(x, y, z);
        if (bundle == null) {
            return false;
        }
        int oldMeta = bundle.getFacadeMetadata();
        int newMeta = PainterUtil.rotateFacadeMetadata(bundle.getFacadeId(), oldMeta, axis);
        if (newMeta == oldMeta) {
            return false;
        }
        bundle.setFacadeMetadata(newMeta);
        world.func_147471_g(x, y, z);
        bundle.getEntity().func_70296_d();
        return true;
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        if (id == 16) {
            return null;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IConduitBundle) {
            return new ExternalConnectionContainer(player.field_71071_by, (IConduitBundle)te, ForgeDirection.values()[id - 9]);
        }
        return null;
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IConduitBundle) {
            if (id == 16) {
                return new GuiExternalConnectionSelector((IConduitBundle)te);
            }
            return new GuiExternalConnection(player.field_71071_by, (IConduitBundle)te, ForgeDirection.values()[id - 9]);
        }
        return null;
    }

    private RaytraceResult getHitForConduitType(List<RaytraceResult> all, Class<? extends IConduit> collidableType) {
        for (RaytraceResult rr : all) {
            if (rr.component == null || rr.component.conduitType != collidableType) continue;
            return rr;
        }
        return null;
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockId) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof IConduitBundle) {
            ((IConduitBundle)tile).onNeighborBlockChange(blockId);
        }
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        TileEntity conduit = world.func_147438_o(x, y, z);
        if (conduit instanceof IConduitBundle) {
            ((IConduitBundle)conduit).onNeighborChange(world, x, y, z, tileX, tileY, tileZ);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        TileEntity te;
        if (MicroblocksUtil.supportMicroblocks()) {
            this.IM__addCollisionBoxesToList(world, x, y, z, axisalignedbb, arraylist, par7Entity);
        }
        if (!((te = world.func_147438_o(x, y, z)) instanceof IConduitBundle)) {
            return;
        }
        IConduitBundle con = (IConduitBundle)te;
        if (con.getFacadeId() != null) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.func_149743_a(world, x, y, z, axisalignedbb, arraylist, par7Entity);
        } else {
            List<CollidableComponent> bounds = con.getCollidableComponents();
            for (CollidableComponent bnd : bounds) {
                this.func_149676_a(bnd.bound.minX, bnd.bound.minY, bnd.bound.minZ, bnd.bound.maxX, bnd.bound.maxY, bnd.bound.maxZ);
                super.func_149743_a(world, x, y, z, axisalignedbb, arraylist, par7Entity);
            }
            if (con.getConduits().isEmpty()) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.func_149743_a(world, x, y, z, axisalignedbb, arraylist, par7Entity);
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle con = (IConduitBundle)te;
        BoundingBox minBB = new BoundingBox(1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);
        if (!ConduitUtil.isSolidFacadeRendered(con, EnderIO.proxy.getClientPlayer())) {
            RaytraceResult hit;
            List<RaytraceResult> results = this.doRayTraceAll(world, x, y, z, (EntityPlayer)player);
            Iterator<RaytraceResult> iter = results.iterator();
            while (iter.hasNext()) {
                CollidableComponent component = iter.next().component;
                if (component != null && (component.conduitType != null || component.data == ConduitConnectorType.EXTERNAL)) continue;
                iter.remove();
            }
            for (RaytraceResult hit2 : results) {
                IInsulatedRedstoneConduit cond = con.getConduit(IInsulatedRedstoneConduit.class);
                if (cond == null || hit2.component == null || !cond.getExternalConnections().contains(hit2.component.dir) || cond.isSpecialConnection(hit2.component.dir) || hit2.component.data != "ColorController") continue;
                minBB = hit2.component.bound;
            }
            if (!minBB.isValid() && (hit = RaytraceResult.getClosestHit(Util.getEyePosition((EntityPlayer)player), results)) != null && hit.component != null && hit.component.bound != null) {
                minBB = hit.component.bound;
                if (hit.component.conduitType == null) {
                    ForgeDirection dir = hit.component.dir.getOpposite();
                    float trans = 0.0125f;
                    minBB = minBB.translate((float)dir.offsetX * trans, (float)dir.offsetY * trans, (float)dir.offsetZ * trans);
                    float scale = 0.7f;
                    minBB = minBB.scale(1.0f + (float)Math.abs(dir.offsetX) * scale, 1.0f + (float)Math.abs(dir.offsetY) * scale, 1.0f + (float)Math.abs(dir.offsetZ) * scale);
                } else {
                    minBB = minBB.scale(1.09, 1.09, 1.09);
                }
            }
        } else {
            minBB = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!minBB.isValid()) {
            minBB = new BoundingBox(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        return AxisAlignedBB.func_72330_a((double)((float)x + minBB.minX), (double)((float)y + minBB.minY), (double)((float)z + minBB.minZ), (double)((float)x + minBB.maxX), (double)((float)y + minBB.maxY), (double)((float)z + minBB.maxZ));
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 origin, Vec3 direction) {
        RaytraceResult raytraceResult = this.doRayTrace(world, x, y, z, origin, direction, null);
        MovingObjectPosition ret = null;
        if (raytraceResult != null && (ret = raytraceResult.movingObjectPosition) != null) {
            ret.hitInfo = raytraceResult.component;
        }
        if (MicroblocksUtil.supportMicroblocks()) {
            return this.IM__collisionRayTrace(ret, world, x, y, z, origin, direction);
        }
        return ret;
    }

    public RaytraceResult doRayTrace(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        List<RaytraceResult> allHits = this.doRayTraceAll(world, x, y, z, entityPlayer);
        if (allHits == null) {
            return null;
        }
        Vec3 origin = Util.getEyePosition((EntityPlayer)entityPlayer);
        return RaytraceResult.getClosestHit(origin, allHits);
    }

    public List<RaytraceResult> doRayTraceAll(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        double pitch = Math.toRadians(entityPlayer.field_70125_A);
        double yaw = Math.toRadians(entityPlayer.field_70177_z);
        double dirX = -Math.sin(yaw) * Math.cos(pitch);
        double dirY = -Math.sin(pitch);
        double dirZ = Math.cos(yaw) * Math.cos(pitch);
        double reachDistance = EnderIO.proxy.getReachDistanceForPlayer(entityPlayer);
        Vec3 origin = Util.getEyePosition((EntityPlayer)entityPlayer);
        Vec3 direction = origin.func_72441_c(dirX * reachDistance, dirY * reachDistance, dirZ * reachDistance);
        return this.doRayTraceAll(world, x, y, z, origin, direction, entityPlayer);
    }

    private RaytraceResult doRayTrace(World world, int x, int y, int z, Vec3 origin, Vec3 direction, EntityPlayer entityPlayer) {
        List<RaytraceResult> allHits = this.doRayTraceAll(world, x, y, z, origin, direction, entityPlayer);
        if (allHits == null) {
            return null;
        }
        return RaytraceResult.getClosestHit(origin, allHits);
    }

    protected List<RaytraceResult> doRayTraceAll(World world, int x, int y, int z, Vec3 origin, Vec3 direction, EntityPlayer player) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        ArrayList<RaytraceResult> hits = new ArrayList<RaytraceResult>();
        if (player == null) {
            player = EnderIO.proxy.getClientPlayer();
        }
        if (ConduitUtil.isSolidFacadeRendered(bundle, player)) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            MovingObjectPosition hitPos = super.func_149731_a(world, x, y, z, origin, direction);
            if (hitPos != null) {
                hits.add(new RaytraceResult(new CollidableComponent(null, BoundingBox.UNIT_CUBE, ForgeDirection.UNKNOWN, null), hitPos));
            }
        } else {
            ConduitDisplayMode mode = ConduitUtil.getDisplayMode(player);
            ArrayList<CollidableComponent> components = new ArrayList<CollidableComponent>(bundle.getCollidableComponents());
            for (CollidableComponent component : components) {
                if (component.conduitType == null && mode != ConduitDisplayMode.ALL || !ConduitUtil.renderConduit(player, component.conduitType)) continue;
                this.func_149676_a(component.bound.minX, component.bound.minY, component.bound.minZ, component.bound.maxX, component.bound.maxY, component.bound.maxZ);
                MovingObjectPosition hitPos = super.func_149731_a(world, x, y, z, origin, direction);
                if (hitPos == null) continue;
                hits.add(new RaytraceResult(component, hitPos));
            }
            if (bundle.getConduits().isEmpty() && !ConduitUtil.isFacadeHidden(bundle, player)) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                MovingObjectPosition hitPos = super.func_149731_a(world, x, y, z, origin, direction);
                if (hitPos != null) {
                    hits.add(new RaytraceResult(null, hitPos));
                }
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        return hits;
    }

    public int getFacadeMetadata(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return 0;
        }
        IConduitBundle cb = (IConduitBundle)te;
        return cb.getFacadeMetadata();
    }

    public Block getFacade(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return this;
        }
        IConduitBundle cb = (IConduitBundle)te;
        Block res = cb.getFacadeId();
        if (res == null) {
            return this;
        }
        return res;
    }

    public Block getVisualBlock(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.getFacade(world, x, y, z, side.ordinal());
    }

    public int getVisualMeta(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.getFacadeMetadata(world, x, y, z, side.ordinal());
    }

    public boolean supportsVisualConnections() {
        return true;
    }

    public void onInputsChanged(World world, int x, int y, int z, ForgeDirection side, int[] inputValues) {
        IRedstoneConduit conduit = BlockConduitBundle.getRedstoneConduit((IBlockAccess)world, x, y, z);
        if (conduit == null) {
            return;
        }
        conduit.onInputsChanged(world, x, y, z, side, inputValues);
    }

    public void onInputChanged(World world, int x, int y, int z, ForgeDirection side, int inputValue) {
    }

    public int[] getOutputValues(World world, int x, int y, int z, ForgeDirection side) {
        IRedstoneConduit conduit = BlockConduitBundle.getRedstoneConduit((IBlockAccess)world, x, y, z);
        if (conduit == null) {
            return null;
        }
        return conduit.getOutputValues(world, x, y, z, side);
    }

    public int getOutputValue(World world, int x, int y, int z, ForgeDirection side, int subnet) {
        IRedstoneConduit conduit = BlockConduitBundle.getRedstoneConduit((IBlockAccess)world, x, y, z);
        if (conduit == null) {
            return 0;
        }
        return conduit.getOutputValue(world, x, y, z, side, subnet);
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public RedNetConnectionType getConnectionType(World world, int x, int y, int z, ForgeDirection side) {
        IRedstoneConduit conduit = BlockConduitBundle.getRedstoneConduit((IBlockAccess)world, x, y, z);
        if (conduit == null) {
            return RedNetConnectionType.None;
        }
        return conduit.canConnectToExternal(side, false) ? RedNetConnectionType.CableAll : RedNetConnectionType.None;
    }

    private static IRedstoneConduit getRedstoneConduit(IBlockAccess world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IConduitBundle)) {
            return null;
        }
        IConduitBundle bundle = (IConduitBundle)te;
        return bundle.getConduit(IRedstoneConduit.class);
    }

    public ItemStack getMicroblockPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        return IMultipartSystem.instance.hook_getPickBlock(target, world, x, y, z, player);
    }

    private boolean IM__isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return IMultipartSystem.instance.hook_isSideSolid(world, x, y, z, side);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean IM__addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        return IMultipartSystem.instance.hook_addDestroyEffects(world, x, y, z, meta, effectRenderer);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean IM__addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        return IMultipartSystem.instance.hook_addHitEffects(worldObj, target, effectRenderer);
    }

    private MovingObjectPosition IM__collisionRayTrace(MovingObjectPosition cur, World world, int x, int y, int z, Vec3 src, Vec3 dst) {
        return IMultipartSystem.instance.hook_collisionRayTrace(cur, world, x, y, z, src, dst);
    }

    private void IM__addCollisionBoxesToList(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity entity) {
        IMultipartSystem.instance.hook_addCollisionBoxesToList(world, x, y, z, mask, list, entity);
    }

    private ArrayList<ItemStack> IM__getDrops(List<ItemStack> cur, World world, int x, int y, int z, int metadata, int fortune) {
        return IMultipartSystem.instance.hook_getDrops(cur, world, x, y, z, metadata, fortune);
    }

    private boolean hasMicroblocks(IConduitBundle bundle) {
        return !bundle.getCoverSystem().getAllParts().isEmpty();
    }
}

