/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import com.enderio.core.common.network.MessageTileEntity;
import com.enderio.core.common.network.NetworkUtil;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelType;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class PacketSendRecieveChannelList
extends MessageTileEntity<TileTransceiver>
implements IMessageHandler<PacketSendRecieveChannelList, IMessage> {
    private boolean isSend;
    private SetMultimap<ChannelType, Channel> channels;

    public PacketSendRecieveChannelList() {
    }

    public PacketSendRecieveChannelList(TileTransceiver te, boolean isSend) {
        super((TileEntity)te);
        this.isSend = isSend;
        this.channels = isSend ? te.getSendChannels() : te.getReceiveChannels();
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeBoolean(this.isSend);
        NBTTagList tagList = TileTransceiver.createTagList(this.channels);
        NBTTagCompound root = new NBTTagCompound();
        root.func_74782_a("chans", (NBTBase)tagList);
        NetworkUtil.writeNBTTagCompound((NBTTagCompound)root, (ByteBuf)buf);
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.isSend = buf.readBoolean();
        NBTTagCompound root = NetworkUtil.readNBTTagCompound((ByteBuf)buf);
        this.channels = MultimapBuilder.enumKeys(ChannelType.class).hashSetValues().build();
        TileTransceiver.readChannels(root, this.channels, "chans");
    }

    public IMessage onMessage(PacketSendRecieveChannelList message, MessageContext ctx) {
        EntityPlayer player = EnderIO.proxy.getClientPlayer();
        TileTransceiver tile = (TileTransceiver)message.getTileEntity(player.field_70170_p);
        if (tile != null) {
            if (message.isSend) {
                tile.setSendChannels((Multimap<? extends ChannelType, ? extends Channel>)message.channels);
            } else {
                tile.setRecieveChannels((Multimap<? extends ChannelType, ? extends Channel>)message.channels);
            }
        }
        return null;
    }
}

