/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.gui;

import com.enderio.core.client.gui.widget.GuiToolTip;
import crazypants.enderio.machine.AbstractPoweredMachineEntity;
import crazypants.enderio.machine.gui.GuiMachineBase;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.inventory.Container;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public abstract class GuiPoweredMachineBase<T extends AbstractPoweredMachineEntity>
extends GuiMachineBase<T> {
    protected static final int POWER_Y = 14;
    protected final int POWER_X = 15;
    protected static final int POWER_WIDTH = 10;
    protected static final int POWER_HEIGHT = 42;
    protected static final int BOTTOM_POWER_Y = 56;

    public GuiPoweredMachineBase(T machine, Container container, String ... guiTexture) {
        super(machine, container, guiTexture);
        if (this.renderPowerBar()) {
            this.addToolTip(new GuiToolTip(new Rectangle(this.getPowerX(), this.getPowerY(), this.getPowerWidth(), this.getPowerHeight()), new String[]{""}){

                protected void updateText() {
                    this.text.clear();
                    if (GuiPoweredMachineBase.this.renderPowerBar()) {
                        GuiPoweredMachineBase.this.updatePowerBarTooltip(this.text);
                    }
                }
            });
        }
    }

    protected String getPowerOutputLabel() {
        return StatCollector.func_74838_a((String)"enderio.gui.max");
    }

    protected int getPowerOutputValue() {
        return ((AbstractPoweredMachineEntity)this.getTileEntity()).getPowerUsePerTick();
    }

    protected void updatePowerBarTooltip(List<String> text) {
        text.add(this.getPowerOutputLabel() + " " + PowerDisplayUtil.formatPower(this.getPowerOutputValue()) + " " + PowerDisplayUtil.abrevation() + PowerDisplayUtil.perTickStr());
        text.add(PowerDisplayUtil.formatStoredPower(((AbstractPoweredMachineEntity)this.getTileEntity()).getEnergyStored(), ((AbstractPoweredMachineEntity)this.getTileEntity()).getMaxEnergyStored()));
    }

    public void renderPowerBar(int k, int l) {
        if (this.renderPowerBar()) {
            int i1 = ((AbstractPoweredMachineEntity)this.getTileEntity()).getEnergyStoredScaled(this.getPowerHeight());
            this.func_73729_b(k + this.getPowerX(), l + (this.getPowerY() + this.getPowerHeight()) - i1, this.getPowerU(), this.getPowerV(), this.getPowerWidth(), i1);
        }
    }

    protected int getPowerX() {
        return 15;
    }

    protected int getPowerY() {
        return 14;
    }

    protected int getPowerWidth() {
        return 10;
    }

    protected int getPowerHeight() {
        return 42;
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        this.renderPowerBar(k, l);
        super.func_146976_a(par1, par2, par3);
    }

    protected int getPowerV() {
        return 31;
    }

    protected int getPowerU() {
        return 176;
    }

    protected boolean renderPowerBar() {
        return true;
    }
}

