/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.soul;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.FluidUtil;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.soul.ISoulBinderRecipe;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.xp.ExperienceContainer;
import crazypants.enderio.xp.IHaveExperience;
import crazypants.enderio.xp.PacketExperianceContainer;
import crazypants.enderio.xp.XpUtil;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileSoulBinder
extends AbstractPoweredTaskEntity
implements IHaveExperience,
IFluidHandler,
ITankAccess {
    public static final int POWER_PER_TICK_ONE = Config.soulBinderLevelOnePowerPerTickRF;
    private static final BasicCapacitor CAP_ONE = new BasicCapacitor(0, POWER_PER_TICK_ONE * 2, Capacitors.BASIC_CAPACITOR.capacitor.getMaxEnergyStored(), POWER_PER_TICK_ONE);
    public static final int POWER_PER_TICK_TWO = Config.soulBinderLevelTwoPowerPerTickRF;
    private static final BasicCapacitor CAP_TWO = new BasicCapacitor(0, POWER_PER_TICK_TWO * 2, Capacitors.ACTIVATED_CAPACITOR.capacitor.getMaxEnergyStored(), POWER_PER_TICK_TWO);
    public static final int POWER_PER_TICK_THREE = Config.soulBinderLevelThreePowerPerTickRF;
    private static final BasicCapacitor CAP_THREE = new BasicCapacitor(0, POWER_PER_TICK_THREE * 2, Capacitors.ENDER_CAPACITOR.capacitor.getMaxEnergyStored(), POWER_PER_TICK_THREE);
    private final ExperienceContainer xpCont = new ExperienceContainer(XpUtil.getExperienceForLevel(Config.soulBinderMaxXpLevel));

    public TileSoulBinder() {
        super(new SlotDefinition(2, 2, 1));
    }

    @Override
    public ExperienceContainer getContainer() {
        return this.xpCont;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockSoulBinder.unlocalisedName;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    protected boolean processTasks(boolean redstoneChecksPassed) {
        if (this.xpCont.isDirty()) {
            PacketHandler.sendToAllAround((IMessage)new PacketExperianceContainer((TileEntity)this), (TileEntity)this);
            this.xpCont.setDirty(false);
        }
        return super.processTasks(redstoneChecksPassed);
    }

    @Override
    protected IMachineRecipe canStartNextTask(float chance) {
        IMachineRecipe recipe = super.canStartNextTask(chance);
        if (recipe == null) {
            return null;
        }
        int xpRequired = ((ISoulBinderRecipe)((Object)recipe)).getExperienceRequired();
        if (this.xpCont.getExperienceTotal() >= xpRequired) {
            return recipe;
        }
        return null;
    }

    public boolean needsXP() {
        return this.getXPRequired() > 0;
    }

    private int getXPRequired() {
        if (this.currentTask != null) {
            return 0;
        }
        IMachineRecipe nextRecipe = this.getNextRecipe();
        if (!(nextRecipe instanceof ISoulBinderRecipe)) {
            return 0;
        }
        return ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired() - this.getContainer().getExperienceTotal();
    }

    public int getCurrentlyRequiredLevel() {
        if (this.currentTask != null) {
            return -1;
        }
        IMachineRecipe nextRecipe = this.getNextRecipe();
        if (!(nextRecipe instanceof ISoulBinderRecipe)) {
            return -1;
        }
        return ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceLevelsRequired();
    }

    @Override
    protected boolean startNextTask(IMachineRecipe nextRecipe, float chance) {
        int xpRequired = ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired();
        if (this.xpCont.getExperienceTotal() < xpRequired) {
            return false;
        }
        if (super.startNextTask(nextRecipe, chance)) {
            this.xpCont.drain(ForgeDirection.UNKNOWN, XpUtil.experienceToLiquid(xpRequired), true);
            return true;
        }
        return false;
    }

    @Override
    protected boolean isMachineItemValidForSlot(int slot, ItemStack item) {
        int otherSlot;
        if (!this.slotDefinition.isInputSlot(slot)) {
            return false;
        }
        MachineRecipeInput newInput = new MachineRecipeInput(slot, item);
        int n = otherSlot = slot == 0 ? 1 : 0;
        if (this.inventory[otherSlot] == null) {
            List<IMachineRecipe> recipes = MachineRecipeRegistry.instance.getRecipesForInput(this.getMachineName(), newInput);
            if (recipes.isEmpty()) {
                return false;
            }
            for (IMachineRecipe rec : recipes) {
                if (rec == null || !rec.isValidInput(newInput)) continue;
                return true;
            }
        } else {
            MachineRecipeInput[] inputs = new MachineRecipeInput[]{newInput, new MachineRecipeInput(otherSlot, this.inventory[otherSlot])};
            return MachineRecipeRegistry.instance.getRecipeForInputs(this.getMachineName(), inputs) != null;
        }
        return false;
    }

    @Override
    public void onCapacitorTypeChange() {
        switch (this.getCapacitorType()) {
            case BASIC_CAPACITOR: {
                this.setCapacitor(CAP_ONE);
                break;
            }
            case ACTIVATED_CAPACITOR: {
                this.setCapacitor(CAP_TWO);
                break;
            }
            case ENDER_CAPACITOR: {
                this.setCapacitor(CAP_THREE);
                break;
            }
            case CRYSTALLINE_CAPACITOR: {
                break;
            }
            case ENDERGETIC_CAPACITOR: {
                break;
            }
            case ENDERGISED_CAPACITOR: {
                break;
            }
            case MELODIC_CAPACITOR: {
                break;
            }
            case SILVER_CAPACITOR: {
                break;
            }
            case STELLAR_CAPACITOR: {
                break;
            }
            case TOTEMIC_CAPACITOR: {
                break;
            }
        }
    }

    @Override
    protected boolean doPull(ForgeDirection dir) {
        boolean res = super.doPull(dir);
        int req = this.getXPRequired();
        if (req > 0) {
            FluidUtil.doPull((IFluidHandler)this, (ForgeDirection)dir, (int)Math.min(XpUtil.experienceToLiquid(req), Config.fluidConduitExtractRate));
        }
        return res;
    }

    @Override
    protected boolean doPush(ForgeDirection dir) {
        boolean res = super.doPush(dir);
        int maxAmount = Math.min(XpUtil.experienceToLiquid(this.getExcessXP()), Config.fluidConduitExtractRate);
        if (maxAmount > 0) {
            FluidUtil.doPush((IFluidHandler)this, (ForgeDirection)dir, (int)maxAmount);
        }
        return res;
    }

    private int getExcessXP() {
        IMachineRecipe nextRecipe;
        if (this.currentTask == null && (nextRecipe = this.getNextRecipe()) instanceof ISoulBinderRecipe) {
            return Math.max(0, this.getContainer().getExperienceTotal() - ((ISoulBinderRecipe)((Object)nextRecipe)).getExperienceRequired());
        }
        return this.getContainer().getExperienceTotal();
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.xpCont.canFill(from, fluid);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int max = XpUtil.experienceToLiquid(this.getXPRequired());
        if (resource == null || max <= 0) {
            return 0;
        }
        if (max < resource.amount) {
            FluidStack copy = resource.copy();
            copy.amount = max;
            return this.xpCont.fill(from, copy, doFill);
        }
        return this.xpCont.fill(from, resource, doFill);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        int max = XpUtil.experienceToLiquid(this.getExcessXP());
        if (resource != null && max < resource.amount) {
            FluidStack copy = resource.copy();
            copy.amount = max;
            return this.xpCont.drain(from, copy, doDrain);
        }
        return this.xpCont.drain(from, resource, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.xpCont.drain(from, Math.min(XpUtil.experienceToLiquid(this.getExcessXP()), maxDrain), doDrain);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return this.xpCont.canDrain(from, fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return this.xpCont.getTankInfo(from);
    }

    @Override
    public void readCommon(NBTTagCompound nbtRoot) {
        super.readCommon(nbtRoot);
        this.xpCont.readFromNBT(nbtRoot);
    }

    @Override
    public void writeCommon(NBTTagCompound nbtRoot) {
        super.writeCommon(nbtRoot);
        this.xpCont.writeToNBT(nbtRoot);
    }

    public FluidTank getInputTank(FluidStack forFluidType) {
        return this.xpCont;
    }

    public FluidTank[] getOutputTanks() {
        return new FluidTank[]{this.xpCont};
    }

    public void setTanksDirty() {
        this.xpCont.setDirty(true);
    }
}

