/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.power;

import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.IconUtil;
import com.enderio.core.common.util.DyeColor;
import com.enderio.core.common.vecmath.Vector3d;
import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.AbstractConduit;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitUtil;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.RaytraceResult;
import crazypants.enderio.conduit.geom.CollidableCache;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.geom.ConduitGeometryUtil;
import crazypants.enderio.conduit.power.IPowerConduit;
import crazypants.enderio.conduit.power.PowerConduitNetwork;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.PacketConduitProbe;
import crazypants.enderio.machine.RedstoneControlMode;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.ICapacitor;
import crazypants.enderio.power.IPowerInterface;
import crazypants.enderio.power.PowerHandlerUtil;
import crazypants.enderio.tool.ToolUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PowerConduit
extends AbstractConduit
implements IPowerConduit {
    static final Map<String, IIcon> ICONS = new HashMap<String, IIcon>();
    private static ICapacitor[] capacitors;
    static final String[] POSTFIX;
    public static final float WIDTH = 0.075f;
    public static final float HEIGHT = 0.075f;
    public static final Vector3d MIN;
    public static final Vector3d MAX;
    public static final BoundingBox BOUNDS;
    protected PowerConduitNetwork network;
    private int energyStoredRF;
    private int subtype;
    protected final EnumMap<ForgeDirection, RedstoneControlMode> rsModes = new EnumMap(ForgeDirection.class);
    protected final EnumMap<ForgeDirection, DyeColor> rsColors = new EnumMap(ForgeDirection.class);
    protected EnumMap<ForgeDirection, Long> recievedTicks;
    private final Map<ForgeDirection, Integer> externalRedstoneSignals = new HashMap<ForgeDirection, Integer>();
    private boolean redstoneStateDirty = true;

    static ICapacitor[] getCapacitors() {
        if (capacitors == null) {
            capacitors = new BasicCapacitor[]{new BasicCapacitor(Config.powerConduitTierOneRF, Config.powerConduitTierOneRF), new BasicCapacitor(Config.powerConduitTierTwoRF, Config.powerConduitTierTwoRF), new BasicCapacitor(Config.powerConduitTierThreeRF, Config.powerConduitTierThreeRF)};
        }
        return capacitors;
    }

    static ItemStack createItemStackForSubtype(int subtype) {
        ItemStack result = new ItemStack((Item)EnderIO.itemPowerConduit, 1, subtype);
        return result;
    }

    public static void initIcons() {
        IconUtil.addIconProvider((IconUtil.IIconProvider)new IconUtil.IIconProvider(){

            public void registerIcons(IIconRegister register) {
                for (String pf : POSTFIX) {
                    ICONS.put("enderio:powerConduit" + pf, register.func_94245_a("enderio:powerConduit" + pf));
                    ICONS.put("enderio:powerConduitInput" + pf, register.func_94245_a("enderio:powerConduitInput"));
                    ICONS.put("enderio:powerConduitOutput" + pf, register.func_94245_a("enderio:powerConduitOutput"));
                    ICONS.put("enderio:powerConduitCore" + pf, register.func_94245_a("enderio:powerConduitCore" + pf));
                }
                ICONS.put("enderio:powerConduitTransmission", register.func_94245_a("enderio:powerConduitTransmission"));
            }

            public int getTextureType() {
                return 0;
            }
        });
    }

    public PowerConduit() {
    }

    public PowerConduit(int meta) {
        this.subtype = meta;
    }

    @Override
    public boolean getConnectionsDirty() {
        return this.connectionsDirty;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, RaytraceResult res, List<RaytraceResult> all) {
        DyeColor col = DyeColor.getColorFromDye((ItemStack)player.func_71045_bC());
        if (ConduitUtil.isProbeEquipped(player)) {
            if (!player.field_70170_p.field_72995_K) {
                new PacketConduitProbe();
                PacketConduitProbe.sendInfoMessage(player, this);
            }
            return true;
        }
        if (col != null && res.component != null && this.isColorBandRendered(res.component.dir)) {
            this.setExtractionSignalColor(res.component.dir, col);
            return true;
        }
        if (ToolUtil.isToolEquipped(player) && !this.getBundle().getEntity().func_145831_w().field_72995_K && res != null && res.component != null) {
            ForgeDirection connDir = res.component.dir;
            ForgeDirection faceHit = ForgeDirection.getOrientation((int)res.movingObjectPosition.field_72310_e);
            if (connDir == ForgeDirection.UNKNOWN || connDir == faceHit) {
                if (this.getConnectionMode(faceHit) == ConnectionMode.DISABLED) {
                    this.setConnectionMode(faceHit, this.getNextConnectionMode(faceHit));
                    return true;
                }
                return ConduitUtil.joinConduits(this, faceHit);
            }
            if (this.externalConnections.contains(connDir)) {
                this.setConnectionMode(connDir, this.getNextConnectionMode(connDir));
                return true;
            }
            if (this.containsConduitConnection(connDir)) {
                ConduitUtil.disconectConduits(this, connDir);
                return true;
            }
        }
        return false;
    }

    private boolean isColorBandRendered(ForgeDirection dir) {
        return this.getConnectionMode(dir) != ConnectionMode.DISABLED && this.getExtractionRedstoneMode(dir) != RedstoneControlMode.IGNORE;
    }

    @Override
    public ICapacitor getCapacitor() {
        return PowerConduit.getCapacitors()[this.subtype];
    }

    @Override
    public void setExtractionRedstoneMode(RedstoneControlMode mode, ForgeDirection dir) {
        this.rsModes.put(dir, mode);
        this.setClientStateDirty();
    }

    @Override
    public RedstoneControlMode getExtractionRedstoneMode(ForgeDirection dir) {
        RedstoneControlMode res = this.rsModes.get(dir);
        if (res == null) {
            res = RedstoneControlMode.IGNORE;
        }
        return res;
    }

    @Override
    public void setExtractionSignalColor(ForgeDirection dir, DyeColor col) {
        this.rsColors.put(dir, col);
        this.setClientStateDirty();
    }

    @Override
    public DyeColor getExtractionSignalColor(ForgeDirection dir) {
        DyeColor res = this.rsColors.get(dir);
        if (res == null) {
            res = DyeColor.RED;
        }
        return res;
    }

    @Override
    protected void readTypeSettings(ForgeDirection dir, NBTTagCompound dataRoot) {
        this.setExtractionSignalColor(dir, DyeColor.values()[dataRoot.func_74765_d("extractionSignalColor")]);
        this.setExtractionRedstoneMode(RedstoneControlMode.values()[dataRoot.func_74765_d("extractionRedstoneMode")], dir);
    }

    @Override
    protected void writeTypeSettingsToNbt(ForgeDirection dir, NBTTagCompound dataRoot) {
        dataRoot.func_74777_a("extractionSignalColor", (short)this.getExtractionSignalColor(dir).ordinal());
        dataRoot.func_74777_a("extractionRedstoneMode", (short)this.getExtractionRedstoneMode(dir).ordinal());
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtRoot) {
        short ord;
        super.writeToNBT(nbtRoot);
        nbtRoot.func_74777_a("subtype", (short)this.subtype);
        nbtRoot.func_74768_a("energyStoredRF", this.energyStoredRF);
        for (Map.Entry<ForgeDirection, RedstoneControlMode> entry : this.rsModes.entrySet()) {
            if (entry.getValue() == null) continue;
            ord = (short)entry.getValue().ordinal();
            nbtRoot.func_74777_a("pRsMode." + entry.getKey().name(), ord);
        }
        for (Map.Entry<ForgeDirection, RedstoneControlMode> entry : this.rsColors.entrySet()) {
            if (entry.getValue() == null) continue;
            ord = (short)((DyeColor)entry.getValue()).ordinal();
            nbtRoot.func_74777_a("pRsCol." + entry.getKey().name(), ord);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtRoot, short nbtVersion) {
        super.readFromNBT(nbtRoot, nbtVersion);
        this.subtype = nbtRoot.func_74765_d("subtype");
        if (nbtRoot.func_74764_b("energyStored")) {
            nbtRoot.func_74768_a("energyStoredRF", (int)(nbtRoot.func_74760_g("energyStored") * 10.0f));
        }
        this.setEnergyStored(nbtRoot.func_74762_e("energyStoredRF"));
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            short ord;
            String key = "pRsMode." + dir.name();
            if (nbtRoot.func_74764_b(key) && (ord = nbtRoot.func_74765_d(key)) >= 0 && ord < RedstoneControlMode.values().length) {
                this.rsModes.put(dir, RedstoneControlMode.values()[ord]);
            }
            if (!nbtRoot.func_74764_b(key = "pRsCol." + dir.name()) || (ord = nbtRoot.func_74765_d(key)) < 0 || ord >= DyeColor.values().length) continue;
            this.rsColors.put(dir, DyeColor.values()[ord]);
        }
    }

    @Override
    public void onTick() {
    }

    @Override
    public int getEnergyStored() {
        return this.energyStoredRF;
    }

    @Override
    public void setEnergyStored(int energyStored) {
        this.energyStoredRF = MathHelper.func_76125_a((int)energyStored, (int)0, (int)this.getMaxEnergyStored());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRedstoneEnabled(ForgeDirection dir) {
        RedstoneControlMode mode = this.getExtractionRedstoneMode(dir);
        if (mode == RedstoneControlMode.NEVER) {
            return false;
        }
        if (mode == RedstoneControlMode.IGNORE) {
            return true;
        }
        DyeColor col = this.getExtractionSignalColor(dir);
        int signal = ConduitUtil.getInternalSignalForColor(this.getBundle(), col);
        int exSig = this.getExternalRedstoneSignalForDir(dir);
        if (mode == RedstoneControlMode.OFF) {
            if (!RedstoneControlMode.isConditionMet(mode, signal)) return false;
            if (col != DyeColor.RED) return true;
            if (!RedstoneControlMode.isConditionMet(mode, exSig)) return false;
            return true;
        }
        if (RedstoneControlMode.isConditionMet(mode, signal)) return true;
        if (col != DyeColor.RED) return false;
        if (!RedstoneControlMode.isConditionMet(mode, exSig)) return false;
        return true;
    }

    private int getExternalRedstoneSignalForDir(ForgeDirection dir) {
        int result;
        Integer cached;
        if (this.redstoneStateDirty) {
            this.externalRedstoneSignals.clear();
            this.redstoneStateDirty = false;
        }
        if ((cached = this.externalRedstoneSignals.get(dir)) == null) {
            TileEntity te = this.getBundle().getEntity();
            result = te.func_145831_w().func_94572_D(te.field_145851_c, te.field_145848_d, te.field_145849_e);
            this.externalRedstoneSignals.put(dir, result);
        } else {
            result = cached;
        }
        return result;
    }

    @Override
    public int getMaxEnergyRecieved(ForgeDirection dir) {
        ConnectionMode mode = this.getConnectionMode(dir);
        if (mode == ConnectionMode.OUTPUT || mode == ConnectionMode.DISABLED || !this.isRedstoneEnabled(dir)) {
            return 0;
        }
        return this.getCapacitor().getMaxEnergyReceived();
    }

    @Override
    public int getMaxEnergyExtracted(ForgeDirection dir) {
        ConnectionMode mode = this.getConnectionMode(dir);
        if (mode == ConnectionMode.INPUT || mode == ConnectionMode.DISABLED || !this.isRedstoneEnabled(dir)) {
            return 0;
        }
        if (this.recievedRfThisTick(dir)) {
            return 0;
        }
        return this.getCapacitor().getMaxEnergyExtracted();
    }

    private boolean recievedRfThisTick(ForgeDirection dir) {
        long recT;
        if (this.recievedTicks == null || dir == null || this.recievedTicks.get(dir) == null || this.getBundle() == null || this.getBundle().getWorld() == null) {
            return false;
        }
        long curTick = this.getBundle().getWorld().func_82737_E();
        return curTick - (recT = this.recievedTicks.get(dir).longValue()) <= 5L;
    }

    @Override
    public boolean onNeighborBlockChange(Block blockId) {
        this.redstoneStateDirty = true;
        if (this.network != null && this.network.powerManager != null) {
            this.network.powerManager.receptorsChanged();
        }
        return super.onNeighborBlockChange(blockId);
    }

    @Override
    public void setConnectionMode(ForgeDirection dir, ConnectionMode mode) {
        super.setConnectionMode(dir, mode);
        this.recievedTicks = null;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.getMaxEnergyRecieved(from) == 0 || maxReceive <= 0) {
            return 0;
        }
        int freeSpace = this.getMaxEnergyStored() - this.getEnergyStored();
        int result = Math.min(maxReceive, freeSpace);
        if (!simulate && result > 0) {
            this.setEnergyStored(this.getEnergyStored() + result);
            if (this.getBundle() != null) {
                if (this.recievedTicks == null) {
                    this.recievedTicks = new EnumMap(ForgeDirection.class);
                }
                this.recievedTicks.put(from, this.getBundle().getWorld().func_82737_E());
            }
        }
        return result;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return 0;
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.getMaxEnergyStored();
    }

    @Override
    public AbstractConduitNetwork<?, ?> getNetwork() {
        return this.network;
    }

    @Override
    public boolean setNetwork(AbstractConduitNetwork<?, ?> network) {
        this.network = (PowerConduitNetwork)network;
        return true;
    }

    @Override
    public boolean canConnectToExternal(ForgeDirection direction, boolean ignoreDisabled) {
        IPowerInterface rec = this.getExternalPowerReceptor(direction);
        return rec != null && rec.canConduitConnect(direction);
    }

    @Override
    public boolean canConnectToConduit(ForgeDirection direction, IConduit conduit) {
        boolean res = super.canConnectToConduit(direction, conduit);
        if (!res) {
            return false;
        }
        if (Config.powerConduitCanDifferentTiersConnect) {
            return res;
        }
        if (!(conduit instanceof IPowerConduit)) {
            return false;
        }
        IPowerConduit pc = (IPowerConduit)conduit;
        return pc.getMaxEnergyStored() == this.getMaxEnergyStored();
    }

    @Override
    public void externalConnectionAdded(ForgeDirection direction) {
        super.externalConnectionAdded(direction);
        if (this.network != null) {
            TileEntity te = this.bundle.getEntity();
            this.network.powerReceptorAdded(this, direction, te.field_145851_c + direction.offsetX, te.field_145848_d + direction.offsetY, te.field_145849_e + direction.offsetZ, this.getExternalPowerReceptor(direction));
        }
    }

    @Override
    public void externalConnectionRemoved(ForgeDirection direction) {
        super.externalConnectionRemoved(direction);
        if (this.network != null) {
            TileEntity te = this.bundle.getEntity();
            this.network.powerReceptorRemoved(te.field_145851_c + direction.offsetX, te.field_145848_d + direction.offsetY, te.field_145849_e + direction.offsetZ);
        }
    }

    @Override
    public IPowerInterface getExternalPowerReceptor(ForgeDirection direction) {
        TileEntity te = this.bundle.getEntity();
        World world = te.func_145831_w();
        if (world == null) {
            return null;
        }
        TileEntity test = world.func_147438_o(te.field_145851_c + direction.offsetX, te.field_145848_d + direction.offsetY, te.field_145849_e + direction.offsetZ);
        if (test == null) {
            return null;
        }
        if (test instanceof IConduitBundle) {
            return null;
        }
        return PowerHandlerUtil.create(test);
    }

    @Override
    public ItemStack createItem() {
        return PowerConduit.createItemStackForSubtype(this.subtype);
    }

    @Override
    public Class<? extends IConduit> getBaseConduitType() {
        return IPowerConduit.class;
    }

    @Override
    public IIcon getTextureForState(CollidableComponent component) {
        if (component.dir == ForgeDirection.UNKNOWN) {
            return ICONS.get("enderio:powerConduitCore" + POSTFIX[this.subtype]);
        }
        if ("ColorController".equals(component.data)) {
            return IconUtil.whiteTexture;
        }
        return ICONS.get("enderio:powerConduit" + POSTFIX[this.subtype]);
    }

    @Override
    public IIcon getTextureForInputMode() {
        return ICONS.get("enderio:powerConduitInput");
    }

    @Override
    public IIcon getTextureForOutputMode() {
        return ICONS.get("enderio:powerConduitOutput");
    }

    @Override
    public IIcon getTransmitionTextureForState(CollidableComponent component) {
        return null;
    }

    @Override
    public Collection<CollidableComponent> createCollidables(CollidableCache.CacheKey key) {
        Collection<CollidableComponent> baseCollidables = super.createCollidables(key);
        if (key.dir == ForgeDirection.UNKNOWN) {
            return baseCollidables;
        }
        BoundingBox bb = ConduitGeometryUtil.instance.createBoundsForConnectionController(key.dir, key.offset);
        CollidableComponent cc = new CollidableComponent(IPowerConduit.class, bb, key.dir, "ColorController");
        ArrayList<CollidableComponent> result = new ArrayList<CollidableComponent>();
        result.addAll(baseCollidables);
        result.add(cc);
        return result;
    }

    @Override
    public int getMaxEnergyStored() {
        return PowerConduit.getCapacitors()[this.subtype].getMaxEnergyStored();
    }

    @Override
    public boolean displayPower() {
        return true;
    }

    static {
        POSTFIX = new String[]{"", "Enhanced", "Ender"};
        MIN = new Vector3d((double)0.425f, 0.42499999701976776, 0.42499999701976776);
        MAX = new Vector3d(PowerConduit.MIN.x + (double)0.075f, PowerConduit.MIN.y + (double)0.075f, PowerConduit.MIN.z + (double)0.075f);
        BOUNDS = new BoundingBox(MIN, MAX);
    }
}

