/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import com.enderio.core.common.util.DyeColor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.conduit.liquid.EnderLiquidConduit;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.packet.AbstractConduitPacket;
import crazypants.enderio.conduit.packet.ConTypeEnum;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketFluidChannel
extends AbstractConduitPacket<ILiquidConduit>
implements IMessageHandler<PacketFluidChannel, IMessage> {
    private ForgeDirection dir;
    private boolean isInput;
    private DyeColor channel;

    public PacketFluidChannel() {
    }

    public PacketFluidChannel(EnderLiquidConduit eConduit, ForgeDirection dir, boolean isInput, DyeColor channel) {
        super(eConduit.getBundle().getEntity(), ConTypeEnum.FLUID);
        this.dir = dir;
        this.isInput = isInput;
        this.channel = channel;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.dir.ordinal());
        buf.writeBoolean(this.isInput);
        buf.writeShort(this.channel.ordinal());
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.dir = ForgeDirection.values()[buf.readShort()];
        this.isInput = buf.readBoolean();
        this.channel = DyeColor.values()[buf.readShort()];
    }

    public IMessage onMessage(PacketFluidChannel message, MessageContext ctx) {
        ILiquidConduit conduit = (ILiquidConduit)message.getTileCasted(ctx);
        if (!(conduit instanceof EnderLiquidConduit)) {
            return null;
        }
        EnderLiquidConduit eCon = (EnderLiquidConduit)conduit;
        if (message.isInput) {
            eCon.setInputColor(message.dir, message.channel);
        } else {
            eCon.setOutputColor(message.dir, message.channel);
        }
        message.getWorld(ctx).func_147471_g(message.x, message.y, message.z);
        return null;
    }
}

