/*
 * Decompiled with CFR 0.152.
 */
package emt.tile.solar;

import emt.init.EMTBlocks;
import emt.tile.solar.TileEntitySolarBase;
import emt.util.EMTConfigHandler;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import java.util.LinkedHashMap;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;

public enum Solars {
    Compressed(EMTConfigHandler.compressedSolarOutput, null, 0, 0),
    Double_Compressed(EMTConfigHandler.doubleCompressedSolarOutput, null, 0, 1),
    Triple_Compressed(EMTConfigHandler.tripleCompressedSolarOutput, null, 0, 2),
    Compressed_Aqua(EMTConfigHandler.compressedSolarOutput, Aspect.WATER, 0, 3),
    Double_Compressed_Aqua(EMTConfigHandler.doubleCompressedSolarOutput, Aspect.WATER, 0, 4),
    Triple_Compressed_Aqua(EMTConfigHandler.tripleCompressedSolarOutput, Aspect.WATER, 0, 5),
    Compressed_Perditio(EMTConfigHandler.compressedSolarOutput, Aspect.ENTROPY, 0, 6),
    Double_Compressed_Perditio(EMTConfigHandler.doubleCompressedSolarOutput, Aspect.ENTROPY, 0, 7),
    Triple_Compressed_Perditio(EMTConfigHandler.tripleCompressedSolarOutput, Aspect.ENTROPY, 0, 8),
    Compressed_Ordo(EMTConfigHandler.compressedSolarOutput, Aspect.ORDER, 0, 9),
    Double_Compressed_Ordo(EMTConfigHandler.doubleCompressedSolarOutput, Aspect.ORDER, 0, 10),
    Triple_Compressed_Ordo(EMTConfigHandler.tripleCompressedSolarOutput, Aspect.ORDER, 0, 11),
    Compressed_Ignis(EMTConfigHandler.compressedSolarOutput, Aspect.FIRE, 0, 12),
    Double_Compressed_Ignis(EMTConfigHandler.doubleCompressedSolarOutput, Aspect.FIRE, 0, 13),
    Triple_Compressed_Ignis(EMTConfigHandler.tripleCompressedSolarOutput, Aspect.FIRE, 0, 14),
    Compressed_Aer(EMTConfigHandler.compressedSolarOutput, Aspect.AIR, 0, 15),
    Double_Compressed_Aer(EMTConfigHandler.doubleCompressedSolarOutput, Aspect.AIR, 1, 0),
    Triple_Compressed_Aer(EMTConfigHandler.tripleCompressedSolarOutput, Aspect.AIR, 1, 1),
    Compressed_Terra(EMTConfigHandler.compressedSolarOutput, Aspect.EARTH, 1, 2),
    Double_Compressed_Terra(EMTConfigHandler.doubleCompressedSolarOutput, Aspect.EARTH, 1, 3),
    Triple_Compressed_Terra(EMTConfigHandler.tripleCompressedSolarOutput, Aspect.EARTH, 1, 4),
    Quadruple_Compressed(EMTConfigHandler.quadrupleCompressedSolarOutput, null, 2, 0),
    Quadruple_Compressed_Ordo(EMTConfigHandler.quadrupleCompressedSolarOutput, Aspect.ORDER, 2, 1),
    Quadruple_Compressed_Perditio(EMTConfigHandler.quadrupleCompressedSolarOutput, Aspect.ENTROPY, 2, 2),
    Quadruple_Compressed_Aer(EMTConfigHandler.quadrupleCompressedSolarOutput, Aspect.AIR, 2, 3),
    Quadruple_Compressed_Terra(EMTConfigHandler.quadrupleCompressedSolarOutput, Aspect.EARTH, 2, 4),
    Quadruple_Compressed_Aqua(EMTConfigHandler.quadrupleCompressedSolarOutput, Aspect.WATER, 2, 5),
    Quadruple_Compressed_Ignis(EMTConfigHandler.quadrupleCompressedSolarOutput, Aspect.FIRE, 2, 6),
    Quintuple_Compressed(EMTConfigHandler.quintupleCompressedSolarOutput, null, 2, 7),
    Quintuple_Compressed_Ordo(EMTConfigHandler.quintupleCompressedSolarOutput, Aspect.ORDER, 2, 8),
    Quintuple_Compressed_Perditio(EMTConfigHandler.quintupleCompressedSolarOutput, Aspect.ENTROPY, 2, 9),
    Quintuple_Compressed_Aer(EMTConfigHandler.quintupleCompressedSolarOutput, Aspect.AIR, 2, 10),
    Quintuple_Compressed_Terra(EMTConfigHandler.quintupleCompressedSolarOutput, Aspect.EARTH, 2, 11),
    Quintuple_Compressed_Aqua(EMTConfigHandler.quintupleCompressedSolarOutput, Aspect.WATER, 2, 12),
    Quintuple_Compressed_Ignis(EMTConfigHandler.quintupleCompressedSolarOutput, Aspect.FIRE, 2, 13),
    Sextuple_Compressed(EMTConfigHandler.sextupleCompressedSolarOutput, null, 2, 14),
    Sextuple_Compressed_Ordo(EMTConfigHandler.sextupleCompressedSolarOutput, Aspect.ORDER, 2, 15),
    Sextuple_Compressed_Perditio(EMTConfigHandler.sextupleCompressedSolarOutput, Aspect.ENTROPY, 3, 0),
    Sextuple_Compressed_Aer(EMTConfigHandler.sextupleCompressedSolarOutput, Aspect.AIR, 3, 1),
    Sextuple_Compressed_Terra(EMTConfigHandler.sextupleCompressedSolarOutput, Aspect.EARTH, 3, 2),
    Sextuple_Compressed_Aqua(EMTConfigHandler.sextupleCompressedSolarOutput, Aspect.WATER, 3, 3),
    Sextuple_Compressed_Ignis(EMTConfigHandler.sextupleCompressedSolarOutput, Aspect.FIRE, 3, 4),
    Septuple_Compressed(EMTConfigHandler.septupleCompressedSolarOutput, null, 3, 5),
    Septuple_Compressed_Ordo(EMTConfigHandler.septupleCompressedSolarOutput, Aspect.ORDER, 3, 6),
    Septuple_Compressed_Perditio(EMTConfigHandler.septupleCompressedSolarOutput, Aspect.ENTROPY, 3, 7),
    Septuple_Compressed_Aer(EMTConfigHandler.septupleCompressedSolarOutput, Aspect.AIR, 3, 8),
    Septuple_Compressed_Terra(EMTConfigHandler.septupleCompressedSolarOutput, Aspect.EARTH, 3, 9),
    Septuple_Compressed_Aqua(EMTConfigHandler.septupleCompressedSolarOutput, Aspect.WATER, 3, 10),
    Septuple_Compressed_Ignis(EMTConfigHandler.septupleCompressedSolarOutput, Aspect.FIRE, 3, 11),
    Octuple_Compressed(EMTConfigHandler.octupleCompressedSolarOutput, null, 3, 12),
    Octuple_Compressed_Ordo(EMTConfigHandler.octupleCompressedSolarOutput, Aspect.ORDER, 3, 13),
    Octuple_Compressed_Perditio(EMTConfigHandler.octupleCompressedSolarOutput, Aspect.ENTROPY, 3, 14),
    Octuple_Compressed_Aer(EMTConfigHandler.octupleCompressedSolarOutput, Aspect.AIR, 3, 15),
    Octuple_Compressed_Terra(EMTConfigHandler.octupleCompressedSolarOutput, Aspect.EARTH, 4, 0),
    Octuple_Compressed_Aqua(EMTConfigHandler.octupleCompressedSolarOutput, Aspect.WATER, 4, 1),
    Octuple_Compressed_Ignis(EMTConfigHandler.octupleCompressedSolarOutput, Aspect.FIRE, 4, 2);

    private static final LinkedHashMap<Long, Solars> cachemap;
    int instance;
    int meta;
    Aspect aspect;
    String guiname;
    private double output;

    private Solars(double output, Aspect aspect, int instance, int meta) {
        this.aspect = aspect;
        this.output = output;
        this.guiname = this.name().replaceAll("_", " ") + " Solar";
        this.instance = instance;
        this.meta = meta;
    }

    private static Solars getBaseSolar(double output) {
        for (Solars s : Solars.values()) {
            if (s.output != output || s.aspect != null) continue;
            return s;
        }
        return null;
    }

    public static void registerReverseRecipes() {
        for (Solars s : Solars.values()) {
            if (s.aspect == null) continue;
            GT_Values.RA.addChemicalBathRecipe(new ItemStack(EMTBlocks.solars[s.instance], 1, s.meta), Materials.Chlorine.getGas(1000L), new ItemStack(EMTBlocks.solars[Solars.getBaseSolar((double)s.output).instance], 1, Solars.getBaseSolar((double)s.output).meta), null, null, null, 30, 30);
        }
    }

    public static void populateCache() {
        for (Solars s : Solars.values()) {
            cachemap.put(Long.valueOf(s.instance << 4 | s.meta), s);
        }
    }

    public static int getCountOfInstances() {
        int ret = 0;
        for (Solars s : Solars.values()) {
            ret = Math.max(s.instance, ret);
        }
        return ret + 1;
    }

    public static int getCountOfMetas(int instance) {
        int ret = 0;
        for (Solars s : Solars.values()) {
            if (s.instance != instance) continue;
            ret = Math.max(s.meta, ret);
        }
        return ret + 1;
    }

    public static TileEntitySolarBase getTileEntitySolarBase(int instance, int meta) {
        Solars cached = cachemap.get(instance << 4 | meta);
        if (cached != null) {
            return new TileEntitySolarBase(cached.output, cached.aspect, cached.guiname, instance, meta);
        }
        for (Solars s : Solars.values()) {
            if (s.instance != instance || s.meta != meta) continue;
            return new TileEntitySolarBase(s.output, s.aspect, s.guiname, instance, meta);
        }
        return null;
    }

    public static String getNameFromSolar(int instance, int meta) {
        Solars cached = cachemap.get(instance << 4 | meta);
        if (cached != null) {
            return cached.guiname;
        }
        for (Solars s : Solars.values()) {
            if (s.instance != instance || s.meta != meta) continue;
            return s.guiname;
        }
        return "";
    }

    static {
        cachemap = new LinkedHashMap();
    }
}

