/*
 * Decompiled with CFR 0.152.
 */
package emt.gthandler.common.implementations.automation;

import emt.gthandler.common.implementations.EssentiaHatch;
import emt.tile.TileEntityEMT;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IEssentiaTransport;

public class EssentiaFiller
extends TileEntityEMT
implements IAspectContainer,
IEssentiaTransport {
    private AspectList current = new AspectList();
    private byte tick = 0;

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        NBTTagList tlist = new NBTTagList();
        Aspect[] aspectA = this.current.getAspects();
        for (int i = 0; i < aspectA.length; ++i) {
            Aspect aspect = aspectA[i];
            if (aspect == null) continue;
            NBTTagCompound f = new NBTTagCompound();
            f.func_74778_a("key", aspect.getTag());
            f.func_74768_a("amount", this.current.getAmount(aspect));
            tlist.func_74742_a((NBTBase)f);
        }
        tagCompound.func_74782_a("Aspects", (NBTBase)tlist);
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.current = new AspectList();
        NBTTagList tlist = tagCompound.func_150295_c("Aspects", 10);
        for (int j = 0; j < tlist.func_74745_c(); ++j) {
            NBTTagCompound rs = tlist.func_150305_b(j);
            if (!rs.func_74764_b("key")) continue;
            this.current.add(Aspect.getAspect((String)rs.func_74779_i("key")), rs.func_74762_e("amount"));
        }
    }

    public void func_145845_h() {
        this.tick = (byte)(this.tick + 1);
        this.fillfrompipe();
        if (this.tick % 20 == 0) {
            TileEntity T = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            if (this.checkTE(T)) {
                this.tick = 0;
                return;
            }
            if (T == null) {
                T = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
            }
            if (this.checkTE(T)) {
                this.tick = 0;
                return;
            }
            if (T == null) {
                T = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
            }
            if (this.checkTE(T)) {
                this.tick = 0;
                return;
            }
            if (T == null) {
                T = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
            }
            if (this.checkTE(T)) {
                this.tick = 0;
                return;
            }
            if (T == null) {
                T = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            }
            if (this.checkTE(T)) {
                this.tick = 0;
                return;
            }
            if (T == null) {
                T = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
            }
            if (this.checkTE(T)) {
                this.tick = 0;
                return;
            }
        }
    }

    private boolean checkTE(TileEntity T) {
        IMetaTileEntity M;
        if (T == null) {
            return false;
        }
        if (this.current.visSize() > 0 && T instanceof IGregTechTileEntity && (M = ((IGregTechTileEntity)T).getMetaTileEntity()) instanceof EssentiaHatch) {
            if (((EssentiaHatch)M).addAspectList(this.current)) {
                this.current = new AspectList();
            }
            return true;
        }
        return false;
    }

    public void fillfrompipe() {
        TileEntity[] te = new TileEntity[ForgeDirection.VALID_DIRECTIONS.length];
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            te[i] = ThaumcraftApiHelper.getConnectableTile((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ForgeDirection)ForgeDirection.VALID_DIRECTIONS[i]);
            if (te[i] == null) continue;
            IEssentiaTransport pipe = (IEssentiaTransport)te[i];
            if (!pipe.canOutputTo(ForgeDirection.VALID_DIRECTIONS[i])) {
                return;
            }
            if (pipe.getEssentiaType(ForgeDirection.VALID_DIRECTIONS[i]) == null || pipe.getSuctionAmount(ForgeDirection.VALID_DIRECTIONS[i]) >= this.getSuctionAmount(ForgeDirection.VALID_DIRECTIONS[i])) continue;
            this.addToContainer(pipe.getEssentiaType(ForgeDirection.VALID_DIRECTIONS[i]), pipe.takeEssentia(pipe.getEssentiaType(ForgeDirection.VALID_DIRECTIONS[i]), 1, ForgeDirection.VALID_DIRECTIONS[i]));
        }
    }

    public AspectList getAspects() {
        return this.current;
    }

    public void setAspects(AspectList aspectList) {
        this.current.add(aspectList);
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return true;
    }

    public int addToContainer(Aspect aspect, int i) {
        this.current.add(aspect, i);
        return 0;
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        return false;
    }

    public boolean takeFromContainer(AspectList aspectList) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        return this.current.aspects.containsKey(aspect) && i <= this.current.getAmount(aspect);
    }

    public boolean doesContainerContain(AspectList aspectList) {
        ArrayList<Boolean> ret = new ArrayList<Boolean>();
        for (Aspect a : aspectList.aspects.keySet()) {
            if (this.current.aspects.containsKey(a)) {
                ret.add(true);
                continue;
            }
            ret.add(false);
        }
        return !ret.contains(false);
    }

    public int containerContains(Aspect aspect) {
        return this.current.aspects.containsKey(aspect) ? this.current.getAmount(aspect) : 0;
    }

    public boolean isConnectable(ForgeDirection forgeDirection) {
        return true;
    }

    public boolean canInputFrom(ForgeDirection forgeDirection) {
        return true;
    }

    public boolean canOutputTo(ForgeDirection forgeDirection) {
        return false;
    }

    public void setSuction(Aspect aspect, int i) {
    }

    public Aspect getSuctionType(ForgeDirection forgeDirection) {
        return null;
    }

    public int getSuctionAmount(ForgeDirection forgeDirection) {
        return 256;
    }

    public int takeEssentia(Aspect aspect, int i, ForgeDirection forgeDirection) {
        return 0;
    }

    public int addEssentia(Aspect aspect, int i, ForgeDirection forgeDirection) {
        this.current.add(aspect, i);
        return 0;
    }

    public Aspect getEssentiaType(ForgeDirection forgeDirection) {
        return this.current.getAspects()[0];
    }

    public int getEssentiaAmount(ForgeDirection forgeDirection) {
        int ret = 0;
        for (Aspect A : this.current.aspects.keySet()) {
            ret += this.current.getAmount(A);
        }
        return ret;
    }

    public int getMinimumSuction() {
        return Integer.MAX_VALUE;
    }

    public boolean renderExtendedTube() {
        return true;
    }
}

