/*
 * Decompiled with CFR 0.152.
 */
package emt.item.armor.chestplate;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import emt.EMT;
import emt.client.model.ModelSpecialArmor;
import emt.init.EMTItems;
import emt.util.EMTConfigHandler;
import gregtech.api.hazards.Hazard;
import gregtech.api.hazards.IHazardProtector;
import ic2.api.item.ElectricItem;
import ic2.api.item.IC2Items;
import ic2.core.IC2;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.init.InternalName;
import ic2.core.item.armor.ItemArmorElectric;
import ic2.core.util.StackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import thaumcraft.api.IRunicArmor;

@Optional.Interface(iface="gregtech.api.hazards.IHazardProtector", modid="gregtech_nh")
public class ItemInfusedQuantumChestplate
extends ItemArmorElectric
implements IRunicArmor,
IHazardProtector {
    public static AudioSource audioSource;
    protected static ArrayList<Integer> potionRemovalCost;
    private static boolean lastJetpackUsed;
    public final byte NONE = 0;
    public final byte JETPACK = 1;
    public final byte THAUMIUM = (byte)2;
    public final byte NANO = (byte)3;
    public final byte QUANTUM = (byte)4;
    private IIcon iconNONE;
    private IIcon iconJETPACK;
    private IIcon iconTHAUMIUM;
    private IIcon iconNANO;
    private IIcon iconQUANTUM;

    public ItemInfusedQuantumChestplate(InternalName internalName, int armorType) {
        super(internalName, InternalName.quantum, armorType, 2.0E7, 18000.0, 4);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        this.func_77637_a(EMT.TAB);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.iconNONE = iconRegister.func_94245_a("emt:armor/armor_quantum_chest");
        this.iconJETPACK = iconRegister.func_94245_a("emt:armor/armor_quantum_chest_jetpack");
        this.iconTHAUMIUM = iconRegister.func_94245_a("emt:armor/armor_quantum_chest_wing_t");
        this.iconNANO = iconRegister.func_94245_a("emt:armor/armor_quantum_chest_wing_n");
        this.iconQUANTUM = iconRegister.func_94245_a("emt:armor/armor_quantum_chest_wing_q");
    }

    public String func_77667_c(ItemStack itemstack) {
        return "item.EMT.chestplates.infusedQuantum";
    }

    public String func_77653_i(ItemStack stack) {
        return StatCollector.func_74838_a((String)(this.func_77657_g(stack) + ".name")).trim();
    }

    public double getDamageAbsorptionRatio() {
        return 1.1;
    }

    public int getEnergyPerDamage() {
        return 20000;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.rare;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)itemStack);
        int toggleTimer = nbt.func_74771_c("toggleTimer");
        boolean ret = false;
        boolean hoverMode = nbt.func_74767_n("hoverMode");
        boolean jetpackUsed = false;
        byte wing = nbt.func_74771_c("wing");
        if (!world.field_72995_K) {
            Item currentItem;
            for (PotionEffect effect : player.func_70651_bq()) {
                if (!potionRemovalCost.contains(effect.func_76456_a())) continue;
                IC2.platform.removePotion((EntityLivingBase)player, effect.func_76456_a());
            }
            ItemStack currentStack = player.field_71071_by.func_70448_g();
            Item item = currentItem = currentStack == null ? null : currentStack.func_77973_b();
            if (nbt.func_74764_b("useother")) {
                String useother = nbt.func_74779_i("useother");
                if (useother.equals("Jetpack")) {
                    nbt.func_74774_a("wing", (byte)1);
                }
                if (useother.equals("TW")) {
                    nbt.func_74774_a("wing", (byte)2);
                }
                if (useother.equals("NW")) {
                    nbt.func_74774_a("wing", (byte)3);
                }
                if (useother.equals("QW")) {
                    nbt.func_74774_a("wing", (byte)4);
                }
                wing = nbt.func_74771_c("wing");
                nbt.func_82580_o("useother");
            }
            if (wing == 0) {
                nbt.func_74774_a("wing", (byte)0);
            }
            if (IC2.keyboard.isJumpKeyDown(player) && IC2.keyboard.isModeSwitchKeyDown(player) && toggleTimer == 0) {
                toggleTimer = 30;
                boolean bl = hoverMode = !hoverMode;
                if (IC2.platform.isSimulating()) {
                    nbt.func_74757_a("hoverMode", hoverMode);
                    if (hoverMode) {
                        IC2.platform.messagePlayer(player, "Hover Mode enabled.", new Object[0]);
                    } else {
                        IC2.platform.messagePlayer(player, "Hover Mode disabled.", new Object[0]);
                    }
                }
            }
            if (currentStack != null && player.func_70093_af() && toggleTimer == 0 && wing == 0) {
                if (currentItem == IC2Items.getItem((String)"electricJetpack").func_77973_b()) {
                    IC2.platform.messagePlayer(player, "Jetpack enabled.", new Object[0]);
                    nbt.func_74774_a("wing", (byte)1);
                    nbt.func_74768_a("jetpackCharge", (int)ElectricItem.manager.getCharge(currentStack));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                } else if (currentItem == EMTItems.thaumiumWing) {
                    IC2.platform.messagePlayer(player, "Thaumium wings enabled.", new Object[0]);
                    nbt.func_74774_a("wing", (byte)2);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                } else if (currentItem == EMTItems.nanoWing) {
                    IC2.platform.messagePlayer(player, "Nano wings enabled.", new Object[0]);
                    nbt.func_74774_a("wing", (byte)3);
                    nbt.func_74768_a("NWCharge", (int)ElectricItem.manager.getCharge(player.field_71071_by.func_70448_g()));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                } else if (currentItem == EMTItems.quantumWing) {
                    IC2.platform.messagePlayer(player, "Quantum wings enabled.", new Object[0]);
                    nbt.func_74774_a("wing", (byte)4);
                    nbt.func_74768_a("QWCharge", (int)ElectricItem.manager.getCharge(currentStack));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
            }
            if (currentStack == null && nbt.func_74767_n("unequip") && player.func_70093_af()) {
                ItemStack charged;
                toggleTimer = 30;
                if (wing == 1) {
                    IC2.platform.messagePlayer(player, "Jetpack disabled.", new Object[0]);
                    nbt.func_74774_a("wing", (byte)0);
                    charged = new ItemStack(IC2Items.getItem((String)"electricJetpack").func_77973_b());
                    if (nbt.func_74762_e("jetpackCharge") > 0) {
                        ElectricItem.manager.charge(charged, (double)nbt.func_74762_e("jetpackCharge"), 1, true, false);
                    } else {
                        ElectricItem.manager.charge(charged, 0.0, 1, true, false);
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, charged);
                }
                if (wing == 2) {
                    IC2.platform.messagePlayer(player, "Thaumium wings disabled.", new Object[0]);
                    nbt.func_74774_a("wing", (byte)0);
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(EMTItems.thaumiumWing));
                }
                if (wing == 3) {
                    IC2.platform.messagePlayer(player, "Nano wings disabled.", new Object[0]);
                    nbt.func_74774_a("wing", (byte)0);
                    charged = new ItemStack(EMTItems.nanoWing);
                    if (nbt.func_74762_e("NWCharge") > 0) {
                        ElectricItem.manager.charge(charged, (double)nbt.func_74762_e("NWCharge"), 3, true, false);
                    } else {
                        ElectricItem.manager.charge(charged, 0.0, 3, true, false);
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, charged);
                }
                if (wing == 4) {
                    IC2.platform.messagePlayer(player, "Quantum wings disabled.", new Object[0]);
                    nbt.func_74774_a("wing", (byte)0);
                    charged = new ItemStack(EMTItems.quantumWing);
                    if (nbt.func_74762_e("QWCharge") > 0) {
                        ElectricItem.manager.charge(charged, (double)nbt.func_74762_e("QWCharge"), 3, true, false);
                    } else {
                        ElectricItem.manager.charge(charged, 0.0, 3, true, false);
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, charged);
                }
            }
            nbt.func_74757_a("unequip", false);
        }
        if (IC2.keyboard.isJumpKeyDown(player) && wing == 1 || hoverMode && player.field_70181_x < (double)-0.03f) {
            jetpackUsed = this.useJetpack(player, hoverMode, itemStack);
        }
        if (wing == 2) {
            this.useWings(player, itemStack, world, 0.15f, 0.7f, 0.5f, 0, false);
        }
        if (wing == 3) {
            this.useWings(player, itemStack, world, 0.25f, 0.6f, 0.3f, 5, true);
        }
        if (wing == 4) {
            this.useWings(player, itemStack, world, 0.33f, 0.5f, 0.2f, 7, true);
        }
        if (IC2.platform.isSimulating() && toggleTimer > 0) {
            toggleTimer = (byte)(toggleTimer - 1);
            nbt.func_74774_a("toggleTimer", (byte)toggleTimer);
        }
        if (IC2.platform.isRendering() && player == IC2.platform.getPlayerInstance()) {
            if (lastJetpackUsed != jetpackUsed) {
                if (jetpackUsed) {
                    if (audioSource == null) {
                        audioSource = IC2.audioManager.createSource((Object)player, PositionSpec.Backpack, "Tools/Jetpack/JetpackLoop.ogg", true, false, IC2.audioManager.getDefaultVolume());
                    }
                    if (audioSource != null) {
                        audioSource.play();
                    }
                } else if (audioSource != null) {
                    audioSource.remove();
                    audioSource = null;
                }
                lastJetpackUsed = jetpackUsed;
            }
            if (audioSource != null) {
                audioSource.updatePosition();
            }
        }
        ret = jetpackUsed;
        player.func_70066_B();
        if (ret) {
            player.field_71069_bz.func_75142_b();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack stack) {
        try {
            byte wing = stack.field_77990_d.func_74771_c("wing");
            switch (wing) {
                case 1: {
                    return this.iconJETPACK;
                }
                case 2: {
                    return this.iconTHAUMIUM;
                }
                case 3: {
                    return this.iconNANO;
                }
                case 4: {
                    return this.iconQUANTUM;
                }
            }
            return this.iconNONE;
        }
        catch (Exception e) {
            return this.iconNONE;
        }
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        try {
            byte wing = stack.field_77990_d.func_74771_c("wing");
            switch (wing) {
                case 1: {
                    return this.iconJETPACK;
                }
                case 2: {
                    return this.iconTHAUMIUM;
                }
                case 3: {
                    return this.iconNANO;
                }
                case 4: {
                    return this.iconQUANTUM;
                }
            }
            return this.iconNONE;
        }
        catch (Exception e) {
            return this.iconNONE;
        }
    }

    public int func_77619_b() {
        if (!EMTConfigHandler.enchanting) {
            return 0;
        }
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        byte wing = stack.field_77990_d.func_74771_c("wing");
        switch (wing) {
            case 1: {
                return "emt:textures/models/quantum_jetpack.png";
            }
            case 2: {
                return "emt:textures/models/quantum_wings_t.png";
            }
            case 3: {
                return "emt:textures/models/quantum_wings_n.png";
            }
            case 4: {
                return "emt:textures/models/quantum_wings_q.png";
            }
        }
        return "emt:textures/models/quantum.png";
    }

    public int getTier(ItemStack itemStack) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entity, ItemStack stack, int armorSlot) {
        if (entity instanceof EntityPlayer && stack != null && stack.field_77990_d != null) {
            byte wing = stack.field_77990_d.func_74771_c("wing");
            if (wing == 1) {
                ModelSpecialArmor.getInstance().type = 1;
            } else if (wing != 0) {
                ModelSpecialArmor.getInstance().type = 2;
                if (stack.field_77990_d.func_74764_b("isJumping")) {
                    ModelSpecialArmor.getInstance().isJumping = stack.field_77990_d.func_74767_n("isJumping");
                }
            } else {
                ModelSpecialArmor.getInstance().type = 0;
            }
        } else {
            ModelSpecialArmor.getInstance().type = 0;
        }
        return ModelSpecialArmor.getInstance();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(StatCollector.func_74838_a((String)"ic2.item.tooltip.PowerTier") + " " + this.getTier(new ItemStack((Item)this)));
    }

    public boolean useJetpack(EntityPlayer player, boolean hoverMode, ItemStack stack) {
        int worldHeight;
        double y;
        int jetpackMaxCharge = 30000;
        float power = 1.0f;
        float dropPercentage = 0.05f;
        if (ElectricItem.manager.getCharge(stack) <= 0.0) {
            return false;
        }
        if ((float)ElectricItem.manager.getCharge(stack) / (float)jetpackMaxCharge <= dropPercentage) {
            power = (float)((double)power * (ElectricItem.manager.getCharge(stack) / (double)jetpackMaxCharge) * (double)dropPercentage);
        }
        if (IC2.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster = 3.5f;
            if (hoverMode) {
                retruster = 0.5f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                player.func_70060_a(0.0f, 0.4f * forwardpower, 0.02f);
            }
        }
        if ((y = player.field_70163_u) > (double)((worldHeight = IC2.getWorldHeight((World)player.field_70170_p)) - 25)) {
            if (y > (double)worldHeight) {
                y = worldHeight;
            }
            power = (float)((double)power * (((double)worldHeight - y) / 25.0));
        }
        double prevmotion = player.field_70181_x;
        player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.2f), (double)0.6f);
        if (hoverMode) {
            float maxHoverY = -0.025f;
            if (IC2.keyboard.isSneakKeyDown(player)) {
                maxHoverY = -0.1f;
            }
            if (IC2.keyboard.isJumpKeyDown(player)) {
                maxHoverY = 0.1f;
            }
            if (player.field_70181_x > (double)maxHoverY) {
                player.field_70181_x = maxHoverY;
                if (prevmotion > player.field_70181_x) {
                    player.field_70181_x = prevmotion;
                }
            }
        }
        double consume = 8.0;
        if (hoverMode) {
            consume = 10.0;
        }
        ElectricItem.manager.use(stack, consume, (EntityLivingBase)player);
        player.field_70143_R = 0.0f;
        player.field_70140_Q = 0.0f;
        IC2.platform.resetPlayerInAirTime(player);
        return true;
    }

    void useWings(EntityPlayer player, ItemStack stack, World world, float motionY, float motionXZ, float f1, int amount, boolean isElectric) {
        byte f;
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData((ItemStack)stack);
        boolean isJumping = IC2.keyboard.isJumpKeyDown(player);
        nbt.func_74757_a("isJumping", isJumping);
        if (isJumping) {
            f = nbt.func_74771_c("f");
            nbt.func_74757_a("isHolding", true);
            if (IC2.keyboard.isSneakKeyDown(player)) {
                nbt.func_74774_a("f", (byte)0);
            } else {
                nbt.func_74774_a("f", (byte)(f + 1));
            }
            if (f > 7) {
                nbt.func_74774_a("f", (byte)7);
            }
        } else if (nbt.func_74767_n("isHolding")) {
            f = nbt.func_74771_c("f");
            nbt.func_74757_a("isHolding", false);
            if (!IC2.keyboard.isSneakKeyDown(player)) {
                player.field_70181_x = motionY * (float)f;
                if (isElectric) {
                    ElectricItem.manager.use(stack, (double)(motionY * (float)f * 10.0f * (float)amount), (EntityLivingBase)player);
                }
                if (player.field_70159_w < 0.5 && player.field_70179_y < 0.5 && player.field_70159_w > -0.5 && player.field_70179_y > -0.5) {
                    player.field_70159_w /= (double)motionXZ;
                    player.field_70179_y /= (double)motionXZ;
                }
                world.func_72908_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, "mob.ghast.fireball", 1.0f, 1.0f);
                for (int i = 0; i < 4; ++i) {
                    world.func_72869_a("cloud", player.field_70165_t - 1.0 + (double)world.field_73012_v.nextInt(100) / 50.0, player.field_70163_u - 1.0, player.field_70161_v - 1.0 + (double)world.field_73012_v.nextInt(100) / 50.0, 0.0, -0.5, 0.0);
                }
            }
            nbt.func_74774_a("f", (byte)0);
        }
        if (isJumping && !player.field_70122_E && player.field_70181_x < 0.0) {
            player.field_70181_x *= (double)f1;
            player.field_70143_R = 0.0f;
        }
        if (player.func_70090_H() && !player.field_71075_bZ.field_75098_d) {
            player.field_70181_x += -0.05;
        }
        if (EMTConfigHandler.impactOfRain) {
            int playerX = MathHelper.func_76128_c((double)player.field_70165_t);
            int playerY = MathHelper.func_76128_c((double)player.field_70163_u);
            int playerZ = MathHelper.func_76128_c((double)player.field_70161_v);
            if (world.func_72807_a(playerX, playerZ).func_76738_d() && world.func_72937_j(playerX, playerY, playerZ) && world.func_72896_J() && !player.field_71075_bZ.field_75098_d) {
                player.field_70181_x += -0.05;
            }
        }
        if (player.func_70093_af() && !player.field_70122_E && player.field_70181_x < 0.0) {
            player.field_70181_x *= 0.6;
            player.field_70143_R = 0.0f;
        }
    }

    public int getRunicCharge(ItemStack itemStack) {
        return 0;
    }

    @Optional.Method(modid="gregtech_nh")
    public boolean protectsAgainst(ItemStack itemStack, Hazard hazard) {
        return true;
    }

    static {
        potionRemovalCost = new ArrayList();
        lastJetpackUsed = false;
    }

    public class EventHandler {
        @SubscribeEvent
        public void onEntityLivingFallEvent(LivingFallEvent event) {
            EntityLivingBase entity;
            ItemStack armor;
            if (IC2.platform.isSimulating() && event.entity instanceof EntityLivingBase && (armor = (entity = (EntityLivingBase)event.entity).func_71124_b(1)) != null && armor.func_77973_b() == ItemInfusedQuantumChestplate.this) {
                int fallDamage = Math.max((int)event.distance - 10, 0);
                double energyCost = ItemInfusedQuantumChestplate.this.getEnergyPerDamage() * fallDamage;
                if (energyCost <= ElectricItem.manager.getCharge(armor)) {
                    ElectricItem.manager.discharge(armor, energyCost, Integer.MAX_VALUE, true, false, false);
                    event.setCanceled(true);
                }
            }
        }
    }
}

