/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks.machine;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.BlockDE;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.TilePlayerDetector;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class PlayerDetector
extends BlockDE {
    IIcon side_inactive;
    IIcon side_active;
    IIcon top;
    IIcon bottom;

    public PlayerDetector() {
        this.func_149663_c("playerDetector");
        this.func_149647_a(DraconicEvolution.tabBlocksItems);
        this.func_149672_a(field_149769_e);
        ModBlocks.register(this);
    }

    @Override
    public void func_149651_a(IIconRegister iconRegister) {
        this.side_inactive = iconRegister.func_94245_a(References.RESOURCESPREFIX + "player_detector_side_inactive");
        this.side_active = iconRegister.func_94245_a(References.RESOURCESPREFIX + "player_detector_side_active");
        this.top = iconRegister.func_94245_a(References.RESOURCESPREFIX + "machine_top_0");
        this.bottom = iconRegister.func_94245_a(References.RESOURCESPREFIX + "machine_side");
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        IIcon side_icon = tile != null && tile instanceof TilePlayerDetector && ((TilePlayerDetector)tile).output ? this.side_active : this.side_inactive;
        if (side == 0) {
            return this.bottom;
        }
        if (side == 1) {
            return this.top;
        }
        return side_icon;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == 0) {
            return this.bottom;
        }
        if (side == 1) {
            return this.top;
        }
        return this.side_active;
    }

    public boolean func_149747_d(IBlockAccess p_149747_1_, int p_149747_2_, int p_149747_3_, int p_149747_4_, int p_149747_5_) {
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TilePlayerDetector();
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return side != 0 && side != 1;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int meta) {
        TilePlayerDetector detector;
        TileEntity te = world.func_147438_o(x, y, z);
        TilePlayerDetector tilePlayerDetector = detector = te != null && te instanceof TilePlayerDetector ? (TilePlayerDetector)te : null;
        if (detector != null) {
            return detector.output ? 15 : 0;
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int meta) {
        TilePlayerDetector detector;
        TileEntity te = world.func_147438_o(x, y, z);
        TilePlayerDetector tilePlayerDetector = detector = te != null && te instanceof TilePlayerDetector ? (TilePlayerDetector)te : null;
        if (detector != null) {
            return detector.output ? 15 : 0;
        }
        return 0;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float p_149727_7_, float p_149727_8_, float p_149727_9_) {
        TilePlayerDetector detector;
        TileEntity te = world.func_147438_o(x, y, z);
        TilePlayerDetector tilePlayerDetector = detector = te != null && te instanceof TilePlayerDetector ? (TilePlayerDetector)te : null;
        if (detector != null) {
            int range = detector.getRange();
            range = player.func_70093_af() ? --range : ++range;
            if (range > 10) {
                range = 1;
            }
            if (range < 1) {
                range = 10;
            }
            detector.setRange(range);
            if (world.field_72995_K) {
                player.func_145747_a(new ChatComponentTranslation("msg.range.txt", new Object[0]).func_150257_a((IChatComponent)new ChatComponentText(" " + range)));
            }
        }
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        world.func_147459_d(x - 1, y, z, world.func_147439_a(x, y, z));
        world.func_147459_d(x + 1, y, z, world.func_147439_a(x, y, z));
        world.func_147459_d(x, y - 1, z, world.func_147439_a(x, y, z));
        world.func_147459_d(x, y + 1, z, world.func_147439_a(x, y, z));
        world.func_147459_d(x, y, z - 1, world.func_147439_a(x, y, z));
        world.func_147459_d(x, y, z + 1, world.func_147439_a(x, y, z));
    }
}

