/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities;

import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.draconicevolution.common.handler.BalanceConfigHandler;
import com.brandon3055.draconicevolution.common.tileentities.TileObjectSync;
import com.brandon3055.draconicevolution.common.utills.EnergyStorage;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;

public class TileGrinder
extends TileObjectSync
implements ISidedInventory,
IEnergyReceiver {
    public int meta = -1;
    List<EntityLiving> killList;
    AxisAlignedBB killBox;
    int tick = 0;
    public double centreX;
    public double centreY = -1.0;
    public double centreZ;
    private ItemStack[] items;
    public int burnTime = 1;
    public int burnTimeRemaining = 0;
    public boolean disabled = false;
    private boolean disabledCach = false;
    public boolean hasPower = false;
    public boolean hasPowerCach = false;
    private boolean readyNext = false;
    public EnergyStorage internalGenBuffer = new EnergyStorage(BalanceConfigHandler.grinderInternalEnergyBufferSize, BalanceConfigHandler.grinderMaxReceive, 0);
    public EnergyStorage externalInputBuffer = new EnergyStorage(BalanceConfigHandler.grinderExternalEnergyBufferSize, BalanceConfigHandler.grinderMaxReceive, 0);
    public int energyPerKill = BalanceConfigHandler.grinderEnergyPerKill;
    private ItemStack diamondSword;
    public static FakePlayer fakePlayer;

    public void updateVariables() {
        if (this.meta == -1) {
            this.meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.centreY == -1.0) {
            switch (this.meta) {
                case 0: {
                    this.centreX = (double)this.field_145851_c + 0.5;
                    this.centreY = (double)this.field_145848_d + 0.5;
                    this.centreZ = (double)this.field_145849_e + 0.5 - 5.0;
                    break;
                }
                case 1: {
                    this.centreX = (double)this.field_145851_c + 0.5 + 5.0;
                    this.centreY = (double)this.field_145848_d + 0.5;
                    this.centreZ = (double)this.field_145849_e + 0.5;
                    break;
                }
                case 2: {
                    this.centreX = (double)this.field_145851_c + 0.5;
                    this.centreY = (double)this.field_145848_d + 0.5;
                    this.centreZ = (double)this.field_145849_e + 0.5 + 5.0;
                    break;
                }
                case 3: {
                    this.centreX = (double)this.field_145851_c + 0.5 - 5.0;
                    this.centreY = (double)this.field_145848_d + 0.5;
                    this.centreZ = (double)this.field_145849_e + 0.5;
                }
            }
        }
    }

    public TileGrinder() {
        this.items = new ItemStack[1];
        this.diamondSword = new ItemStack(Items.field_151048_u);
        if (BalanceConfigHandler.grinderShouldUseLooting) {
            this.diamondSword.func_77966_a(Enchantment.field_77335_o, 3);
        }
    }

    public void func_145845_h() {
        this.updateVariables();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.hasPower = this.getActiveBuffer().getEnergyStored() >= this.energyPerKill;
        int burnSpeed = 2;
        int EPBT = 10;
        if (this.burnTimeRemaining > 0 && this.internalGenBuffer.getEnergyStored() < this.internalGenBuffer.getMaxEnergyStored()) {
            this.burnTimeRemaining -= burnSpeed;
            this.internalGenBuffer.setEnergyStored(this.internalGenBuffer.getEnergyStored() + Math.min(burnSpeed * EPBT, this.internalGenBuffer.getMaxEnergyStored() - this.internalGenBuffer.getEnergyStored()));
        } else if (this.burnTimeRemaining <= 0) {
            this.tryRefuel();
        }
        if (this.readyNext && !this.disabled && this.getActiveBuffer().getEnergyStored() >= this.energyPerKill && this.killNextEntity()) {
            this.getActiveBuffer().modifyEnergyStored(-this.energyPerKill);
        }
        if (this.tick % 100 == 0) {
            this.readyNext = true;
        }
        this.detectAndSendChanges(this.tick % 500 == 0);
        ++this.tick;
    }

    public EnergyStorage getActiveBuffer() {
        return this.isExternallyPowered() ? this.externalInputBuffer : this.internalGenBuffer;
    }

    public boolean isExternallyPowered() {
        return this.externalInputBuffer.getEnergyStored() > this.energyPerKill;
    }

    public void tryRefuel() {
        int itemBurnTime;
        if (this.burnTimeRemaining > 0 || this.internalGenBuffer.getEnergyStored() >= this.internalGenBuffer.getMaxEnergyStored()) {
            return;
        }
        if (this.items[0] != null && this.items[0].field_77994_a > 0 && (itemBurnTime = TileGrinder.getItemBurnTime(this.items[0])) > 0) {
            --this.items[0].field_77994_a;
            if (this.items[0].field_77994_a == 0) {
                this.items[0] = this.items[0].func_77973_b().getContainerItem(this.items[0]);
            }
            this.burnTime = itemBurnTime;
            this.burnTimeRemaining = itemBurnTime;
        }
    }

    public boolean killNextEntity() {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (fakePlayer == null) {
            fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.field_145850_b), (GameProfile)new GameProfile(UUID.fromString("5b5689b9-e43d-4282-a42a-dc916f3616b7"), "[Draconic-Evolution]"));
        }
        if (BalanceConfigHandler.grinderShouldUseLooting && (fakePlayer.func_70694_bm() == null || !ItemStack.func_77989_b((ItemStack)fakePlayer.func_70694_bm(), (ItemStack)this.diamondSword))) {
            fakePlayer.func_70062_b(0, this.diamondSword);
        }
        this.killBox = AxisAlignedBB.func_72330_a((double)(this.centreX - 4.5), (double)(this.centreY - 4.5), (double)(this.centreZ - 4.5), (double)(this.centreX + 4.5), (double)(this.centreY + 4.5), (double)(this.centreZ + 4.5));
        this.killList = this.field_145850_b.func_72872_a(EntityLiving.class, this.killBox);
        List xp = this.field_145850_b.func_72872_a(EntityXPOrb.class, this.killBox.func_72314_b(4.0, 4.0, 4.0));
        for (EntityXPOrb orb : xp) {
            if (orb.field_70531_b >= 5400) continue;
            orb.field_70531_b = 5400;
        }
        if (this.killList.size() > 0) {
            EntityLiving mob = this.killList.get(this.field_145850_b.field_73012_v.nextInt(this.killList.size()));
            if (mob.func_70089_S()) {
                mob.func_70097_a(DamageSource.func_76365_a((EntityPlayer)fakePlayer), 50000.0f);
                this.readyNext = true;
                return true;
            }
            this.readyNext = true;
            return false;
        }
        this.readyNext = false;
        return false;
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150376_bx) {
                return 150;
            }
            if (block.func_149688_o() == Material.field_151575_d) {
                return 300;
            }
            if (block == Blocks.field_150402_ci) {
                return 16000;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).func_77861_e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).func_150932_j().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).func_77842_f().equals("WOOD")) {
            return 200;
        }
        if (item == Items.field_151055_y) {
            return 100;
        }
        if (item == Items.field_151044_h) {
            return 1600;
        }
        if (item == Items.field_151129_at) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)Blocks.field_150345_g)) {
            return 100;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return GameRegistry.getFuelValue((ItemStack)stack);
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.items[i];
    }

    public ItemStack func_70298_a(int i, int count) {
        ItemStack itemstack = this.func_70301_a(i);
        if (itemstack != null) {
            if (itemstack.field_77994_a <= count) {
                this.func_70299_a(i, null);
            } else {
                itemstack = itemstack.func_77979_a(count);
                if (itemstack.field_77994_a == 0) {
                    this.func_70299_a(i, null);
                }
            }
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack item = this.func_70301_a(i);
        if (item != null) {
            this.func_70299_a(i, null);
        }
        return item;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.items[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.4) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return TileGrinder.getItemBurnTime(stack) > 0;
    }

    public int[] func_94128_d(int var1) {
        return new int[1];
    }

    public boolean func_102007_a(int var1, ItemStack var2, int var3) {
        return true;
    }

    public boolean func_102008_b(int var1, ItemStack var2, int var3) {
        return false;
    }

    public void func_145841_b(NBTTagCompound compound) {
        NBTTagCompound[] tag = new NBTTagCompound[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            tag[i] = new NBTTagCompound();
            if (this.items[i] != null) {
                tag[i] = this.items[i].func_77955_b(tag[i]);
            }
            compound.func_74782_a("Item" + i, (NBTBase)tag[i]);
        }
        compound.func_74757_a("Disabled", this.disabled);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("BurnTimeRemaining", this.burnTimeRemaining);
        this.externalInputBuffer.writeToNBT(compound, "ExternalBuffer");
        this.internalGenBuffer.writeToNBT(compound, "InternalBuffer");
        super.func_145841_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        NBTTagCompound[] tag = new NBTTagCompound[this.items.length];
        for (int i = 0; i < this.items.length; ++i) {
            tag[i] = compound.func_74775_l("Item" + i);
            this.items[i] = ItemStack.func_77949_a((NBTTagCompound)tag[i]);
        }
        this.disabled = compound.func_74767_n("Disabled");
        this.burnTime = compound.func_74762_e("BurnTime");
        this.burnTimeRemaining = compound.func_74762_e("BurnTimeRemaining");
        this.externalInputBuffer.readFromNBT(compound, "ExternalBuffer");
        this.internalGenBuffer.readFromNBT(compound, "InternalBuffer");
        super.func_145839_a(compound);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receiveObjectFromServer(int index, Object object) {
        if (index == 0 && this.disabled != (Boolean)object) {
            this.disabled = (Boolean)object;
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (this.hasPower != (Boolean)object) {
            this.hasPower = (Boolean)object;
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private void detectAndSendChanges(boolean sendAnyway) {
        if (this.disabledCach != this.disabled || sendAnyway) {
            this.disabledCach = (Boolean)this.sendObjectToClient((byte)6, 0, this.disabled);
        }
        if (this.hasPowerCach != this.hasPower || sendAnyway) {
            this.hasPowerCach = (Boolean)this.sendObjectToClient((byte)6, 1, this.hasPower);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.externalInputBuffer.receiveEnergy(maxReceive, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.externalInputBuffer.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.externalInputBuffer.getMaxEnergyStored();
    }

    public EnergyStorage getInternalBuffer() {
        return this.internalGenBuffer;
    }
}

