/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.tools;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.brandon3055.brandonscore.common.utills.InfoHelper;
import com.brandon3055.brandonscore.common.utills.ItemNBTHelper;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.handler.ConfigHandler;
import com.brandon3055.draconicevolution.common.items.ItemDE;
import com.brandon3055.draconicevolution.common.lib.References;
import com.brandon3055.draconicevolution.common.tileentities.TileDislocatorInhibitor;
import com.brandon3055.draconicevolution.common.utills.IConfigurableItem;
import com.brandon3055.draconicevolution.common.utills.InventoryUtils;
import com.brandon3055.draconicevolution.common.utills.ItemConfigField;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.gtnewhorizon.gtnhlib.GTNHLib;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerPickupXpEvent;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class Magnet
extends ItemDE
implements IBauble,
IConfigurableItem {
    private IIcon draconium;
    private IIcon awakened;

    public Magnet() {
        this.func_77655_b("magnet");
        this.func_77637_a(DraconicEvolution.tabBlocksItems);
        this.func_77625_d(1);
        ModItems.register(this);
    }

    @Override
    public void func_94581_a(IIconRegister iconRegister) {
        this.draconium = iconRegister.func_94245_a(References.RESOURCESPREFIX + "magnetWyvern");
        this.awakened = iconRegister.func_94245_a(References.RESOURCESPREFIX + "magnetDraconic");
    }

    public IIcon func_77617_a(int dmg) {
        return dmg == 0 ? this.draconium : this.awakened;
    }

    public boolean func_77614_k() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs p_150895_2_, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
    }

    @Override
    public String func_77667_c(ItemStack itemStack) {
        return super.func_77667_c(itemStack) + (itemStack.func_77960_j() == 0 ? ".wyvern" : ".draconic");
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return Magnet.isEnabled(stack);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean hotbar) {
        EntityPlayer closestPlayer;
        EntityPlayer player;
        block10: {
            block9: {
                if (entity.field_70173_aa % 5 != 0 || !(entity instanceof EntityPlayer)) break block9;
                player = (EntityPlayer)entity;
                if (Magnet.isEnabled(stack)) break block10;
            }
            return;
        }
        if (IConfigurableItem.ProfileHelper.getBoolean(stack, "MagnetSneak", true) && entity.func_70093_af()) {
            return;
        }
        int range = stack.func_77960_j() == 0 ? 8 : 32;
        List items = world.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v).func_72314_b((double)range, (double)range, (double)range));
        double playerEyesPos = player.field_70163_u + (double)(world.field_72995_K ? player.func_70047_e() - player.getDefaultEyeHeight() : player.func_70047_e());
        boolean skipPlayerCheck = world.field_73010_i.size() < 2;
        SelfPickUpMode selfPickupStatus = Magnet.getSelfPickupStatus(stack);
        boolean playSound = false;
        for (EntityItem item : items) {
            String name;
            if (item.func_92059_d() == null || ModHelper.isAE2EntityFloatingItem(item) || TileDislocatorInhibitor.isBlockedByInhibitor(world, item) || ConfigHandler.itemDislocatorBlacklistMap.containsKey(name = Item.field_150901_e.func_148750_c((Object)item.func_92059_d().func_77973_b())) && (ConfigHandler.itemDislocatorBlacklistMap.get(name) == -1 || ConfigHandler.itemDislocatorBlacklistMap.get(name).intValue() == item.func_92059_d().func_77960_j()) || !skipPlayerCheck && ((closestPlayer = world.func_72890_a((Entity)item, (double)range)) == null || closestPlayer != player)) continue;
            boolean doMove = true;
            if (ModHelper.isHodgepodgeLoaded && selfPickupStatus != SelfPickUpMode.ALWAYS) {
                boolean isOwnDrop = item.func_145800_j() != null && item.func_145800_j().equals(player.func_70005_c_());
                boolean bl = doMove = !isOwnDrop || selfPickupStatus == SelfPickUpMode.DELAY && item.field_145804_b <= 0;
            }
            if (!doMove) continue;
            playSound = true;
            item.field_145804_b = 0;
            item.field_70159_w = 0.0;
            item.field_70181_x = 0.0;
            item.field_70179_y = 0.0;
            item.func_70107_b(player.field_70165_t - 0.2 + world.field_73012_v.nextDouble() * 0.4, playerEyesPos - 0.62, player.field_70161_v - 0.2 + world.field_73012_v.nextDouble() * 0.4);
        }
        if (playSound && !ConfigHandler.itemDislocatorDisableSound) {
            world.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 2.0f));
        }
        if (!world.field_72995_K) {
            List xp = world.func_72872_a(EntityXPOrb.class, AxisAlignedBB.func_72330_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v).func_72314_b((double)range, (double)range, (double)range));
            for (EntityXPOrb orb : xp) {
                if (orb.field_70532_c != 0 || !orb.func_70089_S() || !skipPlayerCheck && ((closestPlayer = world.func_72890_a((Entity)orb, (double)range)) == null || closestPlayer != player) || MinecraftForge.EVENT_BUS.post((Event)new PlayerPickupXpEvent(player, orb))) continue;
                world.func_72956_a((Entity)player, "random.orb", 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f));
                player.func_71001_a((Entity)orb, 1);
                player.func_71023_q(orb.field_70530_e);
                orb.func_70106_y();
            }
        }
    }

    public static boolean isEnabled(ItemStack itemStack) {
        if (ItemNBTHelper.verifyExistance((ItemStack)itemStack, (String)"MagnetEnabled")) {
            NBTTagCompound nbt = itemStack.func_77978_p();
            boolean enabled = nbt.func_74767_n("MagnetEnabled");
            IConfigurableItem.ProfileHelper.setBoolean(itemStack, "Enabled", enabled);
            nbt.func_82580_o("MagnetEnabled");
            return enabled;
        }
        return IConfigurableItem.ProfileHelper.getBoolean(itemStack, "Enabled", false);
    }

    public static void toggle(ItemStack itemStack) {
        boolean enabled = Magnet.isEnabled(itemStack);
        IConfigurableItem.ProfileHelper.setBoolean(itemStack, "Enabled", !enabled);
    }

    public static void setStatus(ItemStack itemStack, boolean status) {
        IConfigurableItem.ProfileHelper.setBoolean(itemStack, "Enabled", status);
    }

    public static String getStatusString(ItemStack itemStack) {
        String status = Magnet.isEnabled(itemStack) ? EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"info.de.statusActive.txt") : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"info.de.statusInactive.txt");
        return StatCollector.func_74838_a((String)"info.de.status.txt") + ": " + status;
    }

    public static short getSelfPickupStatusShort(ItemStack itemStack) {
        return IConfigurableItem.ProfileHelper.getShort(itemStack, "EnabledSelfPickup", (short)0);
    }

    private static SelfPickUpMode getSelfPickupStatus(ItemStack itemStack) {
        short mode = Magnet.getSelfPickupStatusShort(itemStack);
        return SelfPickUpMode.values()[mode];
    }

    public static void toggleSelfPickupStatus(ItemStack itemStack) {
        SelfPickUpMode mode = Magnet.getSelfPickupStatus(itemStack);
        IConfigurableItem.ProfileHelper.setShort(itemStack, "EnabledSelfPickup", (short)mode.next().ordinal());
    }

    public static void setSelfPickupStatus(ItemStack itemStack, short status) {
        IConfigurableItem.ProfileHelper.setShort(itemStack, "EnabledSelfPickup", status);
    }

    public static String getSelfPickupStatusString(ItemStack itemStack) {
        String status;
        switch (Magnet.getSelfPickupStatus(itemStack)) {
            case DELAY: {
                status = EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"info.de.selfPickupDelay.txt");
                break;
            }
            case NEVER: {
                status = EnumChatFormatting.RED + StatCollector.func_74838_a((String)"info.de.selfPickupNever.txt");
                break;
            }
            default: {
                status = EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"info.de.selfPickupAlways.txt");
            }
        }
        return StatCollector.func_74838_a((String)"info.de.selfPickup.txt") + ": " + status;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            Magnet.toggle(stack);
        }
        return stack;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer p_77624_2_, List list, boolean p_77624_4_) {
        list.add(StatCollector.func_74838_a((String)"info.de.shiftRightClickToActivate.txt"));
        int range = stack.func_77960_j() == 0 ? 8 : 32;
        list.add(InfoHelper.HITC() + range + InfoHelper.ITC() + " " + StatCollector.func_74838_a((String)"info.de.blockRange.txt"));
        list.add(Magnet.getStatusString(stack));
        if (ModHelper.isHodgepodgeLoaded) {
            list.add(Magnet.getSelfPickupStatusString(stack));
        }
    }

    @Optional.Method(modid="gtnhlib")
    @SideOnly(value=Side.CLIENT)
    public static void renderHUDStatusChange() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Optional<ItemStack> magnetOptional = InventoryUtils.getItemInAnyPlayerInventory((EntityPlayer)player, Magnet.class);
        magnetOptional.ifPresent(itemStack -> GTNHLib.proxy.printMessageAboveHotbar(EnumChatFormatting.GOLD + Magnet.getStatusString(itemStack), 60, true, true));
    }

    @Optional.Method(modid="gtnhlib")
    @SideOnly(value=Side.CLIENT)
    public static void renderHUDSelfPickupStatusChange() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        Optional<ItemStack> magnetOptional = InventoryUtils.getItemInAnyPlayerInventory((EntityPlayer)player, Magnet.class);
        magnetOptional.ifPresent(itemStack -> GTNHLib.proxy.printMessageAboveHotbar(EnumChatFormatting.GOLD + Magnet.getSelfPickupStatusString(itemStack), 60, true, true));
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.UNIVERSAL;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        World world = player.field_70170_p;
        this.func_77663_a(itemstack, world, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public List<ItemConfigField> getFields(ItemStack stack, int slot) {
        ArrayList<ItemConfigField> fields = new ArrayList<ItemConfigField>();
        fields.add(new ItemConfigField(6, slot, "Enabled").readFromItem(stack, false));
        fields.add(new ItemConfigField(6, slot, "MagnetSneak").readFromItem(stack, true));
        return fields;
    }

    @Override
    public boolean hasProfiles() {
        return false;
    }

    private static enum SelfPickUpMode {
        ALWAYS,
        DELAY,
        NEVER;


        public SelfPickUpMode next() {
            SelfPickUpMode[] values = SelfPickUpMode.values();
            return values[(this.ordinal() + 1) % values.length];
        }
    }
}

