/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import com.brandon3055.draconicevolution.client.handler.ResourceHandler;
import com.brandon3055.draconicevolution.client.model.ModelReactorStabilizerCore;
import com.brandon3055.draconicevolution.client.model.ModelReactorStabilizerRing;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorStabilizer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderTileReactorStabilizer
extends TileEntitySpecialRenderer {
    public static ModelReactorStabilizerRing modelStabilizerRing = new ModelReactorStabilizerRing();
    public static ModelReactorStabilizerCore modelStabilizerCore = new ModelReactorStabilizerCore();

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTick) {
        if (!(tile instanceof TileReactorStabilizer)) {
            return;
        }
        TileReactorStabilizer stabilizer = (TileReactorStabilizer)tile;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        RenderTileReactorStabilizer.renderCore(stabilizer, partialTick);
        GL11.glPopMatrix();
    }

    public static void renderCore(TileReactorStabilizer stabilizer, float partialTick) {
        GL11.glPushMatrix();
        float scale = 0.0625f;
        float coreRotation = stabilizer.coreRotation + partialTick * stabilizer.coreSpeed;
        float ringRotation = stabilizer.ringRotation + partialTick * stabilizer.ringSpeed;
        int angle = 90;
        ForgeDirection axis = stabilizer.facing;
        switch (stabilizer.facing) {
            case DOWN: {
                axis = ForgeDirection.WEST;
                break;
            }
            case SOUTH: {
                angle = 180;
                axis = ForgeDirection.EAST;
                break;
            }
            case UP: {
                axis = ForgeDirection.EAST;
                break;
            }
            case WEST: {
                axis = ForgeDirection.UP;
                break;
            }
            case EAST: {
                axis = ForgeDirection.DOWN;
            }
        }
        if (stabilizer.facing != ForgeDirection.NORTH) {
            GL11.glRotated((double)angle, (double)axis.offsetX, (double)axis.offsetY, (double)axis.offsetZ);
        }
        ResourceHandler.bindResource("textures/models/reactorStabilizerCore.png");
        modelStabilizerCore.func_78088_a(null, coreRotation, stabilizer.modelIllumination, 0.0f, 0.0f, 0.0f, scale);
        ResourceHandler.bindResource("textures/models/reactorStabilizerRing.png");
        GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glTranslated((double)0.0, (double)-0.58, (double)0.0);
        GL11.glScaled((double)0.95, (double)0.95, (double)0.95);
        GL11.glRotatef((float)ringRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        modelStabilizerRing.func_78088_a(null, -70.0f, stabilizer.modelIllumination, 0.0f, 0.0f, 0.0f, scale);
        GL11.glPopMatrix();
    }
}

