/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities;

import com.brandon3055.draconicevolution.client.handler.ParticleHandler;
import com.brandon3055.draconicevolution.client.render.particle.ParticleCustom;
import com.brandon3055.draconicevolution.client.render.particle.Particles;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyStorageCore;
import com.brandon3055.draconicevolution.integration.computers.IDEPeripheral;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileParticleGenerator
extends TileEntity
implements IDEPeripheral {
    public static final int MAXIMUM_PARTICLE_INDEX = 3;
    public boolean isParticlesEnabled = true;
    public int red = 0;
    public int green = 0;
    public int blue = 0;
    public int randomRed = 0;
    public int randomGreen = 0;
    public int randomBlue = 0;
    public float motionX = 0.0f;
    public float motionY = 0.0f;
    public float motionZ = 0.0f;
    public float randomMotionX = 0.0f;
    public float randomMotionY = 0.0f;
    public float randomMotionZ = 0.0f;
    public float scale = 1.0f;
    public float randomScale = 0.0f;
    public int life = 100;
    public int randomLife = 0;
    public float spawnX = 0.0f;
    public float spawnY = 0.0f;
    public float spawnZ = 0.0f;
    public float randomSpawnX = 0.0f;
    public float randomSpawnY = 0.0f;
    public float randomSpawnZ = 0.0f;
    public int page = 1;
    public int fade = 0;
    public int spawnRate = 1;
    public boolean canParticleCollide = false;
    public int selectedParticle = 1;
    public float gravity = 0.0f;
    public boolean isActive = true;
    public boolean hasRedstoneSignal = false;
    public boolean isInverted = false;
    MultiblockHelper.TileLocation master = new MultiblockHelper.TileLocation();
    public float rotation = 0.0f;
    public boolean isInStabilizerMode = false;
    public boolean isBeamEnabled = false;
    public boolean shouldRenderCore = false;
    public int beamRed = 0;
    public int beamGreen = 0;
    public int beamBlue = 0;
    public float beamScale = 1.0f;
    public float beamPitch = 0.0f;
    public float beamYaw = 0.0f;
    public float beamLength = 0.0f;
    public float beamRotation = 0.0f;
    private int tick = 0;

    @SideOnly(value=Side.SERVER)
    public boolean canUpdate() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        this.rotation += 0.5f;
        if (this.isInStabilizerMode) {
            this.spawnStabilizerParticle();
            return;
        }
        boolean bl = this.isActive = this.hasRedstoneSignal != this.isInverted;
        if (this.tick < this.spawnRate || !this.isActive || !this.isParticlesEnabled) {
            ++this.tick;
            return;
        }
        this.tick = 0;
        Random rand = this.field_145850_b.field_73012_v;
        float motionX = this.motionX + this.randomMotionX * rand.nextFloat();
        float motionY = this.motionY + this.randomMotionY * rand.nextFloat();
        float motionZ = this.motionZ + this.randomMotionZ * rand.nextFloat();
        float scale = this.scale + this.randomScale * rand.nextFloat();
        double spawnX = (float)this.field_145851_c + this.spawnX + this.randomSpawnX * rand.nextFloat();
        double spawnY = (float)this.field_145848_d + this.spawnY + this.randomSpawnY * rand.nextFloat();
        double spawnZ = (float)this.field_145849_e + this.spawnZ + this.randomSpawnZ * rand.nextFloat();
        ParticleCustom particle = new ParticleCustom(this.field_145850_b, spawnX + 0.5, spawnY + 0.5, spawnZ + 0.5, motionX, motionY, motionZ, scale, this.canParticleCollide, this.selectedParticle);
        particle.red = this.red + rand.nextInt(this.randomRed + 1);
        particle.green = this.green + rand.nextInt(this.randomGreen + 1);
        particle.blue = this.blue + rand.nextInt(this.randomBlue + 1);
        particle.maxAge = this.life + rand.nextInt(this.randomLife + 1);
        particle.fadeTime = this.fade;
        particle.fadeLength = this.fade;
        particle.gravity = this.gravity;
        ParticleHandler.spawnCustomParticle(particle, 256.0);
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnStabilizerParticle() {
        TileEnergyStorageCore core = this.getMaster();
        if (core == null || this.field_145850_b.func_82737_E() % 20L != 1L) {
            return;
        }
        double x = (double)this.field_145851_c + 0.5;
        double y = (double)this.field_145848_d + 0.5;
        double z = (double)this.field_145849_e + 0.5;
        int direction = core.field_145851_c != this.field_145851_c ? (core.field_145851_c > this.field_145851_c ? 0 : 1) : (core.field_145849_e > this.field_145849_e ? 2 : 3);
        Particles.EnergyBeamParticle particle = new Particles.EnergyBeamParticle(this.field_145850_b, x, y, z, (double)core.field_145851_c + 0.5, (double)core.field_145849_e + 0.5, direction, false);
        Particles.EnergyBeamParticle particle2 = new Particles.EnergyBeamParticle(this.field_145850_b, x, y, z, (double)core.field_145851_c + 0.5, (double)core.field_145849_e + 0.5, direction, true);
        ParticleHandler.spawnCustomParticle(particle, 60.0);
        ParticleHandler.spawnCustomParticle(particle2, 60.0);
    }

    public void toggleInverted() {
        this.isInverted = !this.isInverted;
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145841_b(NBTTagCompound compound) {
        this.master.writeToNBT(compound, "Key");
        compound.func_74757_a("StabalizerMode", this.isInStabilizerMode);
        this.getBlockNBT(compound);
        super.func_145841_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.master.readFromNBT(compound, "Key");
        this.isInStabilizerMode = compound.func_74767_n("StabalizerMode");
        this.setBlockNBT(compound);
        super.func_145839_a(compound);
    }

    public TileEnergyStorageCore getMaster() {
        TileEnergyStorageCore core;
        TileEntity tile = this.master.getTileEntity(this.field_145850_b);
        return tile instanceof TileEnergyStorageCore ? (core = (TileEnergyStorageCore)tile) : null;
    }

    public void setMaster(MultiblockHelper.TileLocation master) {
        this.master = master != null ? master : new MultiblockHelper.TileLocation();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void getBlockNBT(NBTTagCompound compound) {
        compound.func_74768_a("Red", this.red);
        compound.func_74768_a("Green", this.green);
        compound.func_74768_a("Blue", this.blue);
        compound.func_74768_a("RandomRed", this.randomRed);
        compound.func_74768_a("RandomGreen", this.randomGreen);
        compound.func_74768_a("RandomBlue", this.randomBlue);
        compound.func_74776_a("MotionX", this.motionX);
        compound.func_74776_a("MotionY", this.motionY);
        compound.func_74776_a("MotionZ", this.motionZ);
        compound.func_74776_a("RandomMotionX", this.randomMotionX);
        compound.func_74776_a("RandomMotionY", this.randomMotionY);
        compound.func_74776_a("RandomMotionZ", this.randomMotionZ);
        compound.func_74776_a("Scale", this.scale);
        compound.func_74776_a("RandomScale", this.randomScale);
        compound.func_74768_a("Life", this.life);
        compound.func_74768_a("RandomLife", this.randomLife);
        compound.func_74776_a("SpawnX", this.spawnX);
        compound.func_74776_a("SpawnY", this.spawnY);
        compound.func_74776_a("SpawnZ", this.spawnZ);
        compound.func_74776_a("RandomSpawnX", this.randomSpawnX);
        compound.func_74776_a("RandomSpawnY", this.randomSpawnY);
        compound.func_74776_a("RandomSpawnZ", this.randomSpawnZ);
        compound.func_74768_a("Page", this.page);
        compound.func_74768_a("SpawnRate", this.spawnRate);
        compound.func_74757_a("CanCollide", this.canParticleCollide);
        compound.func_74768_a("Fade", this.fade);
        compound.func_74768_a("SelectedParticle", this.selectedParticle);
        compound.func_74776_a("Gravity", this.gravity);
        compound.func_74757_a("Active", this.isActive);
        compound.func_74757_a("Signal", this.hasRedstoneSignal);
        compound.func_74757_a("Inverted", this.isInverted);
        compound.func_74757_a("particles_enabled", this.isParticlesEnabled);
        compound.func_74757_a("beam_enabled", this.isBeamEnabled);
        compound.func_74757_a("render_core", this.shouldRenderCore);
        compound.func_74768_a("beam_red", this.beamRed);
        compound.func_74768_a("beam_green", this.beamGreen);
        compound.func_74768_a("beam_blue", this.beamBlue);
        compound.func_74776_a("beam_scale", this.beamScale);
        compound.func_74776_a("beam_pitch", this.beamPitch);
        compound.func_74776_a("beam_yaw", this.beamYaw);
        compound.func_74776_a("beam_length", this.beamLength);
        compound.func_74776_a("beam_rotation", this.beamRotation);
    }

    public void setBlockNBT(NBTTagCompound compound) {
        this.red = compound.func_74762_e("Red");
        this.green = compound.func_74762_e("Green");
        this.blue = compound.func_74762_e("Blue");
        this.randomRed = compound.func_74762_e("RandomRed");
        this.randomGreen = compound.func_74762_e("RandomGreen");
        this.randomBlue = compound.func_74762_e("RandomBlue");
        this.motionX = compound.func_74760_g("MotionX");
        this.motionY = compound.func_74760_g("MotionY");
        this.motionZ = compound.func_74760_g("MotionZ");
        this.randomMotionX = compound.func_74760_g("RandomMotionX");
        this.randomMotionY = compound.func_74760_g("RandomMotionY");
        this.randomMotionZ = compound.func_74760_g("RandomMotionZ");
        this.scale = compound.func_74760_g("Scale");
        this.randomScale = compound.func_74760_g("RandomScale");
        this.life = compound.func_74762_e("Life");
        this.randomLife = compound.func_74762_e("RandomLife");
        this.spawnX = compound.func_74760_g("SpawnX");
        this.spawnY = compound.func_74760_g("SpawnY");
        this.spawnZ = compound.func_74760_g("SpawnZ");
        this.randomSpawnX = compound.func_74760_g("RandomSpawnX");
        this.randomSpawnY = compound.func_74760_g("RandomSpawnY");
        this.randomSpawnZ = compound.func_74760_g("RandomSpawnZ");
        this.page = compound.func_74762_e("Page");
        this.spawnRate = compound.func_74762_e("SpawnRate");
        this.canParticleCollide = compound.func_74767_n("CanCollide");
        this.fade = compound.func_74762_e("Fade");
        this.selectedParticle = compound.func_74762_e("SelectedParticle");
        this.gravity = compound.func_74760_g("Gravity");
        this.isActive = compound.func_74767_n("Active");
        this.hasRedstoneSignal = compound.func_74767_n("Signal");
        this.isInverted = compound.func_74767_n("Inverted");
        this.isParticlesEnabled = compound.func_74767_n("particles_enabled");
        this.isBeamEnabled = compound.func_74767_n("beam_enabled");
        this.shouldRenderCore = compound.func_74767_n("render_core");
        this.beamRed = compound.func_74762_e("beam_red");
        this.beamGreen = compound.func_74762_e("beam_green");
        this.beamBlue = compound.func_74762_e("beam_blue");
        this.beamScale = compound.func_74760_g("beam_scale");
        this.beamPitch = compound.func_74760_g("beam_pitch");
        this.beamYaw = compound.func_74760_g("beam_yaw");
        this.beamLength = compound.func_74760_g("beam_length");
        this.beamRotation = compound.func_74760_g("beam_rotation");
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 655360.0;
    }

    public static double limit(double value, double min, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static int limit(int value, int min, int max) {
        return Math.max(min, Math.min(value, max));
    }

    @Override
    public String getName() {
        return "particle_generator";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"setGeneratorProperty", "getGeneratorState", "resetGeneratorState"};
    }

    @Override
    public Object[] callMethod(String method, Object ... args) {
        if (method.startsWith("setGeneratorProperty")) {
            if (args.length != 2) {
                return new Object[]{false};
            }
            if (!(args[0] instanceof String)) {
                return new Object[]{false};
            }
            if (args[0].equals("particles_enabled") && args[1] instanceof Boolean) {
                this.isParticlesEnabled = (Boolean)args[1];
            } else if (args[0].equals("red") && args[1] instanceof Double) {
                this.red = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("green") && args[1] instanceof Double) {
                this.green = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("blue") && args[1] instanceof Double) {
                this.blue = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("random_red") && args[1] instanceof Double) {
                this.randomRed = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("random_green") && args[1] instanceof Double) {
                this.randomGreen = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("random_blue") && args[1] instanceof Double) {
                this.randomBlue = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("motion_x") && args[1] instanceof Double) {
                this.motionX = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("motion_y") && args[1] instanceof Double) {
                this.motionY = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("motion_z") && args[1] instanceof Double) {
                this.motionZ = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("random_motion_x") && args[1] instanceof Double) {
                this.randomMotionX = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("random_motion_y") && args[1] instanceof Double) {
                this.randomMotionY = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("random_motion_z") && args[1] instanceof Double) {
                this.randomMotionZ = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("scale") && args[1] instanceof Double) {
                this.scale = (float)TileParticleGenerator.limit((Double)args[1], 0.01f, 50.0);
            } else if (args[0].equals("random_scale") && args[1] instanceof Double) {
                this.randomScale = (float)TileParticleGenerator.limit((Double)args[1], 0.01f, 50.0);
            } else if (args[0].equals("life") && args[1] instanceof Double) {
                this.life = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 1000);
            } else if (args[0].equals("random_life") && args[1] instanceof Double) {
                this.randomLife = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 1000);
            } else if (args[0].equals("spawn_x") && args[1] instanceof Double) {
                this.spawnX = (float)TileParticleGenerator.limit((Double)args[1], -50.0, 50.0);
            } else if (args[0].equals("spawn_y") && args[1] instanceof Double) {
                this.spawnY = (float)TileParticleGenerator.limit((Double)args[1], -50.0, 50.0);
            } else if (args[0].equals("spawn_z") && args[1] instanceof Double) {
                this.spawnZ = (float)TileParticleGenerator.limit((Double)args[1], -50.0, 50.0);
            } else if (args[0].equals("random_spawn_x") && args[1] instanceof Double) {
                this.randomSpawnX = (float)TileParticleGenerator.limit((Double)args[1], -50.0, 50.0);
            } else if (args[0].equals("random_spawn_y") && args[1] instanceof Double) {
                this.randomSpawnY = (float)TileParticleGenerator.limit((Double)args[1], -50.0, 50.0);
            } else if (args[0].equals("random_spawn_z") && args[1] instanceof Double) {
                this.randomSpawnZ = (float)TileParticleGenerator.limit((Double)args[1], -50.0, 50.0);
            } else if (args[0].equals("fade") && args[1] instanceof Double) {
                this.fade = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 100);
            } else if (args[0].equals("spawn_rate") && args[1] instanceof Double) {
                this.spawnRate = TileParticleGenerator.limit(((Double)args[1]).intValue(), 1, 200);
            } else if (args[0].equals("collide") && args[1] instanceof Boolean) {
                this.canParticleCollide = (Boolean)args[1];
            } else if (args[0].equals("selected_particle") && args[1] instanceof Double) {
                this.selectedParticle = TileParticleGenerator.limit(((Double)args[1]).intValue(), 1, 3);
            } else if (args[0].equals("gravity") && args[1] instanceof Double) {
                this.gravity = (float)TileParticleGenerator.limit((Double)args[1], -5.0, 5.0);
            } else if (args[0].equals("beam_enabled") && args[1] instanceof Boolean) {
                this.isBeamEnabled = (Boolean)args[1];
            } else if (args[0].equals("render_core") && args[1] instanceof Boolean) {
                this.shouldRenderCore = (Boolean)args[1];
            } else if (args[0].equals("beam_red") && args[1] instanceof Double) {
                this.beamRed = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("beam_green") && args[1] instanceof Double) {
                this.beamGreen = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("beam_blue") && args[1] instanceof Double) {
                this.beamBlue = TileParticleGenerator.limit(((Double)args[1]).intValue(), 0, 255);
            } else if (args[0].equals("beam_scale") && args[1] instanceof Double) {
                this.beamScale = (float)TileParticleGenerator.limit((Double)args[1], -0.0, 5.0);
            } else if (args[0].equals("beam_pitch") && args[1] instanceof Double) {
                this.beamPitch = (float)TileParticleGenerator.limit((Double)args[1], -180.0, 180.0);
            } else if (args[0].equals("beam_yaw") && args[1] instanceof Double) {
                this.beamYaw = (float)TileParticleGenerator.limit((Double)args[1], -180.0, 180.0);
            } else if (args[0].equals("beam_length") && args[1] instanceof Double) {
                this.beamLength = (float)TileParticleGenerator.limit((Double)args[1], -0.0, 320.0);
            } else if (args[0].equals("beam_rotation") && args[1] instanceof Double) {
                this.beamRotation = (float)TileParticleGenerator.limit((Double)args[1], -1.0, 1.0);
            } else {
                return new Object[]{false};
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return new Object[]{true};
        }
        if (method.startsWith("getGeneratorState")) {
            HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>();
            map.put("particles_enabled", Boolean.valueOf(this.isParticlesEnabled));
            map.put("red", Integer.valueOf(this.red));
            map.put("green", Integer.valueOf(this.green));
            map.put("blue", Integer.valueOf(this.blue));
            map.put("random_red", Integer.valueOf(this.randomRed));
            map.put("random_green", Integer.valueOf(this.randomGreen));
            map.put("random_blue", Integer.valueOf(this.randomBlue));
            map.put("motion_x", Float.valueOf(this.motionX));
            map.put("motion_y", Float.valueOf(this.motionY));
            map.put("motion_z", Float.valueOf(this.motionZ));
            map.put("random_motion_x", Float.valueOf(this.randomMotionX));
            map.put("random_motion_y", Float.valueOf(this.randomMotionY));
            map.put("random_motion_z", Float.valueOf(this.randomMotionZ));
            map.put("scale", Float.valueOf(this.scale));
            map.put("random_scale", Float.valueOf(this.randomScale));
            map.put("life", Integer.valueOf(this.life));
            map.put("random_life", Integer.valueOf(this.randomLife));
            map.put("spawn_x", Float.valueOf(this.spawnX));
            map.put("spawn_y", Float.valueOf(this.spawnY));
            map.put("spawn_z", Float.valueOf(this.spawnZ));
            map.put("random_spawn_x", Float.valueOf(this.randomSpawnX));
            map.put("random_spawn_y", Float.valueOf(this.randomSpawnY));
            map.put("random_spawn_z", Float.valueOf(this.randomSpawnZ));
            map.put("fade", Integer.valueOf(this.fade));
            map.put("spawn_rate", Integer.valueOf(this.spawnRate));
            map.put("collide", Boolean.valueOf(this.canParticleCollide));
            map.put("selected_particle", Integer.valueOf(this.selectedParticle));
            map.put("gravity", Float.valueOf(this.gravity));
            map.put("beam_enabled", Boolean.valueOf(this.isBeamEnabled));
            map.put("render_core", Boolean.valueOf(this.shouldRenderCore));
            map.put("beam_red", Integer.valueOf(this.beamRed));
            map.put("beam_green", Integer.valueOf(this.beamGreen));
            map.put("beam_blue", Integer.valueOf(this.beamBlue));
            map.put("beam_scale", Float.valueOf(this.beamScale));
            map.put("beam_pitch", Float.valueOf(this.beamPitch));
            map.put("beam_yaw", Float.valueOf(this.beamYaw));
            map.put("beam_length", Float.valueOf(this.beamLength));
            map.put("beam_rotation", Float.valueOf(this.beamRotation));
            return new Object[]{map};
        }
        if (method.startsWith("resetGeneratorState")) {
            this.isParticlesEnabled = true;
            this.red = 0;
            this.green = 0;
            this.blue = 0;
            this.randomRed = 0;
            this.randomGreen = 0;
            this.randomBlue = 0;
            this.motionX = 0.0f;
            this.motionY = 0.0f;
            this.motionZ = 0.0f;
            this.randomMotionX = 0.0f;
            this.randomMotionY = 0.0f;
            this.randomMotionZ = 0.0f;
            this.scale = 1.0f;
            this.randomScale = 0.0f;
            this.life = 100;
            this.randomLife = 0;
            this.spawnX = 0.0f;
            this.spawnY = 0.0f;
            this.spawnZ = 0.0f;
            this.randomSpawnX = 0.0f;
            this.randomSpawnY = 0.0f;
            this.randomSpawnZ = 0.0f;
            this.page = 1;
            this.fade = 0;
            this.spawnRate = 1;
            this.canParticleCollide = false;
            this.selectedParticle = 1;
            this.gravity = 0.0f;
            this.isBeamEnabled = false;
            this.shouldRenderCore = false;
            this.beamRed = 0;
            this.beamGreen = 0;
            this.beamBlue = 0;
            this.beamScale = 1.0f;
            this.beamPitch = 0.0f;
            this.beamYaw = 0.0f;
            this.beamLength = 0.0f;
            this.beamRotation = 0.0f;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            return new Object[]{true};
        }
        return new Object[]{0};
    }
}

