/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.container;

import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.ModItems;
import com.brandon3055.draconicevolution.common.container.ContainerDataSync;
import com.brandon3055.draconicevolution.common.inventory.GenericInventory;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorCore;
import com.brandon3055.draconicevolution.common.utills.OreDictionaryHelper;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ContainerReactor
extends ContainerDataSync {
    private static final int maximumFuelStorage = 10368;
    private static final int nuggetFuelAmount = 16;
    private static final int ingotFuelAmount = 144;
    private static final int blockFuelAmount = 1296;
    private final TileReactorCore core;
    private final EntityPlayer player;
    private final GenericInventory ioSlots = new GenericInventory(){
        private final ItemStack[] items = new ItemStack[2];

        @Override
        public ItemStack[] getStorage() {
            return this.items;
        }

        @Override
        public int func_70297_j_() {
            return 1;
        }

        @Override
        public void func_70299_a(int slot, ItemStack stack) {
            if (slot == 0) {
                Set<String> oreNames = OreDictionaryHelper.getOreNames(stack);
                if (oreNames.contains("blockDraconiumAwakened")) {
                    ((ContainerReactor)ContainerReactor.this).core.reactorFuel += stack.field_77994_a * 1296;
                } else if (oreNames.contains("ingotDraconiumAwakened")) {
                    ((ContainerReactor)ContainerReactor.this).core.reactorFuel += stack.field_77994_a * 144;
                } else if (oreNames.contains("nuggetDraconiumAwakened")) {
                    ((ContainerReactor)ContainerReactor.this).core.reactorFuel += stack.field_77994_a * 16;
                }
            } else {
                this.items[slot] = stack;
            }
        }

        @Override
        public void func_70296_d() {
            super.func_70296_d();
            ContainerReactor.this.core.func_70296_d();
        }
    };
    private int conversionUnitCache = -1;
    private int tempDrainFactorCache = -1;
    private int generationRateCache = -1;
    private int fieldDrainCache = -1;
    private int fuelUseRateCache = -1;
    private boolean isOfflineCache;

    public ContainerReactor(EntityPlayer player, TileReactorCore core) {
        this.core = core;
        this.player = player;
        this.isOfflineCache = core.reactorState == TileReactorCore.ReactorState.OFFLINE;
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, x, 44 + 18 * x, 198));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, x + y * 9 + 9, 44 + 18 * x, 140 + y * 18));
            }
        }
        if (core.reactorState == TileReactorCore.ReactorState.OFFLINE) {
            this.addFuelSlots();
        }
    }

    private void addFuelSlots() {
        this.func_75146_a(new SlotInsert(this.ioSlots, 0, 15, 140, this.core));
        this.func_75146_a(new SlotExtract(this.ioSlots, 1, 217, 140));
    }

    private void removeFuelSlots() {
        this.field_75151_b.removeIf(o -> o instanceof SlotExtract || o instanceof SlotInsert);
    }

    public void func_75134_a(EntityPlayer entityPlayer) {
        if (this.ioSlots.func_70301_a(1) != null && !this.player.field_70170_p.field_72995_K) {
            entityPlayer.field_70170_p.func_72838_d((Entity)new EntityItem(this.player.field_70170_p, entityPlayer.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, this.ioSlots.func_70301_a(1)));
            this.ioSlots.func_70299_a(1, null);
        }
        super.func_75134_a(entityPlayer);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void func_75142_b() {
        int fuelUseRate;
        int generationRate;
        int tempDrainFactor;
        if (this.isOfflineCache && this.core.reactorState != TileReactorCore.ReactorState.OFFLINE) {
            this.removeFuelSlots();
            this.sendObjectToClient(null, 99, 1);
        } else if (!this.isOfflineCache && this.core.reactorState == TileReactorCore.ReactorState.OFFLINE) {
            this.addFuelSlots();
            this.sendObjectToClient(null, 98, 1);
        }
        this.isOfflineCache = this.core.reactorState == TileReactorCore.ReactorState.OFFLINE;
        int conversionUnit = (int)(this.core.conversionUnit * 100.0);
        if (conversionUnit != this.conversionUnitCache) {
            this.conversionUnitCache = (Integer)this.sendObjectToClient(null, 0, conversionUnit);
        }
        if ((tempDrainFactor = (int)(this.core.tempDrainFactor * 1000.0)) != this.tempDrainFactorCache) {
            this.tempDrainFactorCache = (Integer)this.sendObjectToClient(null, 8, tempDrainFactor);
        }
        if ((generationRate = (int)this.core.generationRate) != this.generationRateCache) {
            this.generationRateCache = (Integer)this.sendObjectToClient(null, 9, generationRate);
        }
        if (this.core.fieldDrain != this.fieldDrainCache) {
            this.fieldDrainCache = (Integer)this.sendObjectToClient(null, 10, this.core.fieldDrain);
        }
        if ((fuelUseRate = (int)(this.core.fuelUseRate * 1000000.0)) != this.fuelUseRateCache) {
            this.fuelUseRateCache = (Integer)this.sendObjectToClient(null, 11, fuelUseRate);
        }
        super.func_75142_b();
    }

    @Override
    public void receiveSyncData(int index, int value) {
        if (index == 0) {
            this.core.conversionUnit = (double)value / 100.0;
        } else if (index == 8) {
            this.core.tempDrainFactor = (double)value / 1000.0;
        } else if (index == 9) {
            this.core.generationRate = value;
        } else if (index == 10) {
            this.core.fieldDrain = value;
        } else if (index == 11) {
            this.core.fuelUseRate = (double)value / 1000000.0;
        }
        if (index == 20) {
            this.core.processButtonPress(value);
        }
        if (index == 99) {
            this.removeFuelSlots();
        } else if (index == 98) {
            this.addFuelSlots();
        }
    }

    public ItemStack func_75144_a(int slot, int button, int mode, EntityPlayer player) {
        if (slot == 37 && player.field_71071_by.func_70445_o() == null) {
            if (this.core.reactorFuel / 144 >= 64) {
                int stackSize = this.core.reactorFuel / 1296;
                stackSize = Math.min(64, stackSize);
                this.ioSlots.func_70299_a(1, new ItemStack((Block)ModBlocks.draconicBlock, stackSize));
                this.core.reactorFuel -= stackSize * 1296;
            } else if (this.core.reactorFuel >= 144) {
                int stackSize = this.core.reactorFuel / 144;
                stackSize = Math.min(64, stackSize);
                this.ioSlots.func_70299_a(1, new ItemStack((Item)ModItems.draconicIngot, stackSize));
                this.core.reactorFuel -= stackSize * 144;
            } else if (this.core.reactorFuel >= 16) {
                int stackSize = this.core.reactorFuel / 16;
                this.ioSlots.func_70299_a(1, new ItemStack((Item)ModItems.nugget, stackSize, 1));
                this.core.reactorFuel -= stackSize * 16;
            } else if (this.core.convertedFuel / 144 >= 64) {
                int stackSize = this.core.convertedFuel / 1296;
                stackSize = Math.min(64, stackSize);
                this.ioSlots.func_70299_a(1, new ItemStack((Item)ModItems.chaosFragment, stackSize, 2));
                this.core.convertedFuel -= stackSize * 1296;
            } else if (this.core.convertedFuel >= 144) {
                int stackSize = this.core.convertedFuel / 144;
                stackSize = Math.min(64, stackSize);
                this.ioSlots.func_70299_a(1, new ItemStack((Item)ModItems.chaosFragment, stackSize, 1));
                this.core.convertedFuel -= stackSize * 144;
            } else if (this.core.convertedFuel >= 16) {
                int stackSize = this.core.convertedFuel / 16;
                this.ioSlots.func_70299_a(1, new ItemStack((Item)ModItems.chaosFragment, stackSize, 0));
                this.core.convertedFuel -= stackSize * 16;
            }
        }
        return super.func_75144_a(slot, button, mode, player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        return null;
    }

    public static class SlotInsert
    extends Slot {
        private int stackSizeLimit = 0;
        private final TileReactorCore core;

        public SlotInsert(IInventory inventory, int slot, int x, int y, TileReactorCore core) {
            super(inventory, slot, x, y);
            this.core = core;
        }

        public boolean func_75214_a(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            Set<String> oreNames = OreDictionaryHelper.getOreNames(stack);
            if (oreNames.contains("nuggetDraconiumAwakened")) {
                this.stackSizeLimit = (10368 - (this.core.reactorFuel + this.core.convertedFuel)) / 16;
            } else if (oreNames.contains("ingotDraconiumAwakened")) {
                this.stackSizeLimit = (10368 - (this.core.reactorFuel + this.core.convertedFuel)) / 144;
            } else if (oreNames.contains("blockDraconiumAwakened")) {
                this.stackSizeLimit = (10368 - (this.core.reactorFuel + this.core.convertedFuel)) / 1296;
            } else {
                return false;
            }
            return this.stackSizeLimit > 0;
        }

        public int func_75219_a() {
            return this.stackSizeLimit;
        }
    }

    public static class SlotExtract
    extends Slot {
        public SlotExtract(GenericInventory inventory, int slot, int x, int y) {
            super((IInventory)inventory, slot, x, y);
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }
    }
}

