/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor;

import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.client.render.particle.ParticleReactorBeam;
import com.brandon3055.draconicevolution.common.blocks.multiblock.IReactorPart;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorCore;
import com.brandon3055.draconicevolution.integration.computers.IDEPeripheral;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileReactorEnergyInjector
extends TileEntity
implements IReactorPart,
IEnergyReceiver,
IDEPeripheral {
    public float modelIllumination = 1.0f;
    public ForgeDirection facing = ForgeDirection.UP;
    public MultiblockHelper.TileLocation masterLocation = new MultiblockHelper.TileLocation();
    public boolean isValid = false;
    @SideOnly(value=Side.CLIENT)
    private ParticleReactorBeam beam;
    private IReactorPart.ComparatorMode comparatorMode = IReactorPart.ComparatorMode.TEMPERATURE;
    private int comparatorOutputCache = -1;

    public void func_145845_h() {
        int comparatorOutput;
        if (this.field_145850_b.field_72995_K && this.isValid) {
            this.updateBeam();
            return;
        }
        TileReactorCore core = this.getMaster();
        if (core != null && (comparatorOutput = core.getComparatorOutput(this.comparatorMode)) != this.comparatorOutputCache) {
            this.comparatorOutputCache = comparatorOutput;
            this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateBeam() {
        this.beam = DraconicEvolution.proxy.reactorBeam(this, this.beam, true);
    }

    public void onPlaced() {
        for (int distance = 1; distance <= 10; ++distance) {
            int targetX = this.field_145851_c + this.facing.offsetX * distance;
            int targetY = this.field_145848_d + this.facing.offsetY * distance;
            int targetZ = this.field_145849_e + this.facing.offsetZ * distance;
            TileEntity tile = this.field_145850_b.func_147438_o(targetX, targetY, targetZ);
            if (!(tile instanceof TileReactorCore)) continue;
            this.setUp(new MultiblockHelper.TileLocation(targetX, targetY, targetZ));
            return;
        }
        this.shutDown();
    }

    @Override
    public MultiblockHelper.TileLocation getMasterLocation() {
        return this.masterLocation;
    }

    @Override
    public TileReactorCore getMaster() {
        TileReactorCore core;
        TileEntity tile = this.masterLocation.getTileEntity(this.field_145850_b);
        return tile instanceof TileReactorCore ? (core = (TileReactorCore)tile) : null;
    }

    @Override
    public void setUp(MultiblockHelper.TileLocation masterLocation) {
        this.masterLocation = masterLocation;
        this.isValid = true;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void shutDown() {
        this.masterLocation = new MultiblockHelper.TileLocation();
        this.isValid = false;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean isActive() {
        return this.isValid;
    }

    @Override
    public ForgeDirection getFacing() {
        return this.facing;
    }

    @Override
    public IReactorPart.ComparatorMode getComparatorMode() {
        return this.comparatorMode;
    }

    @Override
    public void changeComparatorMode() {
        this.comparatorMode = this.comparatorMode.next();
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.masterLocation.writeToNBT(compound, "Master");
        compound.func_74768_a("Facing", this.facing.ordinal());
        compound.func_74757_a("IsValid", this.isValid);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound compound = pkt.func_148857_g();
        this.masterLocation.readFromNBT(compound, "Master");
        this.facing = ForgeDirection.getOrientation((int)compound.func_74762_e("Facing"));
        this.isValid = compound.func_74767_n("IsValid");
        super.onDataPacket(net, pkt);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.masterLocation.writeToNBT(compound, "Master");
        compound.func_74768_a("Facing", this.facing.ordinal());
        compound.func_74757_a("IsValid", this.isValid);
        compound.func_74768_a("RedstoneMode", this.comparatorMode.ordinal());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.masterLocation.readFromNBT(compound, "Master");
        this.facing = ForgeDirection.getOrientation((int)compound.func_74762_e("Facing"));
        this.isValid = compound.func_74767_n("IsValid");
        this.comparatorMode = IReactorPart.ComparatorMode.getMode(compound.func_74762_e("RedstoneMode"));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (simulate) {
            return Integer.MAX_VALUE;
        }
        TileReactorCore core = this.getMaster();
        if (core != null) {
            return core.injectEnergy(maxReceive);
        }
        return 0;
    }

    public int getEnergyStored(ForgeDirection from) {
        return 0;
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return Integer.MAX_VALUE;
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return from == this.facing.getOpposite();
    }

    @Override
    public String getName() {
        return "draconic_reactor";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getReactorInfo", "chargeReactor", "activateReactor", "stopReactor"};
    }

    @Override
    public Object[] callMethod(String methodName, Object ... args) {
        TileReactorCore core = this.getMaster();
        return core != null ? core.callMethod(methodName, args) : null;
    }
}

