/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities;

import com.brandon3055.draconicevolution.common.container.ContainerPlayerDetector;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePlayerDetectorAdvanced
extends TileEntity
implements IInventory {
    public static final int MAXIMUM_RANGE = 20;
    public static final int MINIMUM_RANGE = 1;
    private static final int scanRate = 5;
    public String[] names = new String[42];
    public boolean isInWhiteListMode = false;
    public boolean isOutputInverted = false;
    public int range = 10;
    private final ItemStack[] items;
    private int tick = 0;
    private boolean shouldOutput = false;
    private List<EntityLivingBase> entityList;

    public TilePlayerDetectorAdvanced() {
        for (int i = 0; i < this.names.length; ++i) {
            if (this.names[i] != null) continue;
            this.names[i] = "";
        }
        this.items = new ItemStack[1];
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tick >= 5) {
            this.tick = 0;
            if (this.shouldEmit()) {
                if (!this.shouldOutput) {
                    this.setShouldOutput(true);
                }
            } else if (this.shouldOutput) {
                this.setShouldOutput(false);
            }
        } else {
            ++this.tick;
        }
    }

    private boolean shouldEmit() {
        this.findEntities();
        Iterator<EntityLivingBase> iterator = this.entityList.iterator();
        if (iterator.hasNext()) {
            EntityLivingBase entity = iterator.next();
            if (!(entity instanceof EntityPlayer)) {
                return false;
            }
            String name = entity.func_70005_c_();
            return this.isInWhiteListMode == this.isPlayerListed(name) != this.isOutputInverted;
        }
        return this.isOutputInverted;
    }

    private void findEntities() {
        double startX = (double)this.field_145851_c + 0.5 - (double)this.range;
        double startY = (double)this.field_145848_d + 0.5 - (double)this.range;
        double startZ = (double)this.field_145849_e + 0.5 - (double)this.range;
        double endX = (double)this.field_145851_c + 0.5 + (double)this.range;
        double endY = (double)this.field_145848_d + 0.5 + (double)this.range;
        double endZ = (double)this.field_145849_e + 0.5 + (double)this.range;
        this.entityList = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ));
    }

    public boolean shouldOutput() {
        return this.shouldOutput;
    }

    public void setShouldOutput(boolean shouldOutputSignal) {
        this.shouldOutput = shouldOutputSignal;
        this.updateBlocks();
    }

    private void updateBlocks() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145854_h);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            this.field_145850_b.func_147441_b(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ, this.field_145854_h, direction.getOpposite().ordinal());
        }
    }

    private boolean isPlayerListed(String name) {
        if (name == null) {
            return false;
        }
        for (String listedName : this.names) {
            if (!listedName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return this.items.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.items[slot];
    }

    public ItemStack func_70298_a(int slot, int count) {
        ItemStack stack = this.items[slot];
        if (stack != null) {
            if (stack.field_77994_a <= count) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(count);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            this.func_70299_a(slot, null);
        }
        return stack;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.items[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String func_145825_b() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.4) < 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return false;
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public Container getGuiContainer(InventoryPlayer playerInventory) {
        return new ContainerPlayerDetector(playerInventory, this);
    }

    public void func_145841_b(NBTTagCompound compound) {
        int i;
        NBTTagCompound[] tag = new NBTTagCompound[this.items.length];
        for (i = 0; i < this.items.length; ++i) {
            tag[i] = new NBTTagCompound();
            if (this.items[i] != null) {
                tag[i] = this.items[i].func_77955_b(tag[i]);
            }
            compound.func_74782_a("Item" + i, (NBTBase)tag[i]);
        }
        for (i = 0; i < this.names.length; ++i) {
            String name = this.names[i] != null ? this.names[i] : "";
            compound.func_74778_a("Name_" + i, name);
        }
        compound.func_74757_a("WhiteList", this.isInWhiteListMode);
        compound.func_74757_a("Output", this.shouldOutput);
        compound.func_74768_a("Range", this.range);
        compound.func_74757_a("OutputInverted", this.isOutputInverted);
        super.func_145841_b(compound);
    }

    public void func_145839_a(NBTTagCompound compound) {
        int i;
        NBTTagCompound[] tag = new NBTTagCompound[this.items.length];
        for (i = 0; i < this.items.length; ++i) {
            tag[i] = compound.func_74775_l("Item" + i);
            this.items[i] = ItemStack.func_77949_a((NBTTagCompound)tag[i]);
        }
        for (i = 0; i < this.names.length; ++i) {
            this.names[i] = compound.func_74779_i("Name_" + i);
        }
        this.isInWhiteListMode = compound.func_74767_n("WhiteList");
        this.range = compound.func_74762_e("Range");
        this.shouldOutput = compound.func_74767_n("Output");
        this.isOutputInverted = compound.func_74767_n("OutputInverted");
        super.func_145839_a(compound);
    }
}

