/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.cpp;

import com.github.bartimaeusnek.croploadcore.MyRandom;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicDecorationCrop;
import com.github.bartimaeusnek.cropspp.items.CppItems;
import ic2.api.crops.ICropTile;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GoldfishCrop
extends BasicDecorationCrop {
    private static final String screamSoundId = "mob.ghast.scream";

    private boolean ShouldInteract(ICropTile crop, EntityPlayer player) {
        if (!ConfigValues.ILoveScreaming) {
            return true;
        }
        player.func_85030_a(screamSoundId, this.getScreamVolume(crop), this.getScreamPitch(crop));
        return true;
    }

    private float getScreamVolume(ICropTile crop) {
        return crop.getSize() >= this.maxSize() ? 5.0f : (float)crop.getSize();
    }

    private float getScreamPitch(ICropTile crop) {
        return crop.getSize() >= this.maxSize() ? 0.5f : (float)(this.maxSize() + 1 + -1 * crop.getSize());
    }

    @Override
    public int tier() {
        return 4;
    }

    public String name() {
        return "Goldfish Plant";
    }

    public String[] attributes() {
        return new String[]{"Nether", "Fish", "Food", "Bad", "Water"};
    }

    @Override
    public int growthDuration(ICropTile crop) {
        return ConfigValues.debug ? 1 : 225;
    }

    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(CppItems.Goldfisch);
    }

    public void tick(ICropTile crop) {
        if (ConfigValues.ILoveScreaming && MyRandom.intrandom((int)512, (int)0) == 42) {
            crop.getWorld().func_72908_a((double)crop.getLocation().field_71574_a, (double)crop.getLocation().field_71572_b, (double)crop.getLocation().field_71573_c, screamSoundId, this.getScreamVolume(crop), this.getScreamPitch(crop));
        }
    }

    public boolean rightclick(ICropTile crop, EntityPlayer player) {
        return this.ShouldInteract(crop, player) && crop.harvest(true);
    }

    public boolean leftclick(ICropTile crop, EntityPlayer player) {
        return this.ShouldInteract(crop, player) && crop.pick(true);
    }

    public boolean onEntityCollision(ICropTile crop, Entity entity) {
        if (!ConfigValues.ILoveScreaming) {
            return super.onEntityCollision(crop, entity);
        }
        if (entity instanceof EntityLivingBase) {
            if (entity instanceof EntityPlayer) {
                entity.func_85030_a(screamSoundId, this.getScreamVolume(crop), this.getScreamPitch(crop));
            }
            return entity.func_70051_ag();
        }
        return false;
    }

    @Override
    public List<String> getCropInformation() {
        return Collections.singletonList("Screams.");
    }

    @Override
    public ItemStack getDisplayItem() {
        return new ItemStack(CppItems.Goldfisch);
    }
}

