/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.gregtechCrops;

import com.github.bartimaeusnek.croploadcore.OreDict;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicDecorationCrop;
import gregtech.api.enums.Materials;
import ic2.api.crops.ICropTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class StonelillyCrop
extends BasicDecorationCrop {
    private String color;

    public StonelillyCrop(String color) {
        this.color = color;
    }

    @Override
    public ItemStack getDisplayItem() {
        switch (this.color) {
            case "Red": {
                return Materials.GraniteRed.getDust(9);
            }
            case "Black": {
                return Materials.GraniteBlack.getDust(9);
            }
            case "White": {
                return Materials.Marble.getDust(9);
            }
            case "Gray": {
                return Materials.Stone.getDust(9);
            }
            case "Yellow": {
                return Materials.Endstone.getDust(2);
            }
            case "Nether": {
                return Materials.Netherrack.getDust(9);
            }
        }
        return new ItemStack(Blocks.field_150347_e);
    }

    public String name() {
        return this.color + " Stonelilly";
    }

    @Override
    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        return crop.getSize() == this.maxSize() - 1 && crop.isBlockBelow(Blocks.field_150377_bs) ? 550 : 300;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canGrow(ICropTile crop) {
        if (ConfigValues.debug) {
            if (crop.getSize() >= this.maxSize()) return false;
            return true;
        }
        boolean ret = false;
        block0 : switch (crop.getSize()) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                switch (this.color) {
                    case "Red": {
                        if (!crop.isBlockBelow("stoneGraniteRed")) {
                            if (!crop.isBlockBelow("blockGranite")) return ret;
                        }
                        ret = true;
                        break block0;
                    }
                    case "Black": {
                        if (!crop.isBlockBelow("stoneGraniteBlack")) {
                            if (!crop.isBlockBelow("stoneBasalt")) return ret;
                        }
                        ret = true;
                        break block0;
                    }
                    case "White": {
                        if (!crop.isBlockBelow("blockMarble")) {
                            if (!crop.isBlockBelow("blockDiorite")) return ret;
                        }
                        ret = true;
                        break block0;
                    }
                    case "Gray": {
                        if (!crop.isBlockBelow(Blocks.field_150347_e) && !crop.isBlockBelow(Blocks.field_150348_b)) {
                            if (!crop.isBlockBelow("blockAndesite")) return ret;
                        }
                        ret = true;
                        break block0;
                    }
                    case "Yellow": {
                        if (!crop.isBlockBelow(Blocks.field_150377_bs) && !crop.isBlockBelow((Block)Blocks.field_150354_m)) {
                            if (!crop.isBlockBelow(Blocks.field_150322_A)) return ret;
                        }
                        ret = true;
                        break block0;
                    }
                    case "Nether": {
                        if (!crop.isBlockBelow(Blocks.field_150424_aL)) {
                            if (!crop.isBlockBelow(Blocks.field_150385_bj)) return ret;
                        }
                        ret = true;
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)((double)humidity * 0.8 + (double)nutrients * 1.4 + (double)air * 0.8);
    }

    public String[] attributes() {
        String[] ret = null;
        switch (this.color) {
            case "Red": {
                ret = new String[]{this.color, "Stone", "Fire"};
                break;
            }
            case "Black": {
                ret = new String[]{this.color, "Stone", "Dark"};
                break;
            }
            case "White": {
                ret = new String[]{this.color, "Stone", "Shiny"};
                break;
            }
            case "Gray": {
                ret = new String[]{this.color, "Stone", "Metal"};
                break;
            }
            case "Yellow": {
                ret = new String[]{this.color, "Stone", "Alien"};
                break;
            }
            case "Nether": {
                ret = new String[]{this.color, "Stone", "Evil"};
            }
        }
        return ret;
    }

    @Override
    public List<String> getCropInformation() {
        ArrayList<String> information = new ArrayList<String>();
        switch (this.color) {
            case "Red": {
                information.add("Needs a Block of Red Granite or Granite(Non-GT) below to fully Mature");
                break;
            }
            case "Black": {
                information.add("Needs a Block of Black Granite or Basalt below to fully Mature");
                break;
            }
            case "White": {
                information.add("Needs a Block of Marble or Diorite below to fully Mature");
                break;
            }
            case "Gray": {
                information.add("Needs a Block of Cobblestone, Stone or Andesite below to fully Mature");
                break;
            }
            case "Yellow": {
                information.add("Needs a Block of Endstone, Sand or Sandstone below to fully Mature");
                break;
            }
            case "Nether": {
                information.add("Needs a Block of Netherrack or Netherbrick below to fully Mature");
            }
        }
        information.add("Has increased Nutrient requirements (x1.4)");
        information.add("Has decreased humidity and air requirements (x0.8)");
        return information;
    }

    public ItemStack getGain(ICropTile crop) {
        ItemStack ret = null;
        switch (this.color) {
            case "Red": {
                if (crop.isBlockBelow("stoneGraniteRed")) {
                    ret = Materials.GraniteRed.getDust(9);
                }
                if (!crop.isBlockBelow("blockGranite")) break;
                ret = OreDict.ISget((String)"blockGranite");
                break;
            }
            case "Black": {
                if (crop.isBlockBelow("stoneGraniteBlack")) {
                    ret = Materials.GraniteBlack.getDust(9);
                }
                if (!crop.isBlockBelow("stoneBasalt")) break;
                ret = Materials.Basalt.getDust(9);
                break;
            }
            case "White": {
                if (crop.isBlockBelow("blockMarble")) {
                    ret = Materials.Marble.getDust(9);
                }
                if (!crop.isBlockBelow("blockDiorite")) break;
                ret = OreDict.ISget((String)"blockDiorite");
                break;
            }
            case "Gray": {
                if (crop.isBlockBelow(Blocks.field_150347_e) || crop.isBlockBelow(Blocks.field_150348_b)) {
                    ret = Materials.Stone.getDust(9);
                }
                if (!crop.isBlockBelow("blockAndesite")) break;
                ret = OreDict.ISget((String)"blockAndesite");
                break;
            }
            case "Yellow": {
                if (crop.isBlockBelow(Blocks.field_150377_bs)) {
                    ret = Materials.Endstone.getDust(2);
                }
                if (!crop.isBlockBelow((Block)Blocks.field_150354_m) && !crop.isBlockBelow(Blocks.field_150322_A)) break;
                ret = new ItemStack((Block)Blocks.field_150354_m, 4);
                break;
            }
            case "Nether": {
                if (crop.isBlockBelow(Blocks.field_150424_aL)) {
                    ret = Materials.Netherrack.getDust(9);
                }
                if (!crop.isBlockBelow(Blocks.field_150385_bj)) break;
                ret = Materials.Netherrack.getDust(9);
            }
        }
        return ret;
    }
}

