/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.GTHandler.machines;

import com.github.bartimaeusnek.cropspp.items.CppItems;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_Container_BasicTank;
import gregtech.api.gui.GT_GUIContainer_BasicTank;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.machines.basic.GT_MetaTileEntity_Pump;
import ic2.core.Ic2Items;
import ic2.core.crop.TileEntityCrop;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;

public class CropWeedPicker
extends GT_MetaTileEntity_Hatch {
    public CropWeedPicker(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{"Automatically picks Weeds", "Range = Tier", "Takes in 1A", "Needs a Weeding Trovel or a Spade in its Inventory", "Need to be supplied with 1L Lubricant per tick."}, new ITexture[0]);
    }

    public CropWeedPicker(String mName, byte mTier, String[] mDescriptionArray, ITexture[][][] mTextures) {
        super(mName, (int)mTier, 1, mDescriptionArray, mTextures);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new CropWeedPicker(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.getFluid().equals(Materials.Lubricant.getFluid(1L).getFluid()) || super.isFluidInputAllowed(aFluid);
    }

    public int getCapacity() {
        return 1000 * this.mTier;
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && (this.mInventory[aIndex] == null || GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.mInventory[aIndex])) && this.allowPutStack(this.getBaseMetaTileEntity(), aIndex, (byte)aSide, aStack);
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_BasicTank(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_BasicTank(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName());
    }

    public boolean doesFillContainers() {
        return false;
    }

    public boolean doesEmptyContainers() {
        return true;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return false;
    }

    public boolean displaysItemStack() {
        return true;
    }

    public boolean displaysStackSize() {
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (!this.getBaseMetaTileEntity().isAllowedToWork() || !GT_Utility.areStacksEqual((ItemStack)this.mInventory[0], (ItemStack)CppItems.itemSpadeStack) && !GT_Utility.areStacksEqual((ItemStack)this.mInventory[0], (ItemStack)Ic2Items.weedingTrowel) || this.getFluid().amount < 20 || !this.getBaseMetaTileEntity().isUniversalEnergyStored(GT_MetaTileEntity_Pump.getEuUsagePerTier((int)this.mTier))) {
                return;
            }
            this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(GT_MetaTileEntity_Pump.getEuUsagePerTier((int)this.mTier), true);
            this.getFluid().amount -= 20;
            int xmin = this.getBaseMetaTileEntity().getXCoord() > 0 ? this.getBaseMetaTileEntity().getXCoord() - this.mTier : this.getBaseMetaTileEntity().getXCoord() + this.mTier;
            int xmax = this.getBaseMetaTileEntity().getXCoord() > 0 ? this.getBaseMetaTileEntity().getXCoord() + this.mTier : this.getBaseMetaTileEntity().getXCoord() - this.mTier;
            int zmin = this.getBaseMetaTileEntity().getZCoord() > 0 ? this.getBaseMetaTileEntity().getZCoord() - this.mTier : this.getBaseMetaTileEntity().getZCoord() + this.mTier;
            int zmax = this.getBaseMetaTileEntity().getZCoord() > 0 ? this.getBaseMetaTileEntity().getZCoord() + this.mTier : this.getBaseMetaTileEntity().getZCoord() - this.mTier;
            for (int x = xmin; x <= xmax; ++x) {
                for (int z = zmin; z <= zmax; ++z) {
                    TileEntityCrop cropTE;
                    TileEntity possibleCrop = this.getBaseMetaTileEntity().getWorld().func_147438_o(x, (int)this.getBaseMetaTileEntity().getYCoord(), z);
                    if (!(possibleCrop instanceof TileEntityCrop) || (cropTE = (TileEntityCrop)possibleCrop).getCrop() == null) continue;
                    if (cropTE.getCrop().tier() <= 0) {
                        cropTE.reset();
                    }
                    cropTE.weedlevel = 0;
                    cropTE.updateState();
                    cropTE.func_70296_d();
                }
            }
        }
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isOverclockerUpgradable() {
        return false;
    }

    public boolean isTransformerUpgradable() {
        return false;
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isInputFacing(byte aSide) {
        return true;
    }

    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    public boolean isTeleporterCompatible() {
        return false;
    }

    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 16L;
    }

    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 64L;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public long maxSteamStore() {
        return this.maxEUStore();
    }

    public long maxAmperesIn() {
        return 1L;
    }

    public int getStackDisplaySlot() {
        return 2;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public int getTankPressure() {
        return 100;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColorIndex + 1], aSide == 0 || aSide == 1 ? TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_OUT) : TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ADV_PUMP)};
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return this.getTexturesInactive(aBaseTexture);
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ADV_PUMP), TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ADV_PUMP), TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ADV_PUMP), TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ADV_PUMP)};
    }
}

