/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.GTHandler.machines;

import com.github.bartimaeusnek.cropspp.GTHandler.CPP_UITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CropReplicator
extends GT_MetaTileEntity_BasicMachine {
    public CropReplicator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 6, new String[]{"It can replicate Crops", "It needs a Cell of UUM per crop's tier", "Takes in 6A", "Needs crop's (tier+2)/2 as Voltage level, round down (Tier 5 crop needs 7/2=~3=HV)", "Can process crops up to tier " + CropReplicator.getMaxCropTier(aTier)}, 2, 2, "Crop_Replicator.png", "", new ITexture[]{TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_SCANNER_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_SIDE_SCANNER_ACTIVE_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_SCANNER), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_SIDE_SCANNER_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_SCANNER_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_SCANNER_ACTIVE_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_SCANNER), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_FRONT_SCANNER_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_SCANNER_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_TOP_SCANNER_ACTIVE_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_SCANNER), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_TOP_SCANNER_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER_ACTIVE), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER_ACTIVE_GLOW}).glow().build()}), TextureFactory.of((ITexture[])new ITexture[]{TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER), TextureFactory.builder().addIcon(new IIconContainer[]{Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER_GLOW}).glow().build()})});
    }

    public CropReplicator(String mName, byte mTier, String[] mDescriptionArray, ITexture[][][] mTextures, String mGUIName, String mNEIName) {
        super(mName, (int)mTier, 6, mDescriptionArray, mTextures, 2, 2, mGUIName, mNEIName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new CropReplicator(this.mName, this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    public static int getMaxCropTier(int mTier) {
        return mTier * 2 - 1;
    }

    public int checkRecipe(boolean skipOC) {
        ItemStack aStack = this.getInputAt(0);
        ItemStack bStack = this.getInputAt(1);
        if (GT_Utility.areUnificationsEqual((ItemStack)aStack, (ItemStack)Materials.UUMatter.getCells(1), (boolean)true) && ItemList.IC2_Crop_Seeds.isStackEqual((Object)bStack, true, true)) {
            ItemStack helper = bStack;
            bStack = aStack;
            aStack = helper;
        }
        if (GT_Utility.areUnificationsEqual((ItemStack)bStack, (ItemStack)Materials.UUMatter.getCells(1), (boolean)true) && ItemList.IC2_Crop_Seeds.isStackEqual((Object)aStack, true, true)) {
            NBTTagCompound tNBT = aStack.func_77978_p();
            if (tNBT == null || tNBT.func_74779_i("name").isEmpty()) {
                return 0;
            }
            if (this.getOutputAt(0) != null || this.getOutputAt(1) != null) {
                return 0;
            }
            CropCard card = Crops.instance.getCropCard(tNBT.func_74779_i("owner"), tNBT.func_74779_i("name"));
            if (card.tier() > CropReplicator.getMaxCropTier(this.mTier)) {
                return 0;
            }
            if (bStack.field_77994_a < card.tier()) {
                return 1;
            }
            this.mOutputItems[0] = aStack.func_77946_l();
            this.mOutputItems[0].field_77994_a = 2;
            bStack.field_77994_a -= card.tier();
            --aStack.field_77994_a;
            this.mOutputItems[1] = Materials.Empty.getCells(card.tier());
            long power = GT_Values.V[(card.tier() + 2) / 2];
            this.calculateOverclockedNess((int)((power *= (long)this.mAmperage) - power / 10L), 12000);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1) {
            GT_Utility.doSoundAtClient((String)((String)GregTech_API.sSoundList.get(212)), (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        }
    }

    public void startProcess() {
        this.sendLoopStart((byte)1);
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        if (GT_Utility.areUnificationsEqual((ItemStack)aStack, (ItemStack)Materials.UUMatter.getCells(1), (boolean)true) || ItemList.IC2_Crop_Seeds.isStackEqual((Object)aStack, true, true)) {
            return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && (this.mInventory[aIndex] == null || GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.mInventory[aIndex])) && this.allowPutStack(this.getBaseMetaTileEntity(), aIndex, (byte)aSide, aStack);
        }
        return false;
    }

    public boolean useModularUI() {
        return true;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        super.addUIWidgets(builder, buildContext);
        builder.widget((Widget)this.createProgressBar(GT_UITextures.PROGRESSBAR_ARROW, 20, ProgressBar.Direction.RIGHT, new Pos2d(78, 24), new Size(20, 18)));
    }

    protected SlotWidget createItemInputSlot(int index, IDrawable[] backgrounds, Pos2d pos) {
        if (index == 0) {
            return (SlotWidget)super.createItemInputSlot(index, backgrounds, pos).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GT_UITextures.OVERLAY_SLOT_CANISTER});
        }
        return (SlotWidget)super.createItemInputSlot(index, backgrounds, pos).setBackground(new IDrawable[]{this.getGUITextureSet().getItemSlot(), CPP_UITextures.OVERLAY_SLOT_SEED});
    }
}

