/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.gregtechCrops;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicCrop;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import ic2.api.crops.ICropTile;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class GarnydniaCrop
extends BasicCrop {
    public String name() {
        return "Garnydinia";
    }

    public int tier() {
        return 7;
    }

    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)Math.floor((double)humidity * 0.5 + (double)nutrients * 2.0 + (double)air * 0.5);
    }

    public int stat(int n) {
        switch (n) {
            case 0: {
                return 4;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public String[] attributes() {
        return new String[]{"Shiny", "Crystal", "Red", "Yellow", "Metal"};
    }

    public int maxSize() {
        return 3;
    }

    public boolean canGrow(ICropTile iCropTile) {
        return iCropTile.getSize() < 2 || iCropTile.getSize() == 2 && this.isBlockBelow(iCropTile);
    }

    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        if (crop.getSize() == 0) {
            return 3300;
        }
        if (crop.getSize() == this.maxSize() - 1) {
            return 550;
        }
        return 300;
    }

    @Override
    public List<String> getCropInformation() {
        return Collections.singletonList("Needs a block or ore of Yellow or Red Garnet below to fully mature.");
    }

    public boolean isBlockBelow(ICropTile aCrop) {
        if (aCrop == null) {
            return false;
        }
        for (int i = 1; i < this.getrootslength(aCrop); ++i) {
            Block tBlock = aCrop.getWorld().func_147439_a(aCrop.getLocation().field_71574_a, aCrop.getLocation().field_71572_b - i, aCrop.getLocation().field_71573_c);
            if (tBlock instanceof GT_Block_Ores_Abstract) {
                Materials tMaterial;
                TileEntity tTileEntity = aCrop.getWorld().func_147438_o(aCrop.getLocation().field_71574_a, aCrop.getLocation().field_71572_b - i, aCrop.getLocation().field_71573_c);
                if (!(tTileEntity instanceof GT_TileEntity_Ores) || (tMaterial = GregTech_API.sGeneratedMaterials[((GT_TileEntity_Ores)tTileEntity).mMetaData % 1000]) == null || tMaterial == Materials._NULL) continue;
                return tMaterial == Materials.GarnetRed || tMaterial == Materials.GarnetYellow;
            }
            int tMetaID = aCrop.getWorld().func_72805_g(aCrop.getLocation().field_71574_a, aCrop.getLocation().field_71572_b - i, aCrop.getLocation().field_71573_c);
            ItemData tAssotiation = GT_OreDictUnificator.getAssociation((ItemStack)new ItemStack(tBlock, 1, tMetaID));
            if (tAssotiation != null && tAssotiation.mPrefix.toString().startsWith("ore") && (tAssotiation.mMaterial.mMaterial == Materials.GarnetRed || tAssotiation.mMaterial.mMaterial == Materials.GarnetYellow)) {
                return true;
            }
            if (tAssotiation == null || tAssotiation.mPrefix != OrePrefixes.block || tAssotiation.mMaterial.mMaterial != Materials.GarnetRed && tAssotiation.mMaterial.mMaterial != Materials.GarnetYellow) continue;
            return true;
        }
        return false;
    }

    @Override
    public String discoveredBy() {
        return "moronwmachinegun";
    }

    @Override
    public boolean canBeHarvested(ICropTile iCropTile) {
        return iCropTile.getSize() == this.maxSize();
    }

    public ItemStack getGain(ICropTile iCropTile) {
        Materials dropMat = XSTR.XSTR_INSTANCE.nextInt(100) > 50 ? Materials.GarnetRed : Materials.GarnetYellow;
        int chance = XSTR.XSTR_INSTANCE.nextInt(100);
        Object drop = chance > 95 ? GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gemExquisite, (Object)dropMat, (long)1L) : (chance > 80 && chance < 95 ? dropMat.getGems(1) : (chance == 42 ? GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushedPurified, (Object)Materials.GarnetSand, (long)1L) : (chance > 40 && chance < 80 ? dropMat.getDust(1) : (chance == 23 ? GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushedPurified, (Object)dropMat, (long)1L) : (chance > 20 && chance < 40 ? dropMat.getDustSmall(1) : (chance == 13 || chance == 17 ? GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.crushedPurified, (Object)dropMat, (long)1L) : (chance < 20 ? dropMat.getDustTiny(1) : null)))))));
        return drop;
    }

    public byte getSizeAfterHarvest(ICropTile crop) {
        return 1;
    }

    @Override
    public ItemStack getDisplayItem() {
        return Materials.GarnetRed.getGems(1);
    }
}

