/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.cpp;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicCrop;
import com.github.bartimaeusnek.cropspp.items.CppItems;
import ic2.api.crops.ICropTile;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import net.minecraft.item.ItemStack;

public class SpacePlantCrop
extends BasicCrop {
    @Override
    public ItemStack getDisplayItem() {
        return new ItemStack(CppItems.Modifier, 1, 0);
    }

    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        return 5000;
    }

    public String name() {
        return "Space Plant";
    }

    public int tier() {
        return 13;
    }

    public int stat(int n) {
        switch (n) {
            case 0: {
                return 8;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 0;
            }
        }
        return 0;
    }

    public String[] attributes() {
        return new String[]{"Alien", "Space", "Radiation", "Transform"};
    }

    public int maxSize() {
        return 4;
    }

    public boolean canGrow(ICropTile crop) {
        boolean ret = false;
        if (ConfigValues.debug) {
            boolean bl = ret = crop.getSize() < this.maxSize() - 1;
        }
        if (crop.getSize() == 3) {
            if (crop.isBlockBelow(GCBlocks.blockMoon)) {
                ret = true;
            }
        } else if (crop.getSize() < 3) {
            ret = true;
        }
        return ret;
    }

    @Override
    public List<String> getCropInformation() {
        return Collections.singletonList("Needs a block from the moon below to fully mature.");
    }

    @Override
    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == this.maxSize();
    }

    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(CppItems.Modifier, 1, 0);
    }
}

