/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.TC;

import com.github.bartimaeusnek.croploadcore.OreDict;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.abstracts.BasicThaumcraftCrop;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ShimmerleafCrop
extends BasicThaumcraftCrop {
    public ShimmerleafCrop() {
        OreDict.BSget((String)("crop" + this.name()), (CropCard)this);
    }

    public String name() {
        return "Shimmerleaf";
    }

    public String[] attributes() {
        return new String[]{"Magic", "Silver", "Toxic"};
    }

    @Override
    public int growthDuration(ICropTile crop) {
        int r = 9999999;
        if (ConfigValues.debug) {
            r = 1;
        } else if (crop.getSize() == 1) {
            r = 2250;
        } else if (crop.getSize() == 2 && (crop.isBlockBelow("blockQuicksilver") || !OreDictionary.doesOreNameExist((String)"blockQuicksilver"))) {
            r = 1750;
        }
        return r;
    }

    @Override
    public String discoveredBy() {
        return "bartimaeusnek and DreamMasterXXL";
    }

    public boolean canGrow(ICropTile crop) {
        boolean r = false;
        if (ConfigValues.debug) {
            r = crop.getSize() < 3;
        } else if (crop.getSize() <= 1) {
            r = crop.getSize() <= 1;
        } else if (crop.getSize() == 2) {
            r = crop.getSize() == 2 && (crop.isBlockBelow("blockQuicksilver") || !OreDictionary.doesOreNameExist((String)"blockQuicksilver"));
        }
        return r;
    }

    @Override
    public ItemStack getDisplayItem() {
        return OreDict.ISget((String)("crop" + this.name()));
    }

    public ItemStack getGain(ICropTile crop) {
        return OreDict.ISget((String)("crop" + this.name()));
    }

    @Override
    public List<String> getCropInformation() {
        return Collections.singletonList("Needs a block of Quicksilver below to fully mature.");
    }
}

