/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.GTHandler.machines;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class CropGeneExtractor
extends GT_MetaTileEntity_BasicMachine {
    public CropGeneExtractor(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{"It can extract CropGenes", "Use a circuit to determine the genes you want to extract,", "1 for Specimen, 2 for Growth, 3 for Gain, 4 for Resistance", "Takes in 1A", "Needs crop's (tier+2)/2 as Voltage level, round down (Tier 5 crop needs 7/2=~3=HV)"}, 2, 1, "Crop_Gen_Extractor.png", "", new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_SCANNER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_SCANNER), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_SCANNER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_SCANNER), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_SCANNER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_SCANNER), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_SCANNER)});
    }

    public CropGeneExtractor(String mName, byte mTier, String[] mDescriptionArray, ITexture[][][] mTextures, String mGUIName, String mNEIName) {
        super(mName, (int)mTier, 1, mDescriptionArray, mTextures, 2, 1, mGUIName, mNEIName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity arg0) {
        return new CropGeneExtractor(this.mName, this.mTier, this.mDescriptionArray, this.mTextures, this.mGUIName, this.mNEIName);
    }

    public int checkRecipe(boolean skipOC) {
        ItemStack aStack = this.getInputAt(0);
        ItemStack bStack = this.getInputAt(1);
        ItemStack tosave = this.getSpecialSlot();
        if (ItemList.IC2_Crop_Seeds.isStackEqual((Object)bStack, true, true) && ItemList.Circuit_Integrated.isStackEqual((Object)aStack, true, true)) {
            ItemStack helper = bStack;
            bStack = aStack;
            aStack = helper;
            helper = null;
        }
        if (ItemList.IC2_Crop_Seeds.isStackEqual((Object)aStack, true, true) && ItemList.Circuit_Integrated.isStackEqual((Object)bStack, true, true) && ItemList.Tool_DataOrb.isStackEqual((Object)tosave, true, true)) {
            NBTTagCompound tNBT = aStack.func_77978_p();
            if (tNBT == null || tNBT.func_74779_i("name").isEmpty() || tNBT.func_74779_i("name").equals("Primordial Berry")) {
                return 0;
            }
            if (this.getOutputAt(0) != null) {
                return 0;
            }
            byte[] GrGaRe = new byte[3];
            CropCard card = Crops.instance.getCropCard(tNBT.func_74779_i("owner"), tNBT.func_74779_i("name"));
            GrGaRe[0] = tNBT.func_74771_c("growth");
            GrGaRe[1] = tNBT.func_74771_c("gain");
            GrGaRe[2] = tNBT.func_74771_c("resistance");
            this.mOutputItems[0] = ItemList.Tool_DataOrb.get(1L, new Object[0]);
            --aStack.field_77994_a;
            --tosave.field_77994_a;
            switch (bStack.func_77960_j()) {
                case 1: {
                    Behaviour_DataOrb.setDataTitle((ItemStack)this.mOutputItems[0], (String)"Crop-Specimen-Scan");
                    Behaviour_DataOrb.setDataName((ItemStack)this.mOutputItems[0], (String)(tNBT.func_74779_i("owner") + ":" + tNBT.func_74779_i("name")));
                    break;
                }
                case 2: {
                    Behaviour_DataOrb.setDataTitle((ItemStack)this.mOutputItems[0], (String)"Crop-Growth-Scan");
                    Behaviour_DataOrb.setDataName((ItemStack)this.mOutputItems[0], (String)Byte.toString(GrGaRe[0]));
                    break;
                }
                case 3: {
                    Behaviour_DataOrb.setDataTitle((ItemStack)this.mOutputItems[0], (String)"Crop-Gain-Scan");
                    Behaviour_DataOrb.setDataName((ItemStack)this.mOutputItems[0], (String)Byte.toString(GrGaRe[1]));
                    break;
                }
                case 4: {
                    Behaviour_DataOrb.setDataTitle((ItemStack)this.mOutputItems[0], (String)"Crop-Resistance-Scan");
                    Behaviour_DataOrb.setDataName((ItemStack)this.mOutputItems[0], (String)Byte.toString(GrGaRe[2]));
                    break;
                }
            }
            this.calculateOverclockedNess((int)(GT_Values.V[Math.round((card.tier() + 2) / 2)] - GT_Values.V[Math.round((card.tier() + 2) / 2)] / 10L), 6000);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1) {
            GT_Utility.doSoundAtClient((String)((String)GregTech_API.sSoundList.get(212)), (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        }
    }

    public void startProcess() {
        this.sendLoopStart((byte)1);
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        if (ItemList.Circuit_Integrated.isStackEqual((Object)aStack, true, true) || ItemList.IC2_Crop_Seeds.isStackEqual((Object)aStack, true, true)) {
            return this.isValidSlot(aIndex) && aStack != null && aIndex < this.mInventory.length && (this.mInventory[aIndex] == null || GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.mInventory[aIndex])) && this.allowPutStack(this.getBaseMetaTileEntity(), aIndex, (byte)aSide, aStack);
        }
        return false;
    }
}

