/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.crops.cpp;

import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.crops.TC.PrimordialPearlBerryCrop;
import com.github.bartimaeusnek.cropspp.items.CppItems;
import ic2.api.crops.ICropTile;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class MagicModifierCrop
extends PrimordialPearlBerryCrop {
    @Override
    public String name() {
        return "Magical Nightshade";
    }

    @Override
    public int tier() {
        return 13;
    }

    @Override
    public boolean canCross(ICropTile crop) {
        return crop.getSize() == this.maxSize();
    }

    @Override
    public ItemStack getSeeds(ICropTile crop) {
        return crop.generateSeeds(crop.getCrop(), crop.getGrowth(), crop.getGain(), crop.getResistance(), crop.getScanLevel());
    }

    @Override
    public List<String> getCropInformation() {
        return Collections.singletonList("Needs a block of Ichorium below to fully mature.");
    }

    @Override
    public int growthDuration(ICropTile crop) {
        if (ConfigValues.debug) {
            return 1;
        }
        return ConfigValues.PrimordialBerryGroth / 16;
    }

    @Override
    public float dropGainChance() {
        return (float)((double)((float)(Math.pow(0.95, this.tier()) * (double)ConfigValues.BerryGain)) * ((double)ConfigValues.PrimordialBerryGain * 1.5));
    }

    public int getEmittedLight(ICropTile crop) {
        if (crop.getSize() == 4) {
            return 4;
        }
        return 0;
    }

    @Override
    public boolean canGrow(ICropTile crop) {
        boolean ret = false;
        if (crop.getSize() < 3) {
            ret = true;
        } else if (crop.getSize() == 3 && crop.isBlockBelow("blockIchorium") || crop.getSize() == 3 && !OreDictionary.doesOreNameExist((String)"blockIchorium")) {
            ret = true;
        }
        return ret;
    }

    @Override
    public byte getSizeAfterHarvest(ICropTile crop) {
        return 1;
    }

    @Override
    public ItemStack getDisplayItem() {
        return new ItemStack(CppItems.Modifier, 1, 1);
    }

    @Override
    public ItemStack getGain(ICropTile crop) {
        return new ItemStack(CppItems.Modifier, 1, 1);
    }

    @Override
    public String discoveredBy() {
        return "bartimaeusnek";
    }
}

