/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.cropspp.croploader;

import com.github.bartimaeusnek.croploadcore.ModsLoaded;
import com.github.bartimaeusnek.croploadcore.OreDict;
import com.github.bartimaeusnek.croploadcore.config;
import com.github.bartimaeusnek.cropspp.ConfigValues;
import com.github.bartimaeusnek.cropspp.croploader.BoPLoader;
import com.github.bartimaeusnek.cropspp.croploader.DreamCraftLoader;
import com.github.bartimaeusnek.cropspp.croploader.GTLoader;
import com.github.bartimaeusnek.cropspp.croploader.NaturaLoader;
import com.github.bartimaeusnek.cropspp.croploader.TConstructLoader;
import com.github.bartimaeusnek.cropspp.croploader.ThaumcraftLoader;
import com.github.bartimaeusnek.cropspp.croploader.TwilightForestLoader;
import com.github.bartimaeusnek.cropspp.croploader.WitcheryLoader;
import com.github.bartimaeusnek.cropspp.crops.cpp.Bonsais;
import com.github.bartimaeusnek.cropspp.crops.cpp.CactiCrop;
import com.github.bartimaeusnek.cropspp.crops.cpp.GoldfishCrop;
import com.github.bartimaeusnek.cropspp.crops.cpp.GrassCrop;
import com.github.bartimaeusnek.cropspp.crops.cpp.HuckleberryCrop;
import com.github.bartimaeusnek.cropspp.crops.cpp.PapyrusCrop;
import com.github.bartimaeusnek.cropspp.crops.cpp.StrawberryCrop;
import com.github.bartimaeusnek.cropspp.crops.cpp.SugarBeetCrop;
import com.github.bartimaeusnek.cropspp.crops.cpp.VineCrop;
import com.github.bartimaeusnek.cropspp.crops.cpp.WaterlillyCrop;
import com.github.bartimaeusnek.cropspp.crops.natura.BarleyCrop;
import com.github.bartimaeusnek.cropspp.crops.natura.BlackberryCrop;
import com.github.bartimaeusnek.cropspp.crops.natura.BlueberryCrop;
import com.github.bartimaeusnek.cropspp.crops.natura.CottonCrop;
import com.github.bartimaeusnek.cropspp.crops.natura.MaloberryCrop;
import com.github.bartimaeusnek.cropspp.crops.natura.RaspberryCrop;
import com.github.bartimaeusnek.cropspp.crops.natura.SaguaroCrop;
import com.github.bartimaeusnek.cropspp.crops.witchery.GarlicCrop;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CropLoader {
    private static List<Boolean> bHasCropObj = new ArrayList<Boolean>();
    private static List<CropLoader> list = CropLoader.cropLoader();
    private CropCard cropObj;
    private ItemStack baseseed;

    public CropLoader(CropCard cropObj) {
        this.cropObj = cropObj;
    }

    public CropLoader(CropCard cropObj, ItemStack baseseed) {
        this.cropObj = cropObj;
        this.baseseed = baseseed;
    }

    public static CropCard CropunpackerCC(CropLoader inp) {
        return inp.cropObj;
    }

    private static ItemStack CropunpackerCG(CropLoader inp) {
        return inp.baseseed;
    }

    private static CropLoader CropHelper(CropCard cropObj) {
        return new CropLoader(cropObj, OreDict.ISget((String)("crop" + cropObj.name())));
    }

    public static final List<CropLoader> cropLoader() {
        ArrayList<CropLoader> p = new ArrayList<CropLoader>();
        if (Loader.isModLoaded((String)"TwilightForest")) {
            p.addAll(TwilightForestLoader.load());
        }
        if (ModsLoaded.dreamcraft) {
            p.addAll(DreamCraftLoader.load());
        }
        if (ModsLoaded.GT) {
            p.addAll(GTLoader.load());
        }
        if (ModsLoaded.Natura) {
            p.addAll(NaturaLoader.load());
        } else {
            p.add(new CropLoader(new SaguaroCrop(), null));
        }
        if (ModsLoaded.Natura || ModsLoaded.PHC) {
            p.add(new CropLoader(new CottonCrop(), null));
        }
        if (ModsLoaded.TConstruct) {
            p.addAll(TConstructLoader.load());
        }
        if (ModsLoaded.BoP) {
            p.addAll(BoPLoader.BoPLoaderList());
        }
        if (ModsLoaded.TC) {
            p.addAll(ThaumcraftLoader.load());
        }
        if (ModsLoaded.witchery) {
            p.addAll(WitcheryLoader.load());
        }
        if (ModsLoaded.witchery || ModsLoaded.PHC) {
            p.add(new CropLoader(new GarlicCrop(), null));
        }
        if (ModsLoaded.BoP || ModsLoaded.PHC) {
            p.add(new CropLoader(new BarleyCrop(), null));
        }
        p.add(new CropLoader(new VineCrop(), new ItemStack(Item.func_150899_d((int)106), 1, 0)));
        p.add(new CropLoader(new GrassCrop(), new ItemStack(Item.func_150899_d((int)31), 1, 1)));
        p.add(new CropLoader(new CactiCrop(), new ItemStack(Item.func_150899_d((int)81), 1, 0)));
        p.add(new CropLoader(new WaterlillyCrop(), new ItemStack(Item.func_150899_d((int)111), 2)));
        p.add(new CropLoader(new PapyrusCrop(), null));
        p.add(new CropLoader(new GoldfishCrop(), null));
        p.add(new CropLoader(new SugarBeetCrop(), null));
        p.add(new CropLoader(new HuckleberryCrop(), null));
        p.add(new CropLoader(new StrawberryCrop(), null));
        p.add(new CropLoader(new MaloberryCrop(), null));
        p.add(new CropLoader(new BlackberryCrop(), null));
        p.add(new CropLoader(new BlueberryCrop(), null));
        p.add(new CropLoader(new RaspberryCrop(), null));
        return p;
    }

    private static final List<CropCard> cropObjs() {
        ArrayList<CropCard> p = new ArrayList<CropCard>();
        for (int i = 0; i < list.size(); ++i) {
            p.add(CropLoader.CropunpackerCC(list.get(i)));
        }
        return p;
    }

    private static final List<ItemStack> setBaseSeed() {
        ArrayList<ItemStack> p = new ArrayList<ItemStack>();
        for (int i = 0; i < list.size(); ++i) {
            p.add(CropLoader.CropunpackerCG(list.get(i)));
        }
        return p;
    }

    private static final List<String> setnames() {
        ArrayList<String> s = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            s.add(CropLoader.cropObjs().get(i).name());
        }
        return s;
    }

    public static void load(FMLPreInitializationEvent preinit) {
        ConfigValues.c = new config(preinit, "berriespp.cfg");
        ConfigValues.c.tConfig.addCustomCategoryComment("System", "enable or disable system config:\nDebug will set all crops groth duration to 1 and disable all requirements.(aka. \"Cheatmode\")\nBonsai Generation will generate crops from saplings, WiP state. (disabled bc of bugs with metadata, but sure you can try it.)\nWiP Items are not finished items.\nItems will enable/disable all items.");
        ConfigValues.debug = ConfigValues.c.tConfig.get("System", "Debug", false).getBoolean(false);
        ConfigValues.WiPItems = ConfigValues.c.tConfig.get("System", "WiP Items", false).getBoolean(false);
        ConfigValues.Items = ConfigValues.c.tConfig.get("System", "Items", true).getBoolean(true);
        ConfigValues.c.tConfig.addCustomCategoryComment("Crops", "enable single plants here:");
        for (int i = 0; i < list.size(); ++i) {
            bHasCropObj.add(ConfigValues.c.tConfig.get("Crops", CropLoader.setnames().get(i), true).getBoolean(true));
        }
        bHasCropObj.add(ConfigValues.c.tConfig.get("Crops", "Bonsai", true).getBoolean(true));
        ConfigValues.c.tConfig.addCustomCategoryComment("Gain", "Set custom gain modifiers here:\n Tinker's Construct Berries' Gain is not modified by All Crops.\n Primordial Berry's gain is absolut\n Primordial Berry's growth time is divided by 4, in IC2 groth points. F.e. 10 = 40GP per groth-period\n IC2 groth points are calculated by 3 + random 0-7 + statGrowth per 256ticks");
        ConfigValues.BerryGain = (float)ConfigValues.c.tConfig.get("Gain", "All crops", 1.0).getDouble(1.0);
        ConfigValues.TConstructBerryGain = (float)ConfigValues.c.tConfig.get("Gain", "Tinker's Construct berries", 1.0).getDouble(1.0);
        ConfigValues.PrimordialBerryGain = (float)ConfigValues.c.tConfig.get("Gain", "Primordial Berry", 0.5).getDouble(0.5);
        ConfigValues.PrimordialBerryGroth = ConfigValues.c.tConfig.get("Gain", "Primordial Berry growth time", 125000).getInt(125000);
        if (ConfigValues.c.tConfig.hasChanged()) {
            ConfigValues.c.save();
        }
    }

    public static void register() {
        for (int i = 0; i < list.size(); ++i) {
            if (!bHasCropObj.get(i).booleanValue() || CropLoader.cropObjs().get(i) == null) continue;
            Crops.instance.registerCrop(CropLoader.cropObjs().get(i));
        }
        if (bHasCropObj.get(bHasCropObj.size() - 1).booleanValue()) {
            Bonsais.registerAllBonais();
        }
    }

    public static void registerBaseSeed() {
        ArrayList<ItemStack> baseseed = new ArrayList<ItemStack>(CropLoader.setBaseSeed());
        for (int i = 0; i < list.size(); ++i) {
            if (baseseed.get(i) == null || CropLoader.cropObjs().get(i) == null) continue;
            Crops.instance.registerBaseSeed((ItemStack)baseseed.get(i), CropLoader.cropObjs().get(i), 1, 1, 1, 1);
        }
    }
}

