/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.ASM;

import com.github.bartimaeusnek.ASM.CropLoadCoreASM;
import java.util.Arrays;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class CropStickTransformer
implements IClassTransformer {
    private static final String[] classesBeeingTransformed = new String[]{"ic2.core.crop.BlockCrop", "ic2.core.item.tool.ItemWeedingTrowel"};

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean isObfuscated = name.equals(transformedName);
        int index = Arrays.asList(classesBeeingTransformed).indexOf(transformedName);
        return index == 0 ? this.transform(index, 1, this.transform(index, 0, basicClass, isObfuscated), isObfuscated) : (index != -1 ? this.transform(index, 0, basicClass, isObfuscated) : basicClass);
    }

    private byte[] transform(int index, int method, byte[] basicClass, boolean isObfuscated) {
        try {
            switch (index) {
                case 0: {
                    switch (method) {
                        case 0: {
                            CropLoadCoreASM.cppASMlogger.info("Patching CropBlock to be placeable on any soil");
                            String methodToPatch = "canPlaceBlockAt";
                            String methodToPatch_obf = "func_149742_c";
                            String name = !isObfuscated ? "canPlaceBlockAt" : "func_149742_c";
                            String desc = !isObfuscated ? "(Lnet/minecraft/world/World;III)Z" : "(Lahb;III)Z";
                            ClassReader reader = new ClassReader(basicClass);
                            ClassNode classNode = new ClassNode();
                            reader.accept((ClassVisitor)classNode, 0);
                            List methods = classNode.methods;
                            for (MethodNode methodNode : methods) {
                                if (!methodNode.name.equals(name)) continue;
                                InsnList insnList = new InsnList();
                                insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                                insnList.add((AbstractInsnNode)new VarInsnNode(21, 2));
                                insnList.add((AbstractInsnNode)new VarInsnNode(21, 3));
                                insnList.add((AbstractInsnNode)new VarInsnNode(21, 4));
                                insnList.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/bartimaeusnek/ASM/CropStickTransformerReplaceMethod", "patchedcanPlaceBlockAt", desc, false));
                                insnList.add((AbstractInsnNode)new InsnNode(172));
                                methodNode.instructions = insnList;
                            }
                            ClassWriter cw = new ClassWriter(reader, 11);
                            classNode.accept((ClassVisitor)cw);
                            return cw.toByteArray();
                        }
                        case 1: {
                            CropLoadCoreASM.cppASMlogger.info("Patching CropBlock to not pop off when neighbours change");
                            String methodToPatch = "onNeighborBlockChange";
                            String methodToPatch_obf = "func_149695_a";
                            String name = !isObfuscated ? methodToPatch : methodToPatch_obf;
                            String desc = !isObfuscated ? "(Lnet/minecraft/world/World;IIILnet/minecraft/block/Block;)V" : "(Lahb;IIILaji;)V";
                            ClassReader reader = new ClassReader(basicClass);
                            ClassNode classNode = new ClassNode();
                            reader.accept((ClassVisitor)classNode, 0);
                            List methods = classNode.methods;
                            for (MethodNode methodNode : methods) {
                                if (!methodNode.name.equals(name)) continue;
                                InsnList insnList = new InsnList();
                                insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                                insnList.add((AbstractInsnNode)new VarInsnNode(21, 2));
                                insnList.add((AbstractInsnNode)new VarInsnNode(21, 3));
                                insnList.add((AbstractInsnNode)new VarInsnNode(21, 4));
                                insnList.add((AbstractInsnNode)new VarInsnNode(25, 5));
                                insnList.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/bartimaeusnek/ASM/CropStickTransformerReplaceMethod", "patchedonNeighborBlockChange", desc, false));
                                insnList.add((AbstractInsnNode)new InsnNode(177));
                                methodNode.instructions = insnList;
                            }
                            ClassWriter cw = new ClassWriter(reader, 11);
                            classNode.accept((ClassVisitor)cw);
                            return cw.toByteArray();
                        }
                    }
                }
                case 1: {
                    CropLoadCoreASM.cppASMlogger.info("Patching WeedingTrowel to accept custom Weeds");
                    String name = "onItemUseFirst";
                    String desc = !isObfuscated ? "(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/world/World;IIIIFFF)Z" : "(Ladd;Lyz;Lahb;IIIIFFF)Z";
                    ClassReader reader = new ClassReader(basicClass);
                    ClassNode classNode = new ClassNode();
                    reader.accept((ClassVisitor)classNode, 0);
                    List methods = classNode.methods;
                    for (MethodNode methodNode : methods) {
                        if (!methodNode.name.equals(name)) continue;
                        InsnList insnList = new InsnList();
                        insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                        insnList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                        insnList.add((AbstractInsnNode)new VarInsnNode(25, 3));
                        insnList.add((AbstractInsnNode)new VarInsnNode(21, 4));
                        insnList.add((AbstractInsnNode)new VarInsnNode(21, 5));
                        insnList.add((AbstractInsnNode)new VarInsnNode(21, 6));
                        insnList.add((AbstractInsnNode)new VarInsnNode(21, 7));
                        insnList.add((AbstractInsnNode)new VarInsnNode(23, 8));
                        insnList.add((AbstractInsnNode)new VarInsnNode(23, 9));
                        insnList.add((AbstractInsnNode)new VarInsnNode(23, 10));
                        insnList.add((AbstractInsnNode)new MethodInsnNode(184, "com/github/bartimaeusnek/ASM/CropStickTransformerReplaceMethod", "patchedonItemUseFirst", desc, false));
                        insnList.add((AbstractInsnNode)new InsnNode(172));
                        methodNode.instructions = insnList;
                    }
                    ClassWriter cw = new ClassWriter(reader, 11);
                    classNode.accept((ClassVisitor)cw);
                    return cw.toByteArray();
                }
            }
            return basicClass;
        }
        catch (Exception e) {
            e.printStackTrace();
            return basicClass;
        }
    }
}

